/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation;

import androidx.compose.animation.EnterExitState;
import androidx.compose.animation.EnterExitTransitionModifierNode;
import androidx.compose.animation.EnterTransition;
import androidx.compose.animation.ExitTransition;
import androidx.compose.animation.GraphicsLayerBlockForEnterExit;
import androidx.compose.animation.core.AnimationVector2D;
import androidx.compose.animation.core.Transition;
import androidx.compose.ui.node.ModifierNodeElement;
import androidx.compose.ui.unit.IntOffset;
import androidx.compose.ui.unit.IntSize;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class EnterExitTransitionElement
extends ModifierNodeElement<EnterExitTransitionModifierNode> {
    @NotNull
    private final Transition<EnterExitState> transition;
    @Nullable
    private Transition.DeferredAnimation<IntSize, AnimationVector2D> sizeAnimation;
    @Nullable
    private Transition.DeferredAnimation<IntOffset, AnimationVector2D> offsetAnimation;
    @Nullable
    private Transition.DeferredAnimation<IntOffset, AnimationVector2D> slideAnimation;
    @NotNull
    private EnterTransition enter;
    @NotNull
    private ExitTransition exit;
    @NotNull
    private Function0<Boolean> isEnabled;
    @NotNull
    private GraphicsLayerBlockForEnterExit graphicsLayerBlock;

    public EnterExitTransitionElement(@NotNull Transition<EnterExitState> transition, @Nullable Transition.DeferredAnimation<IntSize, AnimationVector2D> sizeAnimation, @Nullable Transition.DeferredAnimation<IntOffset, AnimationVector2D> offsetAnimation, @Nullable Transition.DeferredAnimation<IntOffset, AnimationVector2D> slideAnimation, @NotNull EnterTransition enter, @NotNull ExitTransition exit2, @NotNull Function0<Boolean> isEnabled, @NotNull GraphicsLayerBlockForEnterExit graphicsLayerBlock) {
        Intrinsics.checkNotNullParameter(transition, (String)"transition");
        Intrinsics.checkNotNullParameter((Object)enter, (String)"enter");
        Intrinsics.checkNotNullParameter((Object)exit2, (String)"exit");
        Intrinsics.checkNotNullParameter(isEnabled, (String)"isEnabled");
        Intrinsics.checkNotNullParameter((Object)graphicsLayerBlock, (String)"graphicsLayerBlock");
        this.transition = transition;
        this.sizeAnimation = sizeAnimation;
        this.offsetAnimation = offsetAnimation;
        this.slideAnimation = slideAnimation;
        this.enter = enter;
        this.exit = exit2;
        this.isEnabled = isEnabled;
        this.graphicsLayerBlock = graphicsLayerBlock;
    }

    @Override
    @NotNull
    public EnterExitTransitionModifierNode create() {
        return new EnterExitTransitionModifierNode(this.transition, this.sizeAnimation, this.offsetAnimation, this.slideAnimation, this.enter, this.exit, this.isEnabled, this.graphicsLayerBlock);
    }

    @Override
    public void update(@NotNull EnterExitTransitionModifierNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        node2.setTransition(this.transition);
        node2.setSizeAnimation(this.sizeAnimation);
        node2.setOffsetAnimation(this.offsetAnimation);
        node2.setSlideAnimation(this.slideAnimation);
        node2.setEnter(this.enter);
        node2.setExit(this.exit);
        node2.setEnabled(this.isEnabled);
        node2.setGraphicsLayerBlock(this.graphicsLayerBlock);
    }

    @NotNull
    public String toString() {
        return "EnterExitTransitionElement(transition=" + this.transition + ", sizeAnimation=" + this.sizeAnimation + ", offsetAnimation=" + this.offsetAnimation + ", slideAnimation=" + this.slideAnimation + ", enter=" + this.enter + ", exit=" + this.exit + ", isEnabled=" + this.isEnabled + ", graphicsLayerBlock=" + this.graphicsLayerBlock + ")";
    }

    public int hashCode() {
        int result2 = this.transition.hashCode();
        result2 = result2 * 31 + (this.sizeAnimation == null ? 0 : this.sizeAnimation.hashCode());
        result2 = result2 * 31 + (this.offsetAnimation == null ? 0 : this.offsetAnimation.hashCode());
        result2 = result2 * 31 + (this.slideAnimation == null ? 0 : this.slideAnimation.hashCode());
        result2 = result2 * 31 + this.enter.hashCode();
        result2 = result2 * 31 + this.exit.hashCode();
        result2 = result2 * 31 + this.isEnabled.hashCode();
        result2 = result2 * 31 + this.graphicsLayerBlock.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EnterExitTransitionElement)) {
            return false;
        }
        EnterExitTransitionElement enterExitTransitionElement = (EnterExitTransitionElement)other;
        if (!Intrinsics.areEqual(this.transition, enterExitTransitionElement.transition)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.sizeAnimation, enterExitTransitionElement.sizeAnimation)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.offsetAnimation, enterExitTransitionElement.offsetAnimation)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.slideAnimation, enterExitTransitionElement.slideAnimation)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.enter, (Object)enterExitTransitionElement.enter)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.exit, (Object)enterExitTransitionElement.exit)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.isEnabled, enterExitTransitionElement.isEnabled)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.graphicsLayerBlock, (Object)enterExitTransitionElement.graphicsLayerBlock);
    }
}

