/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation;

import androidx.compose.animation.SplineBasedDecayKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidFlingSpline {
    @NotNull
    public static final AndroidFlingSpline INSTANCE = new AndroidFlingSpline();
    @NotNull
    private static final float[] SplinePositions = new float[101];
    @NotNull
    private static final float[] SplineTimes = new float[101];
    public static final int $stable;

    private AndroidFlingSpline() {
    }

    @NotNull
    public final FlingResult flingPosition(float time2) {
        float clampedTime = RangesKt.coerceIn((float)time2, (float)0.0f, (float)1.0f);
        int index = (int)((float)100 * clampedTime);
        float distanceCoef = 1.0f;
        float velocityCoef = 0.0f;
        if (index < 100) {
            float tInf = (float)index / (float)100;
            float tSup = (float)(index + 1) / (float)100;
            float dInf = SplinePositions[index];
            float dSup = SplinePositions[index + 1];
            velocityCoef = (dSup - dInf) / (tSup - tInf);
            distanceCoef = dInf + (clampedTime - tInf) * velocityCoef;
        }
        return new FlingResult(distanceCoef, velocityCoef);
    }

    public final double deceleration(float velocity, float friction) {
        return Math.log((double)(0.35f * Math.abs(velocity)) / (double)friction);
    }

    static {
        SplineBasedDecayKt.access$computeSplineInfo(SplinePositions, SplineTimes, 100);
        $stable = 8;
    }

    public static final class FlingResult {
        private final float distanceCoefficient;
        private final float velocityCoefficient;

        public FlingResult(float distanceCoefficient, float velocityCoefficient) {
            this.distanceCoefficient = distanceCoefficient;
            this.velocityCoefficient = velocityCoefficient;
        }

        public final float getDistanceCoefficient() {
            return this.distanceCoefficient;
        }

        public final float getVelocityCoefficient() {
            return this.velocityCoefficient;
        }

        @NotNull
        public String toString() {
            return "FlingResult(distanceCoefficient=" + this.distanceCoefficient + ", velocityCoefficient=" + this.velocityCoefficient + ")";
        }

        public int hashCode() {
            int result2 = Float.hashCode(this.distanceCoefficient);
            result2 = result2 * 31 + Float.hashCode(this.velocityCoefficient);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FlingResult)) {
                return false;
            }
            FlingResult flingResult = (FlingResult)other;
            if (Float.compare(this.distanceCoefficient, flingResult.distanceCoefficient) != 0) {
                return false;
            }
            return Float.compare(this.velocityCoefficient, flingResult.velocityCoefficient) == 0;
        }
    }
}

