/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.nlp.tokenizer.rule;

import ai.grazie.Direction;
import ai.grazie.nlp.patterns.Pattern;
import ai.grazie.nlp.tokenizer.NonDestructiveTokenizer;
import ai.grazie.nlp.tokenizer.Tokenizer;
import ai.grazie.text.Text;
import ai.grazie.text.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000e2\u0006\u0010\u0010\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lai/grazie/nlp/tokenizer/rule/PatternSplitTokenizer;", "Lai/grazie/nlp/tokenizer/NonDestructiveTokenizer;", "pattern", "Lai/grazie/nlp/patterns/Pattern;", "direction", "Lai/grazie/Direction;", "ignore", "<init>", "(Lai/grazie/nlp/patterns/Pattern;Lai/grazie/Direction;Lai/grazie/nlp/patterns/Pattern;)V", "getPattern", "()Lai/grazie/nlp/patterns/Pattern;", "getDirection", "()Lai/grazie/Direction;", "tokenize", "", "Lai/grazie/nlp/tokenizer/Tokenizer$Token;", "text", "Lai/grazie/text/Text;", "tokenRanges", "Lai/grazie/text/TextRange;", "", "isEdgeMatch", "", "range", "nlp-tokenizer"})
@SourceDebugExtension(value={"SMAP\nPatternSplitTokenizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PatternSplitTokenizer.kt\nai/grazie/nlp/tokenizer/rule/PatternSplitTokenizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,45:1\n1557#2:46\n1628#2,3:47\n827#2:50\n855#2:51\n1755#2,3:52\n856#2:55\n1053#2:56\n774#2:57\n865#2,2:58\n*S KotlinDebug\n*F\n+ 1 PatternSplitTokenizer.kt\nai/grazie/nlp/tokenizer/rule/PatternSplitTokenizer\n*L\n17#1:46\n17#1:47,3\n27#1:50\n27#1:51\n27#1:52,3\n27#1:55\n27#1:56\n39#1:57\n39#1:58,2\n*E\n"})
public final class PatternSplitTokenizer
implements NonDestructiveTokenizer {
    @NotNull
    private final Pattern pattern;
    @NotNull
    private final Direction direction;
    @Nullable
    private final Pattern ignore;

    public PatternSplitTokenizer(@NotNull Pattern pattern, @NotNull Direction direction, @Nullable Pattern ignore) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        this.pattern = pattern;
        this.direction = direction;
        this.ignore = ignore;
    }

    @NotNull
    public final Pattern getPattern() {
        return this.pattern;
    }

    @NotNull
    public final Direction getDirection() {
        return this.direction;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Tokenizer.Token> tokenize(@NotNull Text text) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Iterable $this$map$iv = this.tokenRanges((CharSequence)text);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TextRange textRange = (TextRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Tokenizer.Token(text.substring((TextRange)it), (TextRange)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TextRange> tokenRanges(@NotNull CharSequence text) {
        void $this$filterTo$iv$iv;
        void $this$sortedBy$iv;
        Iterator $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        List rawMatches = this.pattern.find(text);
        if (rawMatches.isEmpty() || rawMatches.size() == 1 && this.isEdgeMatch(text, (TextRange)rawMatches.get(0))) {
            return text.length() == 0 ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)new TextRange(0, text.length()));
        }
        Object object = this.ignore;
        if (object == null || (object = object.find(text)) == null) {
            object = CollectionsKt.emptyList();
        }
        Object ignore = object;
        Iterable $this$filterNot$iv = rawMatches;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        Iterator iterator = $this$filterNotTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            Object element$iv$iv;
            block12: {
                element$iv$iv = iterator.next();
                TextRange match = (TextRange)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = (Iterable)ignore;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        TextRange it = (TextRange)element$iv;
                        boolean bl3 = false;
                        if (!it.intersects(match)) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
            }
            if (bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List matches = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                TextRange it = (TextRange)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getStart());
                it = (TextRange)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStart()));
            }
        });
        ArrayList<TextRange> ranges = new ArrayList<TextRange>();
        int start = 0;
        for (TextRange match : matches) {
            int endExclusive = switch (WhenMappings.$EnumSwitchMapping$0[this.direction.ordinal()]) {
                case 1 -> Math.max(match.getStart() - 1, start);
                case 2 -> Math.max(match.getEndExclusive(), start);
                default -> throw new NoWhenBranchMatchedException();
            };
            ranges.add(new TextRange(start, endExclusive));
            start = endExclusive;
        }
        ranges.add(new TextRange(start, text.length()));
        Iterable $this$filter$iv = ranges;
        boolean $i$f$filter = false;
        Iterable endExclusive = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TextRange it = (TextRange)element$iv$iv;
            boolean bl = false;
            if (!it.isNotEmpty()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    private final boolean isEdgeMatch(CharSequence text, TextRange range) {
        return this.direction == Direction.Right && range.getEndExclusive() == text.length() || this.direction == Direction.Left && range.getStart() == 0;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.Left.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.Right.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

