/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.spi.message;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.MessageProtocolVersionException;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.messages.MessageFactory;
import org.freedesktop.dbus.spi.message.IMessageReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputStreamMessageReader
implements IMessageReader {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SocketChannel inputChannel;
    private byte[] buf;
    private byte[] tbuf;
    private byte[] header;
    private byte[] body;
    private int[] len;

    public InputStreamMessageReader(SocketChannel _in) {
        this.inputChannel = _in;
        this.len = new int[4];
    }

    @Override
    public Message readMessage() throws IOException, DBusException {
        Message m;
        int rv;
        if (null == this.buf) {
            this.buf = new byte[12];
            this.len[0] = 0;
        }
        if (this.len[0] < 12) {
            try {
                ByteBuffer wrapBuf = ByteBuffer.wrap(this.buf, this.len[0], 12 - this.len[0]);
                rv = this.inputChannel.read(wrapBuf);
            }
            catch (SocketTimeoutException exSt) {
                return null;
            }
            catch (EOFException _ex) {
                return null;
            }
            catch (IOException _ex) {
                throw _ex;
            }
            if (-1 == rv) {
                throw new EOFException("Underlying transport returned EOF (1)");
            }
            this.len[0] = this.len[0] + rv;
        }
        if (this.len[0] == 0) {
            return null;
        }
        if (this.len[0] < 12) {
            this.logger.trace("Only got {} of 12 bytes of header", (Object)this.len[0]);
            return null;
        }
        byte endian = this.buf[0];
        byte type = this.buf[1];
        byte protover = this.buf[3];
        if (protover > 1) {
            throw new MessageProtocolVersionException(String.format("Protocol version %s is unsupported", protover));
        }
        if (null == this.tbuf) {
            this.tbuf = new byte[4];
            this.len[1] = 0;
        }
        if (this.len[1] < 4) {
            try {
                rv = this.inputChannel.read(ByteBuffer.wrap(this.tbuf, this.len[1], 4 - this.len[1]));
            }
            catch (SocketTimeoutException exSt) {
                return null;
            }
            if (-1 == rv) {
                throw new EOFException("Underlying transport returned EOF (2)");
            }
            this.len[1] = this.len[1] + rv;
        }
        if (this.len[1] < 4) {
            this.logger.trace("Only got {} of 4 bytes of header", (Object)this.len[1]);
            return null;
        }
        int headerlen = 0;
        if (null == this.header) {
            headerlen = (int)Message.demarshallint(this.tbuf, 0, endian, 4);
            if (0 != headerlen % 8) {
                headerlen += 8 - headerlen % 8;
            }
        } else {
            headerlen = this.header.length - 8;
        }
        if (null == this.header) {
            this.header = new byte[headerlen + 8];
            System.arraycopy(this.tbuf, 0, this.header, 0, 4);
            this.len[2] = 0;
        }
        if (this.len[2] < headerlen) {
            try {
                rv = this.inputChannel.read(ByteBuffer.wrap(this.header, 8 + this.len[2], headerlen - this.len[2]));
            }
            catch (SocketTimeoutException exSt) {
                return null;
            }
            if (-1 == rv) {
                throw new EOFException("Underlying transport returned EOF (3)");
            }
            this.len[2] = this.len[2] + rv;
        }
        if (this.len[2] < headerlen) {
            this.logger.trace("Only got {} of {} bytes of header", (Object)this.len[2], (Object)headerlen);
            return null;
        }
        int bodylen = 0;
        if (null == this.body) {
            bodylen = (int)Message.demarshallint(this.buf, 4, endian, 4);
        }
        if (null == this.body) {
            this.body = new byte[bodylen];
            this.len[3] = 0;
        }
        if (this.len[3] < this.body.length) {
            try {
                rv = this.inputChannel.read(ByteBuffer.wrap(this.body, this.len[3], this.body.length - this.len[3]));
            }
            catch (SocketTimeoutException exSt) {
                return null;
            }
            if (-1 == rv) {
                throw new EOFException("Underlying transport returned EOF (4)");
            }
            this.len[3] = this.len[3] + rv;
        }
        if (this.len[3] < this.body.length) {
            this.logger.trace("Only got {} of {} bytes of body", (Object)this.len[3], (Object)this.body.length);
            return null;
        }
        try {
            m = MessageFactory.createMessage(type, this.buf, this.header, this.body, null);
        }
        catch (RuntimeException | DBusException _ex) {
            if (_ex instanceof RuntimeException) {
                this.logger.error("Runtime exception while creating message.", (Throwable)_ex);
            } else {
                this.logger.debug("", (Throwable)_ex);
            }
            this.tbuf = null;
            this.body = null;
            this.header = null;
            this.buf = null;
            throw _ex;
        }
        this.logger.debug("=> {}", (Object)m);
        this.tbuf = null;
        this.body = null;
        this.header = null;
        this.buf = null;
        return m;
    }

    @Override
    public void close() throws IOException {
        this.logger.trace("Closing Message Reader");
        if (this.inputChannel != null && this.inputChannel.isOpen()) {
            this.inputChannel.close();
        }
        this.inputChannel = null;
    }

    @Override
    public boolean isClosed() {
        return this.inputChannel != null && !this.inputChannel.isOpen();
    }
}

