/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.nlp.utils;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.text.CharCategory;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lai/grazie/nlp/utils/CharUtils;", "", "()V", "SOFT_HYPHEN", "", "getSOFT_HYPHEN", "()C", "controlChars", "", "Lkotlin/text/CharCategory;", "punctuationChars", "isControl", "", "char", "isPunctuation", "nlp-common"})
public final class CharUtils {
    @NotNull
    public static final CharUtils INSTANCE = new CharUtils();
    @NotNull
    private static final Set<CharCategory> controlChars;
    @NotNull
    private static final Set<CharCategory> punctuationChars;
    private static final char SOFT_HYPHEN;

    private CharUtils() {
    }

    public final boolean isPunctuation(char c) {
        block5: {
            block4: {
                if (punctuationChars.contains(CharsKt.getCategory((char)c))) {
                    return true;
                }
                char c2 = c;
                if ('!' <= c2 ? c2 < '0' : false) break block4;
                c2 = c;
                if (':' <= c2 ? c2 < 'A' : false) break block4;
                c2 = c;
                if ('[' <= c2 ? c2 < 'a' : false) break block4;
                c2 = c;
                boolean bl = '{' <= c2 ? c2 < '\u007f' : false;
                if (!bl) break block5;
            }
            return true;
        }
        return false;
    }

    public final boolean isControl(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': {
                return false;
            }
        }
        return controlChars.contains(CharsKt.getCategory((char)c));
    }

    public final char getSOFT_HYPHEN() {
        return SOFT_HYPHEN;
    }

    static {
        Object[] objectArray = new CharCategory[]{CharCategory.UNASSIGNED, CharCategory.CONTROL, CharCategory.FORMAT, CharCategory.PRIVATE_USE, CharCategory.SURROGATE};
        controlChars = SetsKt.setOf((Object[])objectArray);
        objectArray = new CharCategory[]{CharCategory.DASH_PUNCTUATION, CharCategory.CONNECTOR_PUNCTUATION, CharCategory.END_PUNCTUATION, CharCategory.START_PUNCTUATION, CharCategory.OTHER_PUNCTUATION, CharCategory.INITIAL_QUOTE_PUNCTUATION, CharCategory.FINAL_QUOTE_PUNCTUATION};
        punctuationChars = SetsKt.setOf((Object[])objectArray);
        SOFT_HYPHEN = (char)173;
    }
}

