/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.nlp.tokenizer.sentence;

import ai.grazie.Direction;
import ai.grazie.nlp.langs.Language;
import ai.grazie.nlp.patterns.AggregatedPattern;
import ai.grazie.nlp.patterns.Pattern;
import ai.grazie.nlp.patterns.RegexPattern;
import ai.grazie.nlp.patterns.ext.AbbreviationPatterns;
import ai.grazie.nlp.patterns.standard.LikelyPatterns;
import ai.grazie.nlp.patterns.standard.StrictPatterns;
import ai.grazie.nlp.tokenizer.Tokenizer;
import ai.grazie.nlp.tokenizer.rule.PatternSplitTokenizer;
import ai.grazie.nlp.tokenizer.sentence.StandardSentenceTokenizer;
import ai.grazie.nlp.utils.normalization.UnicodePunctuationNormalizer;
import ai.grazie.text.ExtensionsKt;
import ai.grazie.text.Text;
import ai.grazie.text.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000K\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u000e\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0013\b\u0017\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00112\u0006\u0010\u0013\u001a\u00020\u0017H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer;", "Lai/grazie/nlp/tokenizer/Tokenizer;", "splitByNewLinesNumber", "", "(Ljava/lang/Integer;)V", "language", "Lai/grazie/nlp/langs/Language;", "(Ljava/lang/Integer;Lai/grazie/nlp/langs/Language;)V", "ignore", "Lai/grazie/nlp/patterns/AggregatedPattern;", "newLineTokenizer", "Lai/grazie/nlp/tokenizer/rule/PatternSplitTokenizer;", "punctuationTokenizer", "newLinesPattern", "ai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$newLinesPattern$1", "(I)Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$newLinesPattern$1;", "tokenRanges", "", "Lai/grazie/text/TextRange;", "text", "", "tokenize", "Lai/grazie/nlp/tokenizer/Tokenizer$Token;", "Lai/grazie/text/Text;", "Companion", "nlp-tokenizer"})
@SourceDebugExtension(value={"SMAP\nStandardSentenceTokenizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StandardSentenceTokenizer.kt\nai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,200:1\n1557#2:201\n1628#2,3:202\n1368#2:205\n1454#2,2:206\n1557#2:208\n1628#2,3:209\n1456#2,3:212\n*S KotlinDebug\n*F\n+ 1 StandardSentenceTokenizer.kt\nai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer\n*L\n188#1:201\n188#1:202,3\n194#1:205\n194#1:206,2\n195#1:208\n195#1:209,3\n194#1:212,3\n*E\n"})
public final class StandardSentenceTokenizer
implements Tokenizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final PatternSplitTokenizer newLineTokenizer;
    @NotNull
    private final AggregatedPattern ignore;
    @NotNull
    private final PatternSplitTokenizer punctuationTokenizer;
    @NotNull
    private static final String quotes = "'\"`\u2018\u2019" + CollectionsKt.joinToString$default((Iterable)UnicodePunctuationNormalizer.Companion.getDoubleQuotes(), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    @NotNull
    private static final Companion.Parenthetical.1 Parenthetical;
    @NotNull
    private static final Companion.Ellipsis.1.1 Ellipsis;
    @NotNull
    private static final Companion.QuotedStuff.1 QuotedStuff;
    @NotNull
    private static final String normalSentenceEnd;
    @NotNull
    private static final String romanBullet;
    @NotNull
    private static final String bulletContents = "[\\d\\p{L}]{1,3}(\\.[\\d\\p{L}]{1,3})*";
    @NotNull
    private static final String braceBullet = "(^|\n)(\\([\\d\\p{L}]{1,3}(\\.[\\d\\p{L}]{1,3})*\\)|\\[[\\d\\p{L}]{1,3}(\\.[\\d\\p{L}]{1,3})*\\])";
    @NotNull
    private static final String spaceOrEnd = "\n+|\\s+|$";
    @NotNull
    private static final Regex sentenceContinuation;
    @NotNull
    private static final Companion.endPunctuation.1 endPunctuation;
    @NotNull
    private static final Pattern nextLineStartsWithBullet;
    @NotNull
    private static final StandardSentenceTokenizer Default;

    public StandardSentenceTokenizer(@Nullable Integer splitByNewLinesNumber, @NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        this.newLineTokenizer = splitByNewLinesNumber == null ? null : new PatternSplitTokenizer((Pattern)this.newLinesPattern(splitByNewLinesNumber), Direction.Right, null);
        Object[] objectArray = new Pattern[]{Parenthetical, Ellipsis, QuotedStuff, LikelyPatterns.NameInitials, LikelyPatterns.PunctuationOperator, LikelyPatterns.IsEmail, AbbreviationPatterns.forSentenceTokenization((Language)language), language == Language.UNKNOWN || language == Language.GERMAN ? LikelyPatterns.IsGermanOrdinal : null, language == Language.UNKNOWN || language == Language.GERMAN ? LikelyPatterns.IsGermanOrdinalAfterNames : null, language == Language.UNKNOWN || language == Language.GERMAN ? LikelyPatterns.IsGermanDateWithDot : null, language == Language.UNKNOWN || language == Language.GERMAN ? LikelyPatterns.IsGermanStreetName : null, LikelyPatterns.IsIPv4, LikelyPatterns.IsURL, LikelyPatterns.IsFilePath, StrictPatterns.INSTANCE.getIsUUID(), LikelyPatterns.IsDotInBashCommand, LikelyPatterns.IsInnerSentenceInQuotes};
        this.ignore = new AggregatedPattern(CollectionsKt.listOfNotNull((Object[])objectArray));
        objectArray = new Pattern[]{endPunctuation, nextLineStartsWithBullet};
        this.punctuationTokenizer = new PatternSplitTokenizer((Pattern)new AggregatedPattern((Pattern[])objectArray), Direction.Right, (Pattern)this.ignore);
    }

    public /* synthetic */ StandardSentenceTokenizer(Integer n, Language language, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 2;
        }
        this(n, language);
    }

    @Deprecated(message="Specify the language")
    public StandardSentenceTokenizer(@Nullable Integer splitByNewLinesNumber) {
        this(splitByNewLinesNumber, Language.UNKNOWN);
    }

    public /* synthetic */ StandardSentenceTokenizer(Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 2;
        }
        this(n);
    }

    private final newLinesPattern.1 newLinesPattern(int splitByNewLinesNumber) {
        Regex regex = new Regex("\n{" + splitByNewLinesNumber + ",}");
        return new RegexPattern(regex){

            public List<TextRange> find(CharSequence text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                return super.find(text);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Tokenizer.Token> tokenize(@NotNull Text text) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Iterable $this$map$iv = this.tokenRanges((CharSequence)text);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TextRange textRange = (TextRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Tokenizer.Token(text.substring((TextRange)it), (TextRange)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TextRange> tokenRanges(@NotNull CharSequence text) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Object object = this.newLineTokenizer;
        if (object == null || (object = ((PatternSplitTokenizer)object).tokenRanges(text)) == null) {
            object = CollectionsKt.listOf((Object)new TextRange(0, text.length()));
        }
        Object hard = object;
        Iterable $this$flatMap$iv = (Iterable)hard;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            TextRange chunk = (TextRange)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = this.punctuationTokenizer.tokenRanges(text.subSequence(chunk.getStart(), chunk.getEndExclusive()));
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TextRange textRange = (TextRange)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(ExtensionsKt.withOffset((TextRange)it, (int)chunk.getStart()));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @JvmStatic
    @NotNull
    public static final StandardSentenceTokenizer defaultFor(@NotNull Language language) {
        return Companion.defaultFor(language);
    }

    public static final /* synthetic */ String access$getQuotes$cp() {
        return quotes;
    }

    public static final /* synthetic */ String access$getNormalSentenceEnd$cp() {
        return normalSentenceEnd;
    }

    public static final /* synthetic */ String access$getRomanBullet$cp() {
        return romanBullet;
    }

    public static final /* synthetic */ Regex access$getSentenceContinuation$cp() {
        return sentenceContinuation;
    }

    static {
        Regex regex = new Regex[]{StandardSentenceTokenizer.Companion.pairedParentheses(), StandardSentenceTokenizer.Companion.pairedDashes()};
        Regex regex2 = regex;
        Parenthetical = new AggregatedPattern((Pattern[])regex2){

            public List<TextRange> find(CharSequence text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                return super.find(text);
            }
        };
        Companion $this$Ellipsis_u24lambda_u243 = Companion;
        boolean bl = false;
        Ellipsis = new Pattern(){

            public List<TextRange> find(CharSequence text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                ArrayList<TextRange> result = new ArrayList<TextRange>();
                int n = text.length();
                for (int i = 0; i < n; ++i) {
                    if (text.charAt(i) == '.' && i < text.length() - 2 && text.charAt(i + 2) == '.') {
                        int end;
                        if (this.isSpacedEllipsis(i, text)) {
                            result.add(new TextRange(i, i + 5));
                            continue;
                        }
                        if (text.charAt(i + 1) != '.') continue;
                        for (end = i + 3; end < text.length() && text.charAt(end) == '.'; ++end) {
                        }
                        if (!this.isEllipsisMatch(i, end, text)) continue;
                        result.add(new TextRange(i, end));
                        continue;
                    }
                    if (text.charAt(i) != '\u2026' || !this.isEllipsisMatch(i, i + 1, text)) continue;
                    result.add(new TextRange(i, i + 1));
                }
                return result;
            }

            private final boolean isSpacedEllipsis(int i, CharSequence text) {
                return i + 4 < text.length() && text.charAt(i + 4) == '.' && CharsKt.isWhitespace((char)text.charAt(i + 1)) && CharsKt.isWhitespace((char)text.charAt(i + 3));
            }

            private final boolean isEllipsisMatch(int start, int end, CharSequence text) {
                return this.isForOmittedSentenceParts(start, end, text) || this.isActionNameEllipsis(start, end, text);
            }

            private final boolean isActionNameEllipsis(int start, int end, CharSequence text) {
                return start > 0 && Character.isLetter(text.charAt(start - 1)) && end + 1 < text.length() && CharsKt.isWhitespace((char)text.charAt(end)) && Character.isLowerCase(text.charAt(end + 1));
            }

            private final boolean isForOmittedSentenceParts(int start, int end, CharSequence text) {
                return (start == 0 || CharsKt.isWhitespace((char)text.charAt(start - 1)) || StringsKt.contains$default((CharSequence)StandardSentenceTokenizer.access$getQuotes$cp(), (char)text.charAt(start - 1), (boolean)false, (int)2, null)) && (end == text.length() || CharsKt.isWhitespace((char)text.charAt(end)) || StringsKt.contains$default((CharSequence)StandardSentenceTokenizer.access$getQuotes$cp(), (char)text.charAt(end), (boolean)false, (int)2, null)) || start > 0 && end < text.length() && text.charAt(start - 1) == '[' && text.charAt(end) == ']';
            }
        };
        regex2 = new Regex("[" + quotes + "]([\\p{L}\\s\\d]{1,42}(\\.{3,}|\u2026)[" + quotes + "]\\s+\\p{Ll}|\\p{L}+\\.[" + quotes + "]([,;:]|\\s+\\p{Ll})|[^\\s\\p{L}]*[" + quotes + "])");
        QuotedStuff = new RegexPattern(regex2){

            public List<TextRange> find(CharSequence text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                return super.find(text);
            }
        };
        normalSentenceEnd = "[?!.]+[)}\\]" + quotes + "]?";
        String string2 = "IVXLMCD".toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        romanBullet = "(^|\n)([IVXLMCD]{1,4}|[" + string2 + "]{1,4})\\)";
        Companion $this$sentenceContinuation_u24lambda_u244 = Companion;
        boolean bl2 = false;
        String dashes = "(\\s+[-\u2013\u2014]+)";
        String emotionalPunctuation = "([?!]\\.*|([:;]-?[()]+))";
        String directSpeechEnd = "(\\?[" + quotes + "]|!(\\.+[" + quotes + "]?|\\.*[" + quotes + "])|\\.{3,}[" + quotes + "?]*)";
        sentenceContinuation = new Regex("(" + directSpeechEnd + dashes + "?|" + emotionalPunctuation + dashes + ")\\s+([\\[({<])?\\p{Ll}");
        endPunctuation = new Pattern(){
            private final char[] startChars;
            private final Regex regex;
            {
                char[] cArray = "?!.:;\n".toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
                this.startChars = cArray;
                this.regex = new Regex("(" + StandardSentenceTokenizer.access$getNormalSentenceEnd$cp() + "|" + StandardSentenceTokenizer.access$getRomanBullet$cp() + "|(^|\n)(\\([\\d\\p{L}]{1,3}(\\.[\\d\\p{L}]{1,3})*\\)|\\[[\\d\\p{L}]{1,3}(\\.[\\d\\p{L}]{1,3})*\\]))(\n+|\\s+|$)|([:;]-?[()]+)(\n+|\\s+|$|" + StandardSentenceTokenizer.access$getNormalSentenceEnd$cp() + ")+");
            }

            public List<TextRange> find(CharSequence text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                int offset = 0;
                ArrayList<TextRange> result = new ArrayList<TextRange>();
                while (offset >= 0) {
                    MatchResult mr = this.regex.matchAt(text, offset);
                    if (mr != null) {
                        if (!StandardSentenceTokenizer.access$getSentenceContinuation$cp().matchesAt(text, offset)) {
                            result.add(TextRange.Companion.invoke(mr.getRange()));
                        }
                        offset = mr.getRange().getLast() + 1;
                    }
                    offset = StringsKt.indexOfAny$default((CharSequence)text, (char[])this.startChars, (int)(offset + 1), (boolean)false, (int)4, null);
                }
                return result;
            }
        };
        nextLineStartsWithBullet = new RegexPattern(new Regex("\n")).before(new Regex("[ \\t]*[\\d\\p{L}]{1,3}(\\.[\\d\\p{L}]{1,3})*\\.\\s+\\S"));
        Default = new StandardSentenceTokenizer(2, Language.UNKNOWN);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0004\t\f\u000f\u0015\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!H\u0007J\b\u0010\"\u001a\u00020\u0018H\u0002J\b\u0010#\u001a\u00020$H\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion;", "", "()V", "Default", "Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer;", "getDefault$annotations", "getDefault", "()Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer;", "Ellipsis", "ai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion$Ellipsis$1$1", "Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion$Ellipsis$1$1;", "Parenthetical", "ai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion$Parenthetical$1", "Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion$Parenthetical$1;", "QuotedStuff", "ai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion$QuotedStuff$1", "Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion$QuotedStuff$1;", "braceBullet", "", "bulletContents", "endPunctuation", "ai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion$endPunctuation$1", "Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer$Companion$endPunctuation$1;", "nextLineStartsWithBullet", "Lai/grazie/nlp/patterns/Pattern;", "normalSentenceEnd", "quotes", "romanBullet", "sentenceContinuation", "Lkotlin/text/Regex;", "spaceOrEnd", "defaultFor", "language", "Lai/grazie/nlp/langs/Language;", "pairedDashes", "pairedParentheses", "Lai/grazie/nlp/patterns/RegexPattern;", "nlp-tokenizer"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final StandardSentenceTokenizer defaultFor(@NotNull Language language) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            return new StandardSentenceTokenizer(2, language);
        }

        private final RegexPattern pairedParentheses() {
            String noParentheses = "[^()]";
            String nestedParentheses = "\\(" + noParentheses + "{1,500}\\)" + noParentheses + "{0,500}";
            return new RegexPattern(new Regex("\\(" + noParentheses + "{1,500}(" + nestedParentheses + ")*\\)"));
        }

        private final Pattern pairedDashes() {
            Regex dashRegex = new Regex("\\s+[-\u2013\u2014]+\\s+([^-\u2013\u2014]{1,100})\\s+[-\u2013\u2014]+\\s+");
            Regex smileyRegex = new Regex("[:;]-?[()]+");
            return (Pattern)new RegexPattern(dashRegex, smileyRegex){
                final /* synthetic */ Regex $dashRegex;
                final /* synthetic */ Regex $smileyRegex;
                {
                    this.$dashRegex = $dashRegex;
                    this.$smileyRegex = $smileyRegex;
                    super($dashRegex);
                }

                /*
                 * WARNING - void declaration
                 */
                public List<TextRange> find(CharSequence text) {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                    Iterable iterable = super.find(text);
                    Regex regex = this.$dashRegex;
                    Regex regex2 = this.$smileyRegex;
                    boolean $i$f$filter = false;
                    void var6_6 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        TextRange it = (TextRange)element$iv$iv;
                        boolean bl = false;
                        CharSequence withDashes = text.subSequence(it.getStart(), it.getEndExclusive());
                        MatchResult matchResult = regex.matchEntire(withDashes);
                        Intrinsics.checkNotNull((Object)matchResult);
                        String withoutDashes = (String)matchResult.getGroupValues().get(1);
                        if (!(Regex.find$default((Regex)regex2, (CharSequence)withoutDashes, (int)0, (int)2, null) == null)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    return (List)destination$iv$iv;
                }
            };
        }

        @NotNull
        public final StandardSentenceTokenizer getDefault() {
            return Default;
        }

        @Deprecated(message="Use defaultFor with a language")
        public static /* synthetic */ void getDefault$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

