/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.model.llm.definitions;

import ai.grazie.model.cloud.exceptions.ExtensionsKt;
import ai.grazie.model.llm.chat.multimodal.LLMMultiModalChat;
import ai.grazie.model.llm.chat.multimodal.LLMMultiModalChatRole;
import ai.grazie.model.llm.definitions.LLMFeatureDefinition;
import ai.grazie.model.llm.definitions.MediaDataDefinition;
import ai.grazie.model.llm.definitions.MultimodalChatDefinition;
import ai.grazie.model.llm.definitions.ParameterDefinition;
import ai.grazie.model.llm.definitions.RoleDefinition;
import ai.grazie.utils.attributes.Attributes;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012$\b\u0002\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r0\t\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0007H\u00c6\u0003J%\u0010\u001f\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r0\tH\u00c6\u0003JM\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072$\b\u0002\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r0\tH\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001J\t\u0010'\u001a\u00020(H\u00d6\u0001J\u0016\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020(2\u0006\u0010,\u001a\u00020-R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R-\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006."}, d2={"Lai/grazie/model/llm/definitions/MultimodalChatDefinition;", "Lai/grazie/model/llm/definitions/LLMFeatureDefinition;", "roleDefinition", "Lai/grazie/model/llm/definitions/RoleDefinition;", "mediaDataDefinition", "Lai/grazie/model/llm/definitions/MediaDataDefinition;", "parameterDefinition", "Lai/grazie/model/llm/definitions/ParameterDefinition;", "options", "", "Lai/grazie/utils/attributes/Attributes$Key;", "Lkotlin/Function1;", "Lai/grazie/utils/attributes/Attributes;", "Lai/grazie/model/llm/definitions/OptionConfigurer;", "(Lai/grazie/model/llm/definitions/RoleDefinition;Lai/grazie/model/llm/definitions/MediaDataDefinition;Lai/grazie/model/llm/definitions/ParameterDefinition;Ljava/util/Map;)V", "getMediaDataDefinition", "()Lai/grazie/model/llm/definitions/MediaDataDefinition;", "getOptions", "()Ljava/util/Map;", "getParameterDefinition", "()Lai/grazie/model/llm/definitions/ParameterDefinition;", "getRoleDefinition", "()Lai/grazie/model/llm/definitions/RoleDefinition;", "supportedRoles", "", "Lai/grazie/model/llm/chat/multimodal/LLMMultiModalChatRole;", "getSupportedRoles", "()Ljava/util/Set;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "validateChat", "", "name", "chat", "Lai/grazie/model/llm/chat/multimodal/LLMMultiModalChat;", "model-llm"})
public final class MultimodalChatDefinition
implements LLMFeatureDefinition {
    @NotNull
    private final RoleDefinition roleDefinition;
    @NotNull
    private final MediaDataDefinition mediaDataDefinition;
    @NotNull
    private final ParameterDefinition parameterDefinition;
    @NotNull
    private final Map<Attributes.Key, Function1<Attributes, Attributes>> options;

    public MultimodalChatDefinition(@NotNull RoleDefinition roleDefinition, @NotNull MediaDataDefinition mediaDataDefinition, @NotNull ParameterDefinition parameterDefinition, @NotNull Map<Attributes.Key, ? extends Function1<? super Attributes, ? extends Attributes>> options) {
        Intrinsics.checkNotNullParameter((Object)roleDefinition, (String)"roleDefinition");
        Intrinsics.checkNotNullParameter((Object)mediaDataDefinition, (String)"mediaDataDefinition");
        Intrinsics.checkNotNullParameter((Object)parameterDefinition, (String)"parameterDefinition");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        this.roleDefinition = roleDefinition;
        this.mediaDataDefinition = mediaDataDefinition;
        this.parameterDefinition = parameterDefinition;
        this.options = options;
    }

    public /* synthetic */ MultimodalChatDefinition(RoleDefinition roleDefinition, MediaDataDefinition mediaDataDefinition, ParameterDefinition parameterDefinition, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        this(roleDefinition, mediaDataDefinition, parameterDefinition, map);
    }

    @NotNull
    public final RoleDefinition getRoleDefinition() {
        return this.roleDefinition;
    }

    @NotNull
    public final MediaDataDefinition getMediaDataDefinition() {
        return this.mediaDataDefinition;
    }

    @Override
    @NotNull
    public ParameterDefinition getParameterDefinition() {
        return this.parameterDefinition;
    }

    @NotNull
    public final Map<Attributes.Key, Function1<Attributes, Attributes>> getOptions() {
        return this.options;
    }

    public final void validateChat(@NotNull String name, @NotNull LLMMultiModalChat chat) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)chat, (String)"chat");
        ExtensionsKt.requireOrBadRequest((!((Collection)chat.getMessages()).isEmpty() ? 1 : 0) != 0, (Function0)validateChat.1.INSTANCE);
        this.roleDefinition.validateMessages(name, chat.getMessages());
        this.mediaDataDefinition.validateMediaData(name, chat);
    }

    @NotNull
    public final Set<LLMMultiModalChatRole> getSupportedRoles() {
        return this.roleDefinition.getSupportedMultiModalRoles();
    }

    @NotNull
    public final RoleDefinition component1() {
        return this.roleDefinition;
    }

    @NotNull
    public final MediaDataDefinition component2() {
        return this.mediaDataDefinition;
    }

    @NotNull
    public final ParameterDefinition component3() {
        return this.parameterDefinition;
    }

    @NotNull
    public final Map<Attributes.Key, Function1<Attributes, Attributes>> component4() {
        return this.options;
    }

    @NotNull
    public final MultimodalChatDefinition copy(@NotNull RoleDefinition roleDefinition, @NotNull MediaDataDefinition mediaDataDefinition, @NotNull ParameterDefinition parameterDefinition, @NotNull Map<Attributes.Key, ? extends Function1<? super Attributes, ? extends Attributes>> options) {
        Intrinsics.checkNotNullParameter((Object)roleDefinition, (String)"roleDefinition");
        Intrinsics.checkNotNullParameter((Object)mediaDataDefinition, (String)"mediaDataDefinition");
        Intrinsics.checkNotNullParameter((Object)parameterDefinition, (String)"parameterDefinition");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        return new MultimodalChatDefinition(roleDefinition, mediaDataDefinition, parameterDefinition, options);
    }

    public static /* synthetic */ MultimodalChatDefinition copy$default(MultimodalChatDefinition multimodalChatDefinition, RoleDefinition roleDefinition, MediaDataDefinition mediaDataDefinition, ParameterDefinition parameterDefinition, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            roleDefinition = multimodalChatDefinition.roleDefinition;
        }
        if ((n & 2) != 0) {
            mediaDataDefinition = multimodalChatDefinition.mediaDataDefinition;
        }
        if ((n & 4) != 0) {
            parameterDefinition = multimodalChatDefinition.parameterDefinition;
        }
        if ((n & 8) != 0) {
            map = multimodalChatDefinition.options;
        }
        return multimodalChatDefinition.copy(roleDefinition, mediaDataDefinition, parameterDefinition, map);
    }

    @NotNull
    public String toString() {
        return "MultimodalChatDefinition(roleDefinition=" + this.roleDefinition + ", mediaDataDefinition=" + this.mediaDataDefinition + ", parameterDefinition=" + this.parameterDefinition + ", options=" + this.options + ")";
    }

    public int hashCode() {
        int result = this.roleDefinition.hashCode();
        result = result * 31 + this.mediaDataDefinition.hashCode();
        result = result * 31 + this.parameterDefinition.hashCode();
        result = result * 31 + ((Object)this.options).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MultimodalChatDefinition)) {
            return false;
        }
        MultimodalChatDefinition multimodalChatDefinition = (MultimodalChatDefinition)other;
        if (!Intrinsics.areEqual((Object)this.roleDefinition, (Object)multimodalChatDefinition.roleDefinition)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.mediaDataDefinition, (Object)multimodalChatDefinition.mediaDataDefinition)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.parameterDefinition, (Object)multimodalChatDefinition.parameterDefinition)) {
            return false;
        }
        return Intrinsics.areEqual(this.options, multimodalChatDefinition.options);
    }
}

