/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.keychain;

import com.jetbrains.keychain.KeychainBackend;
import com.jetbrains.keychain.MacosKeychainBackend;
import com.jetbrains.keychain.SecurityLibraryContext;
import com.jetbrains.keychain.interop.MacOsKeychainLibrary;
import com.jetbrains.keychain.interop.SecKeychainAttribute;
import com.jetbrains.keychain.interop.SecKeychainAttributeInfo;
import com.jetbrains.keychain.interop.SecKeychainAttributeList;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.platform.mac.CoreFoundation;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0019H\u0002J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dJ\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u00052\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005H\u0016J \u0010\"\u001a\u00020#2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005H\u0016J3\u0010%\u001a\u0004\u0018\u0001H&\"\b\b\u0000\u0010&*\u00020'2\u0017\u0010(\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u0002H&0)\u00a2\u0006\u0002\b*H\u0082\b\u00a2\u0006\u0002\u0010+J<\u0010,\u001a\u0002H&\"\n\b\u0000\u0010&\u0018\u0001*\u00020\u0006*\u00020-2\u0006\u0010.\u001a\u00020\u00052\u0014\b\u0004\u0010(\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u0002H&0)H\u0082\n\u00a2\u0006\u0002\u00100R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\r\u001a\u0004\u0018\u00010\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0013\u001a\n \f*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00061"}, d2={"Lcom/jetbrains/keychain/MacosKeychainBackend;", "Lcom/jetbrains/keychain/KeychainBackend;", "()V", "globalVariableCFTypeRefCache", "Ljava/util/concurrent/ConcurrentMap;", "", "Lcom/sun/jna/platform/mac/CoreFoundation$CFTypeRef;", "isAvailable", "", "()Z", "library", "Lcom/jetbrains/keychain/interop/MacOsKeychainLibrary;", "kotlin.jvm.PlatformType", "libraryContext", "Lcom/jetbrains/keychain/SecurityLibraryContext;", "getLibraryContext", "()Lcom/jetbrains/keychain/SecurityLibraryContext;", "libraryContext$delegate", "Lkotlin/Lazy;", "logger", "Lorg/slf4j/Logger;", "name", "getName", "()Ljava/lang/String;", "checkForError", "", "message", "code", "findCertificates", "", "Ljava/security/cert/X509Certificate;", "getPassword", "service", "account", "setPassword", "", "password", "withSecurityLibraryContext", "R", "", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "get", "Lcom/sun/jna/NativeLibrary;", "key", "Lcom/sun/jna/Pointer;", "(Lcom/sun/jna/NativeLibrary;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Lcom/sun/jna/platform/mac/CoreFoundation$CFTypeRef;", "keychain"})
public final class MacosKeychainBackend
implements KeychainBackend {
    private final Logger logger = LoggerFactory.getLogger(MacosKeychainBackend.class);
    private final MacOsKeychainLibrary library;
    @NotNull
    private final Lazy libraryContext$delegate;
    @NotNull
    private final String name;
    @NotNull
    private final ConcurrentMap<String, CoreFoundation.CFTypeRef> globalVariableCFTypeRefCache;

    public MacosKeychainBackend() {
        MacOsKeychainLibrary macOsKeychainLibrary;
        MacosKeychainBackend macosKeychainBackend;
        MacosKeychainBackend macosKeychainBackend2 = this;
        try {
            macosKeychainBackend = macosKeychainBackend2;
            macOsKeychainLibrary = (MacOsKeychainLibrary)Native.load((String)"Security", MacOsKeychainLibrary.class);
        }
        catch (Throwable t) {
            macosKeychainBackend = macosKeychainBackend2;
            this.logger.error("Failed to load Security Framework", t);
            macOsKeychainLibrary = new MacOsKeychainLibrary(){

                public int SecKeychainAddGenericPassword(@Nullable Pointer keychain, int serviceNameLength, @NotNull byte[] serviceName, int accountNameLength, @Nullable byte[] accountName, int passwordLength, @Nullable byte[] passwordData, @Nullable Pointer itemRef) {
                    Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
                    return -4;
                }

                public int SecKeychainItemModifyContent(@NotNull Pointer itemRef, @Nullable Object attrList, int length, @Nullable byte[] data) {
                    Intrinsics.checkNotNullParameter((Object)itemRef, (String)"itemRef");
                    return -4;
                }

                public int SecKeychainFindGenericPassword(@Nullable Pointer keychainOrArray, int serviceNameLength, @NotNull byte[] serviceName, int accountNameLength, @Nullable byte[] accountName, @Nullable int[] passwordLength, @Nullable PointerByReference passwordData, @Nullable PointerByReference itemRef) {
                    Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
                    return -4;
                }

                public int SecKeychainItemCopyAttributesAndData(@NotNull Pointer itemRef, @NotNull SecKeychainAttributeInfo info, @Nullable IntByReference itemClass, @NotNull PointerByReference attrList, @Nullable IntByReference length, @Nullable PointerByReference outData) {
                    Intrinsics.checkNotNullParameter((Object)itemRef, (String)"itemRef");
                    Intrinsics.checkNotNullParameter((Object)((Object)info), (String)"info");
                    Intrinsics.checkNotNullParameter((Object)attrList, (String)"attrList");
                    return -4;
                }

                public int SecKeychainItemFreeAttributesAndData(@NotNull SecKeychainAttributeList attrList, @Nullable Pointer data) {
                    Intrinsics.checkNotNullParameter((Object)((Object)attrList), (String)"attrList");
                    return -4;
                }

                public int SecKeychainItemDelete(@NotNull Pointer itemRef) {
                    Intrinsics.checkNotNullParameter((Object)itemRef, (String)"itemRef");
                    return -4;
                }

                @Nullable
                public Pointer SecCopyErrorMessageString(int status, @Nullable Pointer reserved) {
                    return null;
                }

                public long CFStringGetLength(@NotNull Pointer theString) {
                    Intrinsics.checkNotNullParameter((Object)theString, (String)"theString");
                    return 0L;
                }

                public char CFStringGetCharacterAtIndex(@NotNull Pointer theString, long idx) {
                    Intrinsics.checkNotNullParameter((Object)theString, (String)"theString");
                    return '\u0000';
                }

                public void CFRelease(@NotNull Pointer cf) {
                    Intrinsics.checkNotNullParameter((Object)cf, (String)"cf");
                }

                public void SecKeychainItemFreeContent(@Nullable Pointer attrList, @Nullable Pointer data) {
                }

                @Nullable
                public CoreFoundation.CFMutableDictionaryRef CFDictionaryCreateMutable(@Nullable CoreFoundation.CFAllocatorRef alloc, @Nullable CoreFoundation.CFIndex capacity, @Nullable Pointer keyCallBacks, @Nullable Pointer valueCallBacks) {
                    return null;
                }

                public int SecItemCopyMatching(@NotNull CoreFoundation.CFDictionaryRef search, @NotNull PointerByReference result) {
                    Intrinsics.checkNotNullParameter((Object)search, (String)"search");
                    Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                    return -4;
                }
            };
        }
        macosKeychainBackend.library = macOsKeychainLibrary;
        this.libraryContext$delegate = LazyKt.lazy((Function0)libraryContext.2.INSTANCE);
        this.name = "macos-system";
        this.globalVariableCFTypeRefCache = new ConcurrentHashMap();
    }

    @Override
    public boolean isAvailable() {
        return Platform.isMac();
    }

    private final SecurityLibraryContext getLibraryContext() {
        Lazy lazy = this.libraryContext$delegate;
        return (SecurityLibraryContext)lazy.getValue();
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getPassword(@NotNull String service, @NotNull String account) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        String string = account;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] accountNameBytes = byArray;
        int[] passwordSize = new int[1];
        PointerByReference passwordRef = new PointerByReference();
        PointerByReference itemRef = new PointerByReference();
        int n = service.length();
        String string2 = service;
        byte[] byArray2 = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
        int errorCode = this.checkForError("find", this.library.SecKeychainFindGenericPassword(null, n, byArray2, accountNameBytes.length, accountNameBytes, passwordSize, passwordRef, itemRef));
        switch (errorCode) {
            case -25293: 
            case -128: {
                return null;
            }
        }
        Pointer pointer = passwordRef.getValue();
        if (pointer == null) {
            return null;
        }
        Pointer pointer2 = pointer;
        byte[] byArray3 = pointer2.getByteArray(0L, passwordSize[0]);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"pointer.getByteArray(0, passwordSize[0])");
        String password = new String(byArray3, Charsets.UTF_8);
        this.library.SecKeychainItemFreeContent(null, pointer2);
        return password;
    }

    private final int checkForError(String message, int code) {
        switch (code) {
            case -25300: 
            case 0: {
                return code;
            }
        }
        Pointer translated = this.library.SecCopyErrorMessageString(code, null);
        StringBuilder builder = new StringBuilder(message).append(": ");
        if (translated == null) {
            builder.append(code);
        } else {
            char[] buf = new char[(int)this.library.CFStringGetLength(translated)];
            int n = 0;
            int n2 = buf.length;
            while (n < n2) {
                int i = n++;
                buf[i] = this.library.CFStringGetCharacterAtIndex(translated, i);
            }
            this.library.CFRelease(translated);
            builder.append(buf).append(" (").append(code).append(')');
        }
        switch (code) {
            default: 
        }
        return code;
    }

    @Override
    public void setPassword(@NotNull String service, @NotNull String account, @NotNull String password) {
        PointerByReference itemRef;
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        String string = service;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] serviceName = byArray;
        String string2 = account;
        byte[] byArray2 = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
        byte[] userName = byArray2;
        if (((CharSequence)password).length() == 0) {
            itemRef = new PointerByReference();
            int code = this.library.SecKeychainFindGenericPassword(null, serviceName.length, serviceName, userName.length, userName, null, null, itemRef);
            switch (code) {
                case -67701: 
                case -25300: {
                    return;
                }
            }
            this.checkForError("find (for delete)", code);
            Pointer pointer = itemRef.getValue();
            if (pointer != null) {
                Pointer it = pointer;
                boolean bl = false;
                this.checkForError("delete", this.library.SecKeychainItemDelete(it));
                this.library.CFRelease(it);
            }
            return;
        }
        itemRef = new PointerByReference();
        MacOsKeychainLibrary library2 = this.library;
        this.checkForError("find (for save)", library2.SecKeychainFindGenericPassword(null, serviceName.length, serviceName, userName.length, userName, null, null, itemRef));
        String string3 = password;
        byte[] byArray3 = string3.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"this as java.lang.String).getBytes(charset)");
        byte[] passwordBytes = byArray3;
        Pointer pointer = itemRef.getValue();
        if (pointer == null) {
            Intrinsics.checkNotNullExpressionValue((Object)library2, (String)"library");
            this.checkForError("save (new)", MacOsKeychainLibrary.DefaultImpls.SecKeychainAddGenericPassword$default(library2, null, serviceName.length, serviceName, userName.length, userName, passwordBytes.length, passwordBytes, null, 128, null));
        } else {
            SecKeychainAttribute attribute = new SecKeychainAttribute();
            attribute.tag = 1633903476;
            attribute.length = userName.length;
            if (!(userName.length == 0)) {
                Memory userNamePointer = new Memory((long)userName.length);
                userNamePointer.write(0L, userName, 0, userName.length);
                attribute.data = (Pointer)userNamePointer;
            }
            SecKeychainAttributeList attributeList = new SecKeychainAttributeList();
            attributeList.count = 1;
            attribute.write();
            attributeList.attr = attribute.getPointer();
            this.checkForError("save (update)", library2.SecKeychainItemModifyContent(pointer, (Object)attributeList, passwordBytes.length, passwordBytes));
            library2.CFRelease(pointer);
        }
        ArraysKt.fill$default((byte[])passwordBytes, (byte)0, (int)0, (int)0, (int)6, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<X509Certificate> findCertificates() {
        List list;
        MacosKeychainBackend this_$iv = this;
        boolean $i$f$withSecurityLibraryContext = false;
        SecurityLibraryContext context$iv = this_$iv.getLibraryContext();
        if (context$iv != null) {
            List list2;
            SecurityLibraryContext $this$findCertificates_u24lambda_u2d8 = context$iv;
            boolean bl = false;
            CoreFoundation.CFMutableDictionaryRef cFMutableDictionaryRef = this.library.CFDictionaryCreateMutable(null, new CoreFoundation.CFIndex(3L), null, null);
            if (cFMutableDictionaryRef == null) {
                SecurityLibraryContext $this$findCertificates_u24lambda_u2d8_u24lambda_u2d1 = $this$findCertificates_u24lambda_u2d8;
                boolean bl2 = false;
                this.logger.warn("Couldn't allocate with CFDictionaryCreateMutable");
                return CollectionsKt.emptyList();
            }
            CoreFoundation.CFMutableDictionaryRef dict = cFMutableDictionaryRef;
            try {
                List list3;
                Pointer pointer;
                Object $this$get$iv;
                MacosKeychainBackend this_$iv2;
                PointerByReference resultReference = new PointerByReference();
                MacosKeychainBackend macosKeychainBackend = this;
                NativeLibrary $this$findCertificates_u24lambda_u2d8_u24lambda_u2d1 = $this$findCertificates_u24lambda_u2d8.getSecurity();
                String key$iv = "kSecClass";
                boolean $i$f$get = false;
                CoreFoundation.CFTypeRef cFTypeRef = this_$iv2.globalVariableCFTypeRefCache.computeIfAbsent(key$iv, new Function((NativeLibrary)$this$get$iv, key$iv){
                    final /* synthetic */ NativeLibrary $this_get;
                    final /* synthetic */ String $key;
                    {
                        this.$this_get = $receiver;
                        this.$key = $key;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final CoreFoundation.CFTypeRef apply(String it) {
                        void $this$getGlobalCFTypeRef$iv;
                        NativeLibrary nativeLibrary = this.$this_get;
                        String symbolName$iv = this.$key;
                        boolean $i$f$getGlobalCFTypeRef = false;
                        Pointer p0 = $this$getGlobalCFTypeRef$iv.getGlobalVariableAddress(symbolName$iv).getPointer(0L);
                        boolean bl = false;
                        return (CoreFoundation.CFTypeRef)new CoreFoundation.CFStringRef(p0);
                    }
                });
                if (cFTypeRef == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.sun.jna.platform.mac.CoreFoundation.CFStringRef");
                }
                this_$iv2 = this;
                $this$get$iv = $this$findCertificates_u24lambda_u2d8.getSecurity();
                key$iv = "kSecClassCertificate";
                $i$f$get = false;
                CoreFoundation.CFTypeRef cFTypeRef2 = this_$iv2.globalVariableCFTypeRefCache.computeIfAbsent(key$iv, new Function((NativeLibrary)$this$get$iv, key$iv){
                    final /* synthetic */ NativeLibrary $this_get;
                    final /* synthetic */ String $key;
                    {
                        this.$this_get = $receiver;
                        this.$key = $key;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final CoreFoundation.CFTypeRef apply(String it) {
                        void $this$getGlobalCFTypeRef$iv;
                        NativeLibrary nativeLibrary = this.$this_get;
                        String symbolName$iv = this.$key;
                        boolean $i$f$getGlobalCFTypeRef = false;
                        Pointer p0 = $this$getGlobalCFTypeRef$iv.getGlobalVariableAddress(symbolName$iv).getPointer(0L);
                        boolean bl = false;
                        return (CoreFoundation.CFTypeRef)new CoreFoundation.CFStringRef(p0);
                    }
                });
                if (cFTypeRef2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.sun.jna.platform.mac.CoreFoundation.CFStringRef");
                }
                dict.setValue((PointerType)((CoreFoundation.CFTypeRef)((CoreFoundation.CFStringRef)cFTypeRef)), (PointerType)((CoreFoundation.CFTypeRef)((CoreFoundation.CFStringRef)cFTypeRef2)));
                this_$iv2 = this;
                $this$get$iv = $this$findCertificates_u24lambda_u2d8.getSecurity();
                key$iv = "kSecReturnData";
                $i$f$get = false;
                CoreFoundation.CFTypeRef cFTypeRef3 = this_$iv2.globalVariableCFTypeRefCache.computeIfAbsent(key$iv, new Function((NativeLibrary)$this$get$iv, key$iv){
                    final /* synthetic */ NativeLibrary $this_get;
                    final /* synthetic */ String $key;
                    {
                        this.$this_get = $receiver;
                        this.$key = $key;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final CoreFoundation.CFTypeRef apply(String it) {
                        void $this$getGlobalCFTypeRef$iv;
                        NativeLibrary nativeLibrary = this.$this_get;
                        String symbolName$iv = this.$key;
                        boolean $i$f$getGlobalCFTypeRef = false;
                        Pointer p0 = $this$getGlobalCFTypeRef$iv.getGlobalVariableAddress(symbolName$iv).getPointer(0L);
                        boolean bl = false;
                        return (CoreFoundation.CFTypeRef)new CoreFoundation.CFStringRef(p0);
                    }
                });
                if (cFTypeRef3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.sun.jna.platform.mac.CoreFoundation.CFStringRef");
                }
                this_$iv2 = this;
                $this$get$iv = $this$findCertificates_u24lambda_u2d8.getCoreFoundation();
                key$iv = "kCFBooleanTrue";
                $i$f$get = false;
                CoreFoundation.CFTypeRef cFTypeRef4 = this_$iv2.globalVariableCFTypeRefCache.computeIfAbsent(key$iv, new Function((NativeLibrary)$this$get$iv, key$iv){
                    final /* synthetic */ NativeLibrary $this_get;
                    final /* synthetic */ String $key;
                    {
                        this.$this_get = $receiver;
                        this.$key = $key;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final CoreFoundation.CFTypeRef apply(String it) {
                        void $this$getGlobalCFTypeRef$iv;
                        NativeLibrary nativeLibrary = this.$this_get;
                        String symbolName$iv = this.$key;
                        boolean $i$f$getGlobalCFTypeRef = false;
                        Pointer p0 = $this$getGlobalCFTypeRef$iv.getGlobalVariableAddress(symbolName$iv).getPointer(0L);
                        boolean bl = false;
                        return (CoreFoundation.CFTypeRef)new CoreFoundation.CFBooleanRef(p0);
                    }
                });
                if (cFTypeRef4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.sun.jna.platform.mac.CoreFoundation.CFBooleanRef");
                }
                dict.setValue((PointerType)((CoreFoundation.CFTypeRef)((CoreFoundation.CFStringRef)cFTypeRef3)), (PointerType)((CoreFoundation.CFTypeRef)((CoreFoundation.CFBooleanRef)cFTypeRef4)));
                this_$iv2 = this;
                $this$get$iv = $this$findCertificates_u24lambda_u2d8.getSecurity();
                key$iv = "kSecMatchLimit";
                $i$f$get = false;
                CoreFoundation.CFTypeRef cFTypeRef5 = this_$iv2.globalVariableCFTypeRefCache.computeIfAbsent(key$iv, new Function((NativeLibrary)$this$get$iv, key$iv){
                    final /* synthetic */ NativeLibrary $this_get;
                    final /* synthetic */ String $key;
                    {
                        this.$this_get = $receiver;
                        this.$key = $key;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final CoreFoundation.CFTypeRef apply(String it) {
                        void $this$getGlobalCFTypeRef$iv;
                        NativeLibrary nativeLibrary = this.$this_get;
                        String symbolName$iv = this.$key;
                        boolean $i$f$getGlobalCFTypeRef = false;
                        Pointer p0 = $this$getGlobalCFTypeRef$iv.getGlobalVariableAddress(symbolName$iv).getPointer(0L);
                        boolean bl = false;
                        return (CoreFoundation.CFTypeRef)new CoreFoundation.CFStringRef(p0);
                    }
                });
                if (cFTypeRef5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.sun.jna.platform.mac.CoreFoundation.CFStringRef");
                }
                this_$iv2 = this;
                $this$get$iv = $this$findCertificates_u24lambda_u2d8.getSecurity();
                key$iv = "kSecMatchLimitAll";
                $i$f$get = false;
                CoreFoundation.CFTypeRef cFTypeRef6 = this_$iv2.globalVariableCFTypeRefCache.computeIfAbsent(key$iv, new Function((NativeLibrary)$this$get$iv, key$iv){
                    final /* synthetic */ NativeLibrary $this_get;
                    final /* synthetic */ String $key;
                    {
                        this.$this_get = $receiver;
                        this.$key = $key;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final CoreFoundation.CFTypeRef apply(String it) {
                        void $this$getGlobalCFTypeRef$iv;
                        NativeLibrary nativeLibrary = this.$this_get;
                        String symbolName$iv = this.$key;
                        boolean $i$f$getGlobalCFTypeRef = false;
                        Pointer p0 = $this$getGlobalCFTypeRef$iv.getGlobalVariableAddress(symbolName$iv).getPointer(0L);
                        boolean bl = false;
                        return (CoreFoundation.CFTypeRef)new CoreFoundation.CFStringRef(p0);
                    }
                });
                if (cFTypeRef6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.sun.jna.platform.mac.CoreFoundation.CFStringRef");
                }
                dict.setValue((PointerType)((CoreFoundation.CFTypeRef)((CoreFoundation.CFStringRef)cFTypeRef5)), (PointerType)((CoreFoundation.CFTypeRef)((CoreFoundation.CFStringRef)cFTypeRef6)));
                int code = this.checkForError("query item copy certificate", this.library.SecItemCopyMatching((CoreFoundation.CFDictionaryRef)dict, resultReference));
                if (code != 0) {
                    $this$get$iv = CollectionsKt.emptyList();
                    return $this$get$iv;
                }
                if (resultReference.getValue() == null) {
                    List list4 = CollectionsKt.emptyList();
                    return list4;
                }
                Pointer pointer2 = pointer;
                CoreFoundation.CFArrayRef results = new CoreFoundation.CFArrayRef(pointer2);
                try {
                    if (results.getCount() == 0) {
                        List list5 = CollectionsKt.emptyList();
                        return list5;
                    }
                    List $this$findCertificates_u24lambda_u2d8_u24lambda_u2d7 = list3 = CollectionsKt.createListBuilder();
                    boolean bl3 = false;
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    int n = 0;
                    int n2 = results.getCount();
                    while (n < n2) {
                        X509Certificate x509Certificate;
                        int i = n++;
                        Pointer value = results.getValueAtIndex(i);
                        CoreFoundation.CFDataRef data = new CoreFoundation.CFDataRef(value);
                        byte[] bytes = data.getBytePtr().getByteArray(0L, data.getLength());
                        try {
                            Certificate certificate = certificateFactory.generateCertificate(new ByteArrayInputStream(bytes));
                            X509Certificate x509Certificate2 = x509Certificate = certificate instanceof X509Certificate ? (X509Certificate)certificate : null;
                            if (x509Certificate == null) continue;
                        }
                        catch (CertificateParsingException e) {
                            String base64Cert = Base64.getEncoder().encodeToString(bytes);
                            this.logger.debug("Error parsing certificate " + base64Cert + ": ", (Throwable)e);
                            continue;
                        }
                        X509Certificate cert = x509Certificate;
                        $this$findCertificates_u24lambda_u2d8_u24lambda_u2d7.add(cert);
                    }
                    list3 = CollectionsKt.build((List)list3);
                }
                finally {
                    results.release();
                }
                list2 = list3;
            }
            finally {
                dict.release();
            }
            list = list2;
        } else {
            String string;
            Object[] stackTraceElements$iv = Thread.currentThread().getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElements$iv, (String)"stackTraceElements");
            StackTraceElement stackTraceElement = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTraceElements$iv, (int)1);
            if (stackTraceElement == null) {
                string = "<unknown_method_name>";
            } else {
                string = stackTraceElement.getMethodName();
                if (string == null) {
                    string = "<unknown_method_name>";
                }
            }
            String parentMethodName$iv = string;
            this_$iv.logger.warn("Couldn't load native library context but used " + parentMethodName$iv);
            list = null;
        }
        List list6 = list;
        return list6 == null ? CollectionsKt.emptyList() : list6;
    }

    private final /* synthetic */ <R extends CoreFoundation.CFTypeRef> R get(NativeLibrary $this$get, String key, Function1<? super Pointer, ? extends R> block) {
        Intrinsics.checkNotNullParameter((Object)$this$get, (String)"<this>");
        boolean $i$f$get = false;
        CoreFoundation.CFTypeRef cFTypeRef = this.globalVariableCFTypeRefCache.computeIfAbsent(key, new Function($this$get, key, block){
            final /* synthetic */ NativeLibrary $this_get;
            final /* synthetic */ String $key;
            final /* synthetic */ Function1<Pointer, R> $block;
            {
                this.$this_get = $receiver;
                this.$key = $key;
                this.$block = $block;
            }

            /*
             * WARNING - void declaration
             */
            public final CoreFoundation.CFTypeRef apply(String it) {
                void symbolName$iv;
                void $this$getGlobalCFTypeRef$iv;
                NativeLibrary nativeLibrary = this.$this_get;
                String string = this.$key;
                Function1<Pointer, R> block$iv = this.$block;
                boolean $i$f$getGlobalCFTypeRef = false;
                Pointer pointer = $this$getGlobalCFTypeRef$iv.getGlobalVariableAddress((String)symbolName$iv).getPointer(0L);
                return (CoreFoundation.CFTypeRef)block$iv.invoke((Object)pointer);
            }
        });
        Intrinsics.reifiedOperationMarker((int)1, (String)"R");
        return (R)cFTypeRef;
    }

    private final <R> R withSecurityLibraryContext(Function1<? super SecurityLibraryContext, ? extends R> block) {
        Object object;
        boolean $i$f$withSecurityLibraryContext = false;
        SecurityLibraryContext context = this.getLibraryContext();
        if (context != null) {
            object = block.invoke((Object)context);
        } else {
            String string;
            Object[] stackTraceElements = Thread.currentThread().getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElements, (String)"stackTraceElements");
            StackTraceElement stackTraceElement = (StackTraceElement)ArraysKt.getOrNull((Object[])stackTraceElements, (int)1);
            if (stackTraceElement == null) {
                string = "<unknown_method_name>";
            } else {
                string = stackTraceElement.getMethodName();
                if (string == null) {
                    string = "<unknown_method_name>";
                }
            }
            String parentMethodName = string;
            this.logger.warn("Couldn't load native library context but used " + parentMethodName);
            object = null;
        }
        return (R)object;
    }
}

