/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.verifier;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.zip.signer.metadata.SignatureAlgorithm;

public final class DefaultSignatureVerifier {
    private final PublicKey publicKey;
    @NotNull
    private final String jcaSignatureAlgorithm;

    public DefaultSignatureVerifier(@NotNull List<? extends X509Certificate> certificateChain, @NotNull SignatureAlgorithm signatureAlgorithm) {
        Intrinsics.checkNotNullParameter(certificateChain, (String)"certificateChain");
        Intrinsics.checkNotNullParameter((Object)((Object)signatureAlgorithm), (String)"signatureAlgorithm");
        this.publicKey = certificateChain.get(0).getPublicKey();
        this.jcaSignatureAlgorithm = signatureAlgorithm.getJcaSignatureAlgorithm();
    }

    public void verify(@NotNull byte[] dataToVerify, @NotNull byte[] signature) {
        Intrinsics.checkNotNullParameter((Object)dataToVerify, (String)"dataToVerify");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        try {
            Signature $this$verify_u24lambda_u240 = Signature.getInstance(this.jcaSignatureAlgorithm);
            boolean bl = false;
            $this$verify_u24lambda_u240.initVerify(this.publicKey);
            $this$verify_u24lambda_u240.update(dataToVerify);
            if (!$this$verify_u24lambda_u240.verify(signature)) {
                throw new SignatureException("Failed to verify " + this.jcaSignatureAlgorithm + " signature using public key from certificate");
            }
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeyException("Failed to verify " + this.jcaSignatureAlgorithm + " signature using public key from certificate", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new SignatureException("Failed to verify " + this.jcaSignatureAlgorithm + " signature using public key from certificate", e);
        }
        catch (SignatureException e) {
            throw new SignatureException("Failed to verify " + this.jcaSignatureAlgorithm + " signature using public key from certificate", e);
        }
    }
}

