/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.proto;

import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import org.jetbrains.zip.signer.proto.DigestProtoOrBuilder;
import org.jetbrains.zip.signer.proto.ZipMetadataProtos;

public final class DigestProto
extends GeneratedMessageV3
implements DigestProtoOrBuilder {
    private int algorithmId_ = 0;
    private ByteString digestBytes_ = ByteString.EMPTY;
    private byte memoizedIsInitialized = (byte)-1;
    private static final DigestProto DEFAULT_INSTANCE = new DigestProto();
    private static final Parser<DigestProto> PARSER = new AbstractParser<DigestProto>(){

        @Override
        public DigestProto parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = DigestProto.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private DigestProto(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private DigestProto() {
        this.algorithmId_ = 0;
        this.digestBytes_ = ByteString.EMPTY;
    }

    @Override
    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new DigestProto();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return ZipMetadataProtos.internal_static_DigestProto_descriptor;
    }

    @Override
    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return ZipMetadataProtos.internal_static_DigestProto_fieldAccessorTable.ensureFieldAccessorsInitialized(DigestProto.class, Builder.class);
    }

    public int getAlgorithmIdValue() {
        return this.algorithmId_;
    }

    public AlgorithmId getAlgorithmId() {
        AlgorithmId result2 = AlgorithmId.forNumber(this.algorithmId_);
        return result2 == null ? AlgorithmId.UNRECOGNIZED : result2;
    }

    public ByteString getDigestBytes() {
        return this.digestBytes_;
    }

    @Override
    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    @Override
    public void writeTo(CodedOutputStream output2) throws IOException {
        if (this.algorithmId_ != AlgorithmId.SHA256.getNumber()) {
            output2.writeEnum(1, this.algorithmId_);
        }
        if (!this.digestBytes_.isEmpty()) {
            output2.writeBytes(2, this.digestBytes_);
        }
        this.getUnknownFields().writeTo(output2);
    }

    @Override
    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (this.algorithmId_ != AlgorithmId.SHA256.getNumber()) {
            size += CodedOutputStream.computeEnumSize(1, this.algorithmId_);
        }
        if (!this.digestBytes_.isEmpty()) {
            size += CodedOutputStream.computeBytesSize(2, this.digestBytes_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DigestProto)) {
            return super.equals(obj);
        }
        DigestProto other = (DigestProto)obj;
        if (this.algorithmId_ != other.algorithmId_) {
            return false;
        }
        if (!this.getDigestBytes().equals(other.getDigestBytes())) {
            return false;
        }
        return this.getUnknownFields().equals(other.getUnknownFields());
    }

    @Override
    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + DigestProto.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.algorithmId_;
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getDigestBytes().hashCode();
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    @Override
    public Builder newBuilderForType() {
        return DigestProto.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    @Override
    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @Override
    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static DigestProto getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<DigestProto> parser() {
        return PARSER;
    }

    public Parser<DigestProto> getParserForType() {
        return PARSER;
    }

    @Override
    public DigestProto getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements DigestProtoOrBuilder {
        private int bitField0_;
        private int algorithmId_ = 0;
        private ByteString digestBytes_ = ByteString.EMPTY;

        @Override
        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return ZipMetadataProtos.internal_static_DigestProto_fieldAccessorTable.ensureFieldAccessorsInitialized(DigestProto.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        @Override
        public Descriptors.Descriptor getDescriptorForType() {
            return ZipMetadataProtos.internal_static_DigestProto_descriptor;
        }

        @Override
        public DigestProto getDefaultInstanceForType() {
            return DigestProto.getDefaultInstance();
        }

        @Override
        public DigestProto build() {
            DigestProto result2 = this.buildPartial();
            if (!result2.isInitialized()) {
                throw Builder.newUninitializedMessageException(result2);
            }
            return result2;
        }

        @Override
        public DigestProto buildPartial() {
            DigestProto result2 = new DigestProto(this);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result2);
            }
            this.onBuilt();
            return result2;
        }

        private void buildPartial0(DigestProto result2) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result2.algorithmId_ = this.algorithmId_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result2.digestBytes_ = this.digestBytes_;
            }
        }

        @Override
        public Builder clone() {
            return (Builder)super.clone();
        }

        @Override
        public Builder setField(Descriptors.FieldDescriptor field, Object value2) {
            return (Builder)super.setField(field, value2);
        }

        @Override
        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value2) {
            return (Builder)super.addRepeatedField(field, value2);
        }

        @Override
        public Builder mergeFrom(Message other) {
            if (other instanceof DigestProto) {
                return this.mergeFrom((DigestProto)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(DigestProto other) {
            if (other == DigestProto.getDefaultInstance()) {
                return this;
            }
            if (other.algorithmId_ != 0) {
                this.setAlgorithmIdValue(other.getAlgorithmIdValue());
            }
            if (other.getDigestBytes() != ByteString.EMPTY) {
                this.setDigestBytes(other.getDigestBytes());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        @Override
        public final boolean isInitialized() {
            return true;
        }

        @Override
        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block10: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block10;
                        }
                        case 8: {
                            this.algorithmId_ = input.readEnum();
                            this.bitField0_ |= 1;
                            continue block10;
                        }
                        case 18: {
                            this.digestBytes_ = input.readBytes();
                            this.bitField0_ |= 2;
                            continue block10;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        public Builder setAlgorithmIdValue(int value2) {
            this.algorithmId_ = value2;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder setAlgorithmId(AlgorithmId value2) {
            if (value2 == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 1;
            this.algorithmId_ = value2.getNumber();
            this.onChanged();
            return this;
        }

        public Builder setDigestBytes(ByteString value2) {
            if (value2 == null) {
                throw new NullPointerException();
            }
            this.digestBytes_ = value2;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        @Override
        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static final class AlgorithmId
    extends Enum<AlgorithmId>
    implements ProtocolMessageEnum {
        public static final /* enum */ AlgorithmId SHA256 = new AlgorithmId(0);
        public static final /* enum */ AlgorithmId SHA384 = new AlgorithmId(2);
        public static final /* enum */ AlgorithmId SHA512 = new AlgorithmId(1);
        public static final /* enum */ AlgorithmId UNRECOGNIZED = new AlgorithmId(-1);
        private static final Internal.EnumLiteMap<AlgorithmId> internalValueMap;
        private static final AlgorithmId[] VALUES;
        private final int value;
        private static final /* synthetic */ AlgorithmId[] $VALUES;

        public static AlgorithmId[] values() {
            return (AlgorithmId[])$VALUES.clone();
        }

        @Override
        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        public static AlgorithmId forNumber(int value2) {
            switch (value2) {
                case 0: {
                    return SHA256;
                }
                case 2: {
                    return SHA384;
                }
                case 1: {
                    return SHA512;
                }
            }
            return null;
        }

        private AlgorithmId(int value2) {
            this.value = value2;
        }

        static {
            $VALUES = new AlgorithmId[]{SHA256, SHA384, SHA512, UNRECOGNIZED};
            internalValueMap = new Internal.EnumLiteMap<AlgorithmId>(){};
            VALUES = AlgorithmId.values();
        }
    }
}

