/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.digest;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.zip.signer.datasource.DataSource;

public final class ChunkIterator
implements Iterator<ByteBuffer>,
KMappedMarker {
    @NotNull
    private final DataSource dataSource;
    private final int maximumChunkSize;
    private final int chunkCount;
    private int index;

    public ChunkIterator(@NotNull DataSource dataSource, int maximumChunkSize) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        this.dataSource = dataSource;
        this.maximumChunkSize = maximumChunkSize;
        this.chunkCount = this.getChunkCount(this.dataSource.size(), this.maximumChunkSize);
    }

    public final int getChunkCount() {
        return this.chunkCount;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.chunkCount;
    }

    @Override
    @NotNull
    public ByteBuffer next() {
        if (this.index < 0 || this.index >= this.chunkCount) {
            throw new NoSuchElementException();
        }
        int chunkSize = (int)RangesKt.coerceAtMost((long)(this.dataSource.size() - (long)(this.index * this.maximumChunkSize)), (long)this.maximumChunkSize);
        ByteBuffer chunk2 = this.dataSource.getByteBuffer((long)this.index * (long)this.maximumChunkSize, chunkSize);
        ++this.index;
        return chunk2;
    }

    private final int getChunkCount(long inputSize, int chunkSize) {
        long chunkCountLong = (inputSize + (long)chunkSize - 1L) / (long)chunkSize;
        if (!(this.chunkCount < Integer.MAX_VALUE)) {
            boolean bl = false;
            String string = "Number of chunks in dataSource is greater than max int.";
            throw new IllegalArgumentException(string.toString());
        }
        return (int)chunkCountLong;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

