/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.digest;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.UInt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.zip.signer.metadata.ContentDigestAlgorithm;
import org.jetbrains.zip.signer.utils.ByteArrayExtensionsKt;

@ExperimentalUnsignedTypes
public final class ChunkDigester {
    @NotNull
    private final ContentDigestAlgorithm digestAlgorithm;
    private final int chunkCount;
    private final byte chunkPrefix;
    private final MessageDigest messageDigest;
    @NotNull
    private final byte[] digest;
    private int position;

    /*
     * WARNING - void declaration
     */
    public ChunkDigester(@NotNull ContentDigestAlgorithm digestAlgorithm, int chunkCount) {
        void $this$digest_u24lambda_u240;
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)((Object)digestAlgorithm), (String)"digestAlgorithm");
        this.digestAlgorithm = digestAlgorithm;
        this.chunkCount = chunkCount;
        this.chunkPrefix = (byte)90;
        this.messageDigest = MessageDigest.getInstance(this.digestAlgorithm.getJcaMessageDigestAlgorithm());
        byte[] byArray2 = byArray = new byte[5 + this.chunkCount * this.digestAlgorithm.getChunkDigestOutputSizeBytes()];
        ChunkDigester chunkDigester = this;
        boolean bl = false;
        $this$digest_u24lambda_u240[0] = this.chunkPrefix;
        ByteArrayExtensionsKt.setUnsignedInt32LittleEndian-OsBMiQA((byte[])$this$digest_u24lambda_u240, UInt.constructor-impl((int)this.chunkCount), 1);
        chunkDigester.digest = byArray;
    }

    @NotNull
    public final ContentDigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public final void consume(@NotNull ByteBuffer chunk2) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)chunk2, (String)"chunk");
        if (this.position >= this.chunkCount) {
            throw new IllegalStateException("Too many chunks provided".toString());
        }
        byte[] $this$consume_u24lambda_u241 = byArray = new byte[5];
        boolean bl = false;
        $this$consume_u24lambda_u241[0] = this.chunkPrefix;
        ByteArrayExtensionsKt.setUnsignedInt32LittleEndian-OsBMiQA($this$consume_u24lambda_u241, UInt.constructor-impl((int)chunk2.remaining()), 1);
        byte[] chunkPrefix = byArray;
        this.messageDigest.update(chunkPrefix);
        this.messageDigest.update(chunk2);
        int bytesWritten = this.messageDigest.digest(this.digest, 5 + this.position * this.digestAlgorithm.getChunkDigestOutputSizeBytes(), this.digestAlgorithm.getChunkDigestOutputSizeBytes());
        if (!(bytesWritten == this.digestAlgorithm.getChunkDigestOutputSizeBytes())) {
            boolean bl2 = false;
            String string = "Digest algorithm output has an unexpected size";
            throw new IllegalArgumentException(string.toString());
        }
        ++this.position;
    }

    @NotNull
    public final byte[] getResult() {
        if (!(this.position == this.chunkCount)) {
            boolean bl = false;
            String string = "Not all chunks were processed";
            throw new IllegalArgumentException(string.toString());
        }
        return this.digest;
    }
}

