/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.datasource;

import java.nio.ByteBuffer;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.zip.signer.datasource.DataSource;

public final class ByteBufferDataSource
implements DataSource {
    @NotNull
    private final ByteBuffer buffer;
    private final int size;

    public ByteBufferDataSource(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.buffer = buffer;
        this.size = this.buffer.remaining();
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    @NotNull
    public ByteBuffer getByteBuffer(long offset, int size) {
        this.checkChunkValid(offset, size);
        int chunkPosition = (int)offset;
        int chunkLimit = chunkPosition + size;
        this.buffer.position(0);
        this.buffer.limit(chunkLimit);
        this.buffer.position(chunkPosition);
        ByteBuffer byteBuffer = this.buffer.slice();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"slice(...)");
        return byteBuffer;
    }

    @Override
    @NotNull
    public ByteBufferDataSource slice(long offset, long size) {
        if (offset == 0L && (int)size == this.size) {
            return this;
        }
        if (size < 0L || size > (long)this.size) {
            throw new IndexOutOfBoundsException("size: " + size + ", source size: " + size);
        }
        return new ByteBufferDataSource(this.getByteBuffer(offset, (int)size));
    }

    private final void checkChunkValid(long offset, long size) {
        long endOffset = offset + size;
        if (offset < 0L) {
            throw new IndexOutOfBoundsException("offset: " + offset);
        }
        if (size < 0L) {
            throw new IndexOutOfBoundsException("size: " + size);
        }
        if (offset > (long)this.size) {
            throw new IndexOutOfBoundsException("offset (" + offset + ") > source size (" + size + ')');
        }
        if (endOffset < offset) {
            throw new IndexOutOfBoundsException("offset (" + offset + ") + size (" + size + ") overflow");
        }
        if (endOffset > (long)this.size) {
            throw new IndexOutOfBoundsException("offset (" + offset + ") + size (" + size + ") > source size (" + size + ')');
        }
    }
}

