/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.plist;

import java.util.Map;
import java.util.Set;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.PlistValueType;

public final class Plist {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, PListValue> myMap;
    @NotNull
    private static final Plist EMPTY_PLIST = new Plist(MapsKt.emptyMap());

    public Plist(@NotNull Map<String, PListValue> myMap) {
        Intrinsics.checkNotNullParameter(myMap, (String)"myMap");
        this.myMap = myMap;
    }

    @Nullable
    public final PListValue getPlistValue(@NotNull String key2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        return this.myMap.get(key2);
    }

    @NotNull
    public final PListValue getPlistValue(@NotNull String key2, @NotNull Object defValue) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Intrinsics.checkNotNullParameter((Object)defValue, (String)"defValue");
        PListValue pListValue = this.myMap.get(key2);
        if (pListValue == null) {
            pListValue = new PListValue(defValue, PlistValueType.Companion.fromObject(defValue));
        }
        return pListValue;
    }

    @NotNull
    public final Set<Map.Entry<String, PListValue>> entries() {
        return this.myMap.entrySet();
    }

    @NotNull
    public String toString() {
        return "Plist(myMap=" + this.myMap + ")";
    }

    public int hashCode() {
        return ((Object)this.myMap).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Plist)) {
            return false;
        }
        Plist plist = (Plist)other;
        return Intrinsics.areEqual(this.myMap, plist.myMap);
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Plist getEMPTY_PLIST() {
            return EMPTY_PLIST;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

