/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.lexer;

import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;
import org.jetbrains.plugins.textmate.regex.TextMateCharOffset;

public final class TextmateToken {
    @NotNull
    private final TextMateScope scope;
    private final int startCharOffset;
    private final int endCharOffset;
    private final boolean restartable;

    private TextmateToken(TextMateScope scope2, int startCharOffset, int endCharOffset, boolean restartable2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        this.scope = scope2;
        this.startCharOffset = startCharOffset;
        this.endCharOffset = endCharOffset;
        this.restartable = restartable2;
    }

    @NotNull
    public final TextMateScope getScope() {
        return this.scope;
    }

    public final int getStartOffset() {
        return this.startCharOffset;
    }

    public final int getEndOffset() {
        return this.endCharOffset;
    }

    @NotNull
    public String toString() {
        return "TextmateToken(scope=" + this.scope + ", startCharOffset=" + TextMateCharOffset.toString-impl(this.startCharOffset) + ", endCharOffset=" + TextMateCharOffset.toString-impl(this.endCharOffset) + ", restartable=" + this.restartable + ")";
    }

    public int hashCode() {
        int result2 = this.scope.hashCode();
        result2 = result2 * 31 + TextMateCharOffset.hashCode-impl(this.startCharOffset);
        result2 = result2 * 31 + TextMateCharOffset.hashCode-impl(this.endCharOffset);
        result2 = result2 * 31 + Boolean.hashCode(this.restartable);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextmateToken)) {
            return false;
        }
        TextmateToken textmateToken = (TextmateToken)other;
        if (!Intrinsics.areEqual((Object)this.scope, (Object)textmateToken.scope)) {
            return false;
        }
        if (!TextMateCharOffset.equals-impl0(this.startCharOffset, textmateToken.startCharOffset)) {
            return false;
        }
        if (!TextMateCharOffset.equals-impl0(this.endCharOffset, textmateToken.endCharOffset)) {
            return false;
        }
        return this.restartable == textmateToken.restartable;
    }

    public /* synthetic */ TextmateToken(TextMateScope scope2, int startCharOffset, int endCharOffset, boolean restartable2, DefaultConstructorMarker $constructor_marker) {
        this(scope2, startCharOffset, endCharOffset, restartable2);
    }
}

