/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.lexer;

import java.util.Iterator;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.language.syntax.InjectionNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.lexer.SyntaxMatchUtils;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateLexerState;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateSyntaxMatcher;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorWeigher;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateWeigh;
import org.jetbrains.plugins.textmate.regex.MatchData;
import org.jetbrains.plugins.textmate.regex.RegexFacade;
import org.jetbrains.plugins.textmate.regex.RegexProvider;
import org.jetbrains.plugins.textmate.regex.TextMateByteOffset;
import org.jetbrains.plugins.textmate.regex.TextMateString;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class TextMateSyntaxMatcherImpl
implements TextMateSyntaxMatcher {
    @NotNull
    private final RegexProvider regexProvider;
    @NotNull
    private final TextMateSelectorWeigher mySelectorWeigher;

    public TextMateSyntaxMatcherImpl(@NotNull RegexProvider regexProvider, @NotNull TextMateSelectorWeigher mySelectorWeigher) {
        Intrinsics.checkNotNullParameter((Object)regexProvider, (String)"regexProvider");
        Intrinsics.checkNotNullParameter((Object)mySelectorWeigher, (String)"mySelectorWeigher");
        this.regexProvider = regexProvider;
        this.mySelectorWeigher = mySelectorWeigher;
    }

    @Override
    @NotNull
    public TextMateLexerState matchRule-4maaBYg(@NotNull SyntaxNodeDescriptor syntaxNodeDescriptor, @NotNull TextMateString string, int byteOffset, boolean matchBeginPosition, boolean matchBeginString, @NotNull TextMateWeigh.Priority priority, @NotNull TextMateScope currentScope, @NotNull List<InjectionNodeDescriptor> injections, @Nullable Runnable checkCancelledCallback) {
        SyntaxNodeDescriptor child2;
        Intrinsics.checkNotNullParameter((Object)syntaxNodeDescriptor, (String)"syntaxNodeDescriptor");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)((Object)priority), (String)"priority");
        Intrinsics.checkNotNullParameter((Object)currentScope, (String)"currentScope");
        Intrinsics.checkNotNullParameter(injections, (String)"injections");
        TextMateLexerState resultState = TextMateLexerState.Companion.notMatched(syntaxNodeDescriptor);
        List<SyntaxNodeDescriptor> children = syntaxNodeDescriptor.getChildren();
        Iterator<SyntaxNodeDescriptor> iterator2 = children.iterator();
        while (!(!iterator2.hasNext() || (resultState = this.moreImportantState(resultState, TextMateSyntaxMatcherImpl.matchFirstChild-4maaBYg$default(this, child2 = iterator2.next(), string, byteOffset, matchBeginPosition, matchBeginString, priority, injections, currentScope, null, 256, null))).getMatchData().getMatched() && TextMateByteOffset.equals-impl0(MatchData.byteRange$default(resultState.getMatchData(), 0, 1, null).getStart-Esigj34(), byteOffset))) {
        }
        return this.moreImportantState(resultState, this.matchInjections-C4GU3Sg(syntaxNodeDescriptor, string, byteOffset, matchBeginPosition, matchBeginString, currentScope, injections, checkCancelledCallback));
    }

    @Override
    @NotNull
    public MatchData matchStringRegex-pFV-0G8(@NotNull Constants.StringKey keyName, @NotNull TextMateString string, int byteOffset, boolean matchBeginPosition, boolean matchBeginString, @NotNull TextMateLexerState lexerState, @Nullable Runnable checkCancelledCallback) {
        CharSequence regex;
        Intrinsics.checkNotNullParameter((Object)((Object)keyName), (String)"keyName");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)lexerState, (String)"lexerState");
        CharSequence charSequence = regex = lexerState.getSyntaxRule().getStringAttribute(keyName);
        if (charSequence == null || charSequence.length() == 0) {
            return MatchData.Companion.getNOT_MATCHED();
        }
        CharSequence regexString = lexerState.getSyntaxRule().hasBackReference(keyName) ? (CharSequence)SyntaxMatchUtils.INSTANCE.replaceGroupsWithMatchDataInRegex(regex, lexerState.getString(), lexerState.getMatchData()) : regex;
        return (MatchData)this.regexProvider.withRegex(regexString, arg_0 -> TextMateSyntaxMatcherImpl.matchStringRegex_pFV_0G8$lambda$0(string, byteOffset, matchBeginPosition, matchBeginString, checkCancelledCallback, arg_0));
    }

    @Override
    public <T> T matchingString(@NotNull CharSequence s, @NotNull Function1<? super TextMateString, ? extends T> body) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        return this.regexProvider.withString(s, body);
    }

    private final TextMateLexerState matchFirstChild-4maaBYg(SyntaxNodeDescriptor syntaxNodeDescriptor, TextMateString string, int byteOffset, boolean matchBeginPosition, boolean matchBeginString, TextMateWeigh.Priority priority, List<InjectionNodeDescriptor> injections, TextMateScope currentScope, Runnable checkCancelledCallback) {
        CharSequence match2 = syntaxNodeDescriptor.getStringAttribute(Constants.StringKey.MATCH);
        if (match2 != null) {
            return match2.length() == 0 ? TextMateLexerState.Companion.notMatched(syntaxNodeDescriptor) : (TextMateLexerState)this.regexProvider.withRegex(match2, arg_0 -> TextMateSyntaxMatcherImpl.matchFirstChild_4maaBYg$lambda$1(string, byteOffset, matchBeginPosition, matchBeginString, checkCancelledCallback, syntaxNodeDescriptor, priority, arg_0));
        }
        CharSequence begin = syntaxNodeDescriptor.getStringAttribute(Constants.StringKey.BEGIN);
        if (begin != null) {
            return begin.length() == 0 ? TextMateLexerState.Companion.notMatched(syntaxNodeDescriptor) : (TextMateLexerState)this.regexProvider.withRegex(begin, arg_0 -> TextMateSyntaxMatcherImpl.matchFirstChild_4maaBYg$lambda$2(string, byteOffset, matchBeginPosition, matchBeginString, checkCancelledCallback, syntaxNodeDescriptor, priority, arg_0));
        }
        if (syntaxNodeDescriptor.getStringAttribute(Constants.StringKey.END) != null) {
            return TextMateLexerState.Companion.notMatched(syntaxNodeDescriptor);
        }
        return this.matchRule-4maaBYg(syntaxNodeDescriptor, string, byteOffset, matchBeginPosition, matchBeginString, priority, currentScope, injections, checkCancelledCallback);
    }

    static /* synthetic */ TextMateLexerState matchFirstChild-4maaBYg$default(TextMateSyntaxMatcherImpl textMateSyntaxMatcherImpl, SyntaxNodeDescriptor syntaxNodeDescriptor, TextMateString textMateString, int n, boolean bl, boolean bl2, TextMateWeigh.Priority priority, List list2, TextMateScope textMateScope, Runnable runnable2, int n2, Object object) {
        if ((n2 & 0x100) != 0) {
            runnable2 = null;
        }
        return textMateSyntaxMatcherImpl.matchFirstChild-4maaBYg(syntaxNodeDescriptor, textMateString, n, bl, bl2, priority, list2, textMateScope, runnable2);
    }

    private final boolean hasBeginKey(TextMateLexerState lexerState) {
        return lexerState.getSyntaxRule().getStringAttribute(Constants.StringKey.BEGIN) != null;
    }

    private final TextMateLexerState moreImportantState(TextMateLexerState oldState, TextMateLexerState newState) {
        int oldScore;
        if (!newState.getMatchData().getMatched()) {
            return oldState;
        }
        if (!oldState.getMatchData().getMatched()) {
            return newState;
        }
        int newScore = MatchData.byteRange$default(newState.getMatchData(), 0, 1, null).getStart-Esigj34();
        if ((TextMateByteOffset.compareTo-3kD0su4(newScore, oldScore = MatchData.byteRange$default(oldState.getMatchData(), 0, 1, null).getStart-Esigj34()) < 0 || TextMateByteOffset.equals-impl0(newScore, oldScore) && newState.getPriorityMatch().compareTo((Enum)oldState.getPriorityMatch()) > 0) && (!MatchData.byteRange$default(newState.getMatchData(), 0, 1, null).isEmpty() || MatchData.byteRange$default(oldState.getMatchData(), 0, 1, null).isEmpty() || this.hasBeginKey(newState))) {
            return newState;
        }
        return oldState;
    }

    private final TextMateLexerState matchInjections-C4GU3Sg(SyntaxNodeDescriptor syntaxNodeDescriptor, TextMateString string, int byteOffset, boolean matchBeginPosition, boolean matchBeginString, TextMateScope currentScope, List<InjectionNodeDescriptor> injections, Runnable checkCancelledCallback) {
        TextMateLexerState resultState = TextMateLexerState.Companion.notMatched(syntaxNodeDescriptor);
        for (InjectionNodeDescriptor injection : injections) {
            TextMateWeigh selectorWeigh = this.mySelectorWeigher.weigh(injection.getSelector(), currentScope);
            if (selectorWeigh.getWeigh() <= 0) continue;
            TextMateLexerState injectionState = this.matchRule-4maaBYg(injection.getSyntaxNodeDescriptor(), string, byteOffset, matchBeginPosition, matchBeginString, selectorWeigh.getPriority(), currentScope, CollectionsKt.emptyList(), checkCancelledCallback);
            resultState = this.moreImportantState(resultState, injectionState);
        }
        return resultState;
    }

    private static final MatchData matchStringRegex_pFV_0G8$lambda$0(TextMateString $string, int $byteOffset, boolean $matchBeginPosition, boolean $matchBeginString, Runnable $checkCancelledCallback, RegexFacade regexFacade) {
        Intrinsics.checkNotNullParameter((Object)regexFacade, (String)"regexFacade");
        return regexFacade.match-ZRjI0jQ($string, $byteOffset, $matchBeginPosition, $matchBeginString, $checkCancelledCallback);
    }

    private static final TextMateLexerState matchFirstChild_4maaBYg$lambda$1(TextMateString $string, int $byteOffset, boolean $matchBeginPosition, boolean $matchBeginString, Runnable $checkCancelledCallback, SyntaxNodeDescriptor $syntaxNodeDescriptor, TextMateWeigh.Priority $priority, RegexFacade regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        MatchData matchData = regex.match-ZRjI0jQ($string, $byteOffset, $matchBeginPosition, $matchBeginString, $checkCancelledCallback);
        return new TextMateLexerState($syntaxNodeDescriptor, matchData, $priority, $byteOffset, $string, null);
    }

    private static final TextMateLexerState matchFirstChild_4maaBYg$lambda$2(TextMateString $string, int $byteOffset, boolean $matchBeginPosition, boolean $matchBeginString, Runnable $checkCancelledCallback, SyntaxNodeDescriptor $syntaxNodeDescriptor, TextMateWeigh.Priority $priority, RegexFacade regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        MatchData matchData = regex.match-ZRjI0jQ($string, $byteOffset, $matchBeginPosition, $matchBeginString, $checkCancelledCallback);
        return new TextMateLexerState($syntaxNodeDescriptor, matchData, $priority, $byteOffset, $string, null);
    }
}

