/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.language.TextMateLanguageDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.InjectionNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxRawNode;
import org.jetbrains.plugins.textmate.language.syntax.TextMateSyntaxTableBuilderKt;
import org.jetbrains.plugins.textmate.language.syntax.TextMateSyntaxTableCore;

@SourceDebugExtension(value={"SMAP\nTextMateSyntaxTableBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextMateSyntaxTableBuilder.kt\norg/jetbrains/plugins/textmate/language/syntax/RawLanguageDescriptor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,340:1\n1617#2,9:341\n1869#2:350\n1870#2:352\n1626#2:353\n1#3:351\n*S KotlinDebug\n*F\n+ 1 TextMateSyntaxTableBuilder.kt\norg/jetbrains/plugins/textmate/language/syntax/RawLanguageDescriptor\n*L\n165#1:341,9\n165#1:350\n165#1:352\n165#1:353\n165#1:351\n*E\n"})
final class RawLanguageDescriptor {
    @NotNull
    private final CharSequence scopeName;
    @NotNull
    private final SyntaxRawNode rootSyntaxRawNode;
    @NotNull
    private final List<Pair<String, SyntaxRawNode>> rawInjections;

    public RawLanguageDescriptor(@NotNull CharSequence scopeName, @NotNull SyntaxRawNode rootSyntaxRawNode, @NotNull List<? extends Pair<String, ? extends SyntaxRawNode>> rawInjections) {
        Intrinsics.checkNotNullParameter((Object)scopeName, (String)"scopeName");
        Intrinsics.checkNotNullParameter((Object)rootSyntaxRawNode, (String)"rootSyntaxRawNode");
        Intrinsics.checkNotNullParameter(rawInjections, (String)"rawInjections");
        this.scopeName = scopeName;
        this.rootSyntaxRawNode = rootSyntaxRawNode;
        this.rawInjections = rawInjections;
    }

    @NotNull
    public final CharSequence getScopeName() {
        return this.scopeName;
    }

    @NotNull
    public final SyntaxRawNode getRootSyntaxRawNode() {
        return this.rootSyntaxRawNode;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final TextMateLanguageDescriptor compile(@NotNull Map<CharSequence, RawLanguageDescriptor> topLevelNodes, @NotNull Map<Integer, SyntaxNodeDescriptor> compiledNodes, @NotNull Map<Integer, Integer> ruleIdToReferenceRuleId, @NotNull TextMateSyntaxTableCore syntaxTable) {
        TextMateLanguageDescriptor textMateLanguageDescriptor;
        Intrinsics.checkNotNullParameter(topLevelNodes, (String)"topLevelNodes");
        Intrinsics.checkNotNullParameter(compiledNodes, (String)"compiledNodes");
        Intrinsics.checkNotNullParameter(ruleIdToReferenceRuleId, (String)"ruleIdToReferenceRuleId");
        Intrinsics.checkNotNullParameter((Object)syntaxTable, (String)"syntaxTable");
        SyntaxNodeDescriptor syntaxNodeDescriptor = this.rootSyntaxRawNode.compile(topLevelNodes, compiledNodes, ruleIdToReferenceRuleId, syntaxTable);
        if (syntaxNodeDescriptor != null) {
            void $this$mapNotNullTo$iv$iv;
            SyntaxNodeDescriptor rootNode = syntaxNodeDescriptor;
            boolean bl = false;
            Iterable $this$mapNotNull$iv = this.rawInjections;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                InjectionNodeDescriptor injectionNodeDescriptor;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                Pair pair = (Pair)element$iv$iv;
                boolean bl3 = false;
                String selector = (String)pair.component1();
                SyntaxRawNode injection = (SyntaxRawNode)pair.component2();
                if (injection.compile(topLevelNodes, compiledNodes, ruleIdToReferenceRuleId, syntaxTable) != null) {
                    SyntaxNodeDescriptor compiledRule;
                    boolean bl4 = false;
                    injectionNodeDescriptor = new InjectionNodeDescriptor(selector, compiledRule);
                } else {
                    injectionNodeDescriptor = null;
                }
                if (injectionNodeDescriptor == null) continue;
                InjectionNodeDescriptor it$iv$iv = injectionNodeDescriptor;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List injections = TextMateSyntaxTableBuilderKt.access$compactList((List)destination$iv$iv);
            textMateLanguageDescriptor = new TextMateLanguageDescriptor(this.scopeName, rootNode, injections);
        } else {
            textMateLanguageDescriptor = null;
        }
        return textMateLanguageDescriptor;
    }
}

