/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.concurrent;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.concurrent.TextMateLock;
import org.jetbrains.plugins.textmate.concurrent.TextMateThreadLocal;

public final class TextMateThreadLocalJvmKt {
    @NotNull
    public static final <T> TextMateThreadLocal<T> createTextMateThreadLocalJvm() {
        return new TextMateThreadLocal<T>(){
            private final ThreadLocal<T> threadLocal;
            {
                this.threadLocal = new ThreadLocal<T>();
            }

            public T get() {
                return this.threadLocal.get();
            }

            public void set(T value2) {
                this.threadLocal.set(value2);
            }
        };
    }

    @NotNull
    public static final TextMateLock createTextMateLockJvm() {
        return new TextMateLock(){
            private final ReentrantLock lock;
            {
                this.lock = new ReentrantLock();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public <T> T withLock(Function0<? extends T> body) {
                Object object;
                Intrinsics.checkNotNullParameter(body, (String)"body");
                Lock lock = this.lock;
                lock.lock();
                try {
                    object = body.invoke();
                }
                finally {
                    lock.unlock();
                }
                return (T)object;
            }
        };
    }
}

