/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.bundles;

import java.util.Collection;
import kotlin.Lazy;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.bundles.TextMateFileNameMatcher;
import org.jetbrains.plugins.textmate.plist.Plist;

public final class TextMateGrammar {
    @NotNull
    private final Collection<TextMateFileNameMatcher> fileNameMatchers;
    @Nullable
    private final String firstLinePattern;
    @NotNull
    private final Lazy<Plist> plist;
    @Nullable
    private final String overrideName;
    @Nullable
    private final String overrideScopeName;

    public TextMateGrammar(@NotNull Collection<? extends TextMateFileNameMatcher> fileNameMatchers, @Nullable String firstLinePattern, @NotNull Lazy<Plist> plist, @Nullable String overrideName, @Nullable String overrideScopeName) {
        Intrinsics.checkNotNullParameter(fileNameMatchers, (String)"fileNameMatchers");
        Intrinsics.checkNotNullParameter(plist, (String)"plist");
        this.fileNameMatchers = fileNameMatchers;
        this.firstLinePattern = firstLinePattern;
        this.plist = plist;
        this.overrideName = overrideName;
        this.overrideScopeName = overrideScopeName;
    }

    @NotNull
    public final Lazy<Plist> getPlist() {
        return this.plist;
    }

    @NotNull
    public String toString() {
        return "TextMateGrammar(fileNameMatchers=" + this.fileNameMatchers + ", firstLinePattern=" + this.firstLinePattern + ", plist=" + this.plist + ", overrideName=" + this.overrideName + ", overrideScopeName=" + this.overrideScopeName + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.fileNameMatchers).hashCode();
        result2 = result2 * 31 + (this.firstLinePattern == null ? 0 : this.firstLinePattern.hashCode());
        result2 = result2 * 31 + this.plist.hashCode();
        result2 = result2 * 31 + (this.overrideName == null ? 0 : this.overrideName.hashCode());
        result2 = result2 * 31 + (this.overrideScopeName == null ? 0 : this.overrideScopeName.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextMateGrammar)) {
            return false;
        }
        TextMateGrammar textMateGrammar = (TextMateGrammar)other;
        if (!Intrinsics.areEqual(this.fileNameMatchers, textMateGrammar.fileNameMatchers)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.firstLinePattern, (Object)textMateGrammar.firstLinePattern)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.plist, textMateGrammar.plist)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.overrideName, (Object)textMateGrammar.overrideName)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.overrideScopeName, (Object)textMateGrammar.overrideScopeName);
    }
}

