/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.patronus.client.model;

import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.patronus.client.model.TeamCityBuildProblem;
import org.jetbrains.patronus.client.model.TeamCityBuildStatus;
import org.jetbrains.patronus.client.model.TeamCityFailedTest;

public final class TeamCityBuild {
    @NotNull
    private final String buildId;
    @NotNull
    private final String buildUrl;
    @NotNull
    private final String buildConfigurationId;
    @NotNull
    private final String buildConfigurationUrl;
    @NotNull
    private final String buildConfigurationName;
    @NotNull
    private final String fullProjectName;
    @NotNull
    private final TeamCityBuildStatus status;
    private final boolean isFailedToStart;
    private final boolean isComposite;
    private final boolean isFailedTestsOnlyFailure;
    @NotNull
    private final List<TeamCityBuildProblem> problems;
    @NotNull
    private final List<TeamCityFailedTest> failedTests;

    public TeamCityBuild(@NotNull String buildId, @NotNull String buildUrl, @NotNull String buildConfigurationId, @NotNull String buildConfigurationUrl, @NotNull String buildConfigurationName, @NotNull String fullProjectName, @NotNull TeamCityBuildStatus status2, boolean isFailedToStart, boolean isComposite, boolean isFailedTestsOnlyFailure, @NotNull List<TeamCityBuildProblem> problems, @NotNull List<TeamCityFailedTest> failedTests) {
        Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
        Intrinsics.checkNotNullParameter((Object)buildUrl, (String)"buildUrl");
        Intrinsics.checkNotNullParameter((Object)buildConfigurationId, (String)"buildConfigurationId");
        Intrinsics.checkNotNullParameter((Object)buildConfigurationUrl, (String)"buildConfigurationUrl");
        Intrinsics.checkNotNullParameter((Object)buildConfigurationName, (String)"buildConfigurationName");
        Intrinsics.checkNotNullParameter((Object)fullProjectName, (String)"fullProjectName");
        Intrinsics.checkNotNullParameter((Object)((Object)status2), (String)"status");
        Intrinsics.checkNotNullParameter(problems, (String)"problems");
        Intrinsics.checkNotNullParameter(failedTests, (String)"failedTests");
        this.buildId = buildId;
        this.buildUrl = buildUrl;
        this.buildConfigurationId = buildConfigurationId;
        this.buildConfigurationUrl = buildConfigurationUrl;
        this.buildConfigurationName = buildConfigurationName;
        this.fullProjectName = fullProjectName;
        this.status = status2;
        this.isFailedToStart = isFailedToStart;
        this.isComposite = isComposite;
        this.isFailedTestsOnlyFailure = isFailedTestsOnlyFailure;
        this.problems = problems;
        this.failedTests = failedTests;
    }

    @NotNull
    public String toString() {
        return "TeamCityBuild(buildId=" + this.buildId + ", buildUrl=" + this.buildUrl + ", buildConfigurationId=" + this.buildConfigurationId + ", buildConfigurationUrl=" + this.buildConfigurationUrl + ", buildConfigurationName=" + this.buildConfigurationName + ", fullProjectName=" + this.fullProjectName + ", status=" + this.status + ", isFailedToStart=" + this.isFailedToStart + ", isComposite=" + this.isComposite + ", isFailedTestsOnlyFailure=" + this.isFailedTestsOnlyFailure + ", problems=" + this.problems + ", failedTests=" + this.failedTests + ")";
    }

    public int hashCode() {
        int result2 = this.buildId.hashCode();
        result2 = result2 * 31 + this.buildUrl.hashCode();
        result2 = result2 * 31 + this.buildConfigurationId.hashCode();
        result2 = result2 * 31 + this.buildConfigurationUrl.hashCode();
        result2 = result2 * 31 + this.buildConfigurationName.hashCode();
        result2 = result2 * 31 + this.fullProjectName.hashCode();
        result2 = result2 * 31 + this.status.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.isFailedToStart);
        result2 = result2 * 31 + Boolean.hashCode(this.isComposite);
        result2 = result2 * 31 + Boolean.hashCode(this.isFailedTestsOnlyFailure);
        result2 = result2 * 31 + ((Object)this.problems).hashCode();
        result2 = result2 * 31 + ((Object)this.failedTests).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TeamCityBuild)) {
            return false;
        }
        TeamCityBuild teamCityBuild = (TeamCityBuild)other;
        if (!Intrinsics.areEqual((Object)this.buildId, (Object)teamCityBuild.buildId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.buildUrl, (Object)teamCityBuild.buildUrl)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.buildConfigurationId, (Object)teamCityBuild.buildConfigurationId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.buildConfigurationUrl, (Object)teamCityBuild.buildConfigurationUrl)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.buildConfigurationName, (Object)teamCityBuild.buildConfigurationName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fullProjectName, (Object)teamCityBuild.fullProjectName)) {
            return false;
        }
        if (this.status != teamCityBuild.status) {
            return false;
        }
        if (this.isFailedToStart != teamCityBuild.isFailedToStart) {
            return false;
        }
        if (this.isComposite != teamCityBuild.isComposite) {
            return false;
        }
        if (this.isFailedTestsOnlyFailure != teamCityBuild.isFailedTestsOnlyFailure) {
            return false;
        }
        if (!Intrinsics.areEqual(this.problems, teamCityBuild.problems)) {
            return false;
        }
        return Intrinsics.areEqual(this.failedTests, teamCityBuild.failedTests);
    }
}

