/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.patronus.client.model;

import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Principal {

    public static final class Application
    implements Principal {
        @NotNull
        private final String id;
        @NotNull
        private final String name;

        public Application(@NotNull String id, @NotNull String name2) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            this.id = id;
            this.name = name2;
        }

        @NotNull
        public String toString() {
            return "Application(id=" + this.id + ", name=" + this.name + ")";
        }

        public int hashCode() {
            int result2 = this.id.hashCode();
            result2 = result2 * 31 + this.name.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Application)) {
                return false;
            }
            Application application = (Application)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)application.id)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.name, (Object)application.name);
        }
    }

    public static final class User
    implements Principal {
        @NotNull
        private final String id;
        @NotNull
        private final String name;
        @NotNull
        private final String email;

        public User(@NotNull String id, @NotNull String name2, @NotNull String email) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)email, (String)"email");
            this.id = id;
            this.name = name2;
            this.email = email;
        }

        @NotNull
        public String toString() {
            return "User(id=" + this.id + ", name=" + this.name + ", email=" + this.email + ")";
        }

        public int hashCode() {
            int result2 = this.id.hashCode();
            result2 = result2 * 31 + this.name.hashCode();
            result2 = result2 * 31 + this.email.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof User)) {
                return false;
            }
            User user = (User)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)user.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)user.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.email, (Object)user.email);
        }
    }
}

