/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.patronus.api.dto;

import java.util.UUID;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import org.jetbrains.annotations.NotNull;

public final class UUIDSerializer
implements KSerializer<UUID> {
    @NotNull
    public static final UUIDSerializer INSTANCE = new UUIDSerializer();
    @NotNull
    private static final SerialDescriptor descriptor = SerialDescriptorsKt.PrimitiveSerialDescriptor((String)"UUID", (PrimitiveKind)((PrimitiveKind)PrimitiveKind.STRING.INSTANCE));

    private UUIDSerializer() {
    }

    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    @NotNull
    public UUID deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        UUID uUID = UUID.fromString(decoder.decodeString());
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
        return uUID;
    }

    public void serialize(@NotNull Encoder encoder, @NotNull UUID value2) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        String string = value2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        encoder.encodeString(string);
    }
}

