/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.nativecerts.linux;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.nativecerts.NativeTrustedRootsInternalUtils;

public class PemReaderUtil {
    public static List<X509Certificate> readPemBundle(@NotNull InputStream inputStream, @NotNull String moniker) throws IOException {
        ArrayList<X509Certificate> result2 = new ArrayList<X509Certificate>();
        try (LineNumberReader reader2 = new LineNumberReader(new InputStreamReader(inputStream, StandardCharsets.US_ASCII));){
            String line;
            while ((line = reader2.readLine()) != null) {
                String outerTrimmed = line.trim();
                if (outerTrimmed.isEmpty() || !outerTrimmed.equals("-----BEGIN CERTIFICATE-----")) continue;
                StringBuilder base64encoded = new StringBuilder();
                while (true) {
                    if ((line = reader2.readLine()) == null) {
                        throw new IllegalStateException("Non-closed '-----BEGIN CERTIFICATE-----' block at line " + reader2.getLineNumber() + " : " + moniker);
                    }
                    String innerTrimmed = line.trim();
                    if (innerTrimmed.isEmpty()) continue;
                    if (innerTrimmed.equals("-----END CERTIFICATE-----")) break;
                    base64encoded.append(line.trim());
                }
                byte[] derEncoding = Base64.getDecoder().decode(base64encoded.toString());
                X509Certificate certificate2 = NativeTrustedRootsInternalUtils.parseCertificate(derEncoding);
                result2.add(certificate2);
            }
        }
        return Collections.unmodifiableList(result2);
    }
}

