/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers;

import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownParsingException;
import org.intellij.markdown.lexer.Compat;
import org.intellij.markdown.lexer.TokenInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nTokensCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TokensCache.kt\norg/intellij/markdown/parser/sequentialparsers/TokensCache\n+ 2 Compat.kt\norg/intellij/markdown/lexer/Compat\n+ 3 Compat.kt\norg/intellij/markdown/lexer/Compat$assert$1\n*L\n1#1,146:1\n106#2,3:147\n110#2:151\n106#2,3:152\n110#2:156\n106#3:150\n106#3:155\n*S KotlinDebug\n*F\n+ 1 TokensCache.kt\norg/intellij/markdown/parser/sequentialparsers/TokensCache\n*L\n21#1:147,3\n21#1:151\n24#1:152,3\n24#1:156\n21#1:150\n24#1:155\n*E\n"})
public abstract class TokensCache {
    @NotNull
    public abstract List<TokenInfo> getCachedTokens();

    @NotNull
    public abstract List<TokenInfo> getFilteredTokens();

    @NotNull
    public abstract CharSequence getOriginalText();

    @NotNull
    public abstract IntRange getOriginalTextRange();

    public final char getRawCharAt(int index) {
        if (index < this.getOriginalTextRange().getFirst()) {
            return '\u0000';
        }
        if (index > this.getOriginalTextRange().getLast()) {
            return '\u0000';
        }
        return this.getOriginalText().charAt(index);
    }

    protected final void verify() {
        boolean $i$f$assert;
        boolean condition$iv;
        int i2;
        int n = ((Collection)this.getCachedTokens()).size();
        for (i2 = 0; i2 < n; ++i2) {
            Compat compat = Compat.INSTANCE;
            condition$iv = this.getCachedTokens().get(i2).getRawIndex() == i2;
            $i$f$assert = false;
            if (condition$iv) continue;
            boolean bl = false;
            String string = "";
            throw new MarkdownParsingException(string);
        }
        n = ((Collection)this.getFilteredTokens()).size();
        for (i2 = 0; i2 < n; ++i2) {
            Compat $this$iv = Compat.INSTANCE;
            condition$iv = this.getFilteredTokens().get(i2).getNormIndex() == i2;
            $i$f$assert = false;
            if (condition$iv) continue;
            boolean bl = false;
            String string = "";
            throw new MarkdownParsingException(string);
        }
    }

    public class Iterator {
        private final int index;

        public Iterator(int index) {
            this.index = index;
        }

        public final int getIndex() {
            return this.index;
        }

        @Nullable
        public final IElementType getType() {
            return this.info(0).getType();
        }

        public final char getFirstChar() {
            return TokensCache.this.getRawCharAt(this.info(0).getTokenStart());
        }

        public final int getLength() {
            return this.info(0).getTokenEnd() - this.info(0).getTokenStart();
        }

        public final int getStart() {
            return this.info(0).getTokenStart();
        }

        public final int getEnd() {
            return this.info(0).getTokenEnd();
        }

        @NotNull
        public Iterator advance() {
            return new Iterator(this.index + 1);
        }

        private final TokenInfo info(int rawSteps) {
            int rawIndex;
            if (this.index < 0) {
                return new TokenInfo(null, TokensCache.this.getOriginalTextRange().getFirst(), TokensCache.this.getOriginalTextRange().getFirst(), 0, 0);
            }
            if (this.index > TokensCache.this.getFilteredTokens().size()) {
                return new TokenInfo(null, TokensCache.this.getOriginalTextRange().getLast() + 1, TokensCache.this.getOriginalTextRange().getLast() + 1, 0, 0);
            }
            int n = rawIndex = this.index < TokensCache.this.getFilteredTokens().size() ? TokensCache.this.getFilteredTokens().get(this.index).getRawIndex() + rawSteps : TokensCache.this.getCachedTokens().size() + rawSteps;
            if (rawIndex < 0) {
                return new TokenInfo(null, TokensCache.this.getOriginalTextRange().getFirst(), TokensCache.this.getOriginalTextRange().getFirst(), 0, 0);
            }
            if (rawIndex >= TokensCache.this.getCachedTokens().size()) {
                return new TokenInfo(null, TokensCache.this.getOriginalTextRange().getLast() + 1, TokensCache.this.getOriginalTextRange().getLast() + 1, 0, 0);
            }
            return TokensCache.this.getCachedTokens().get(rawIndex);
        }

        @Nullable
        public IElementType rawLookup(int steps) {
            return this.info(steps).getType();
        }

        public final int rawStart(int steps) {
            return this.info(steps).getTokenStart();
        }

        public char charLookup(int steps) {
            if (steps == 0) {
                return TokensCache.this.getRawCharAt(this.getStart());
            }
            switch (steps) {
                case 1: {
                    return TokensCache.this.getRawCharAt(this.getEnd());
                }
                case -1: {
                    return TokensCache.this.getRawCharAt(this.getStart() - 1);
                }
            }
            int pos = steps > 0 ? this.rawStart(steps) : this.rawStart(steps + 1) - 1;
            return TokensCache.this.getRawCharAt(pos);
        }

        @NotNull
        public String toString() {
            return "Iterator: " + this.index + ": " + this.getType();
        }
    }

    public final class RangesListIterator
    extends Iterator {
        @NotNull
        private final List<IntRange> ranges;
        private final int listIndex;
        final /* synthetic */ TokensCache this$0;

        private RangesListIterator(TokensCache this$0, List<IntRange> ranges, int listIndex, int value2) {
            this.this$0 = this$0;
            super(value2);
            this.ranges = ranges;
            this.listIndex = listIndex;
        }

        public RangesListIterator(@NotNull TokensCache this$0, List<IntRange> ranges) {
            Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
            IntRange intRange = (IntRange)CollectionsKt.firstOrNull(ranges);
            this(this$0, ranges, 0, intRange != null ? intRange.getStart() : -1);
        }

        @Override
        @NotNull
        public RangesListIterator advance() {
            if (this.listIndex >= this.ranges.size()) {
                return this;
            }
            if (this.getIndex() == this.ranges.get(this.listIndex).getLast()) {
                IntRange intRange = (IntRange)CollectionsKt.getOrNull(this.ranges, (int)(this.listIndex + 1));
                return new RangesListIterator(this.this$0, this.ranges, this.listIndex + 1, intRange != null ? intRange.getStart().intValue() : this.this$0.getFilteredTokens().size());
            }
            return new RangesListIterator(this.this$0, this.ranges, this.listIndex, this.getIndex() + 1);
        }

        @Override
        @Nullable
        public IElementType rawLookup(int steps) {
            IntRange intRange = (IntRange)CollectionsKt.getOrNull(this.ranges, (int)this.listIndex);
            if (intRange == null) {
                return null;
            }
            IntRange intRange2 = intRange;
            int n = intRange2.getFirst();
            int n2 = intRange2.getLast();
            int n3 = this.getIndex() + steps;
            boolean bl = n <= n3 ? n3 <= n2 : false;
            if (bl) {
                return super.rawLookup(steps);
            }
            return null;
        }
    }
}

