/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.parser.CancellationToken;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.jetbrains.annotations.NotNull;

public abstract class SequentialParserManager {
    @NotNull
    public abstract List<SequentialParser> getParserSequence();

    @NotNull
    public final Collection<SequentialParser.Node> runParsingSequence(@NotNull TokensCache tokensCache, @NotNull List<IntRange> rangesToParse, @NotNull CancellationToken cancellationToken) {
        Intrinsics.checkNotNullParameter((Object)tokensCache, (String)"tokensCache");
        Intrinsics.checkNotNullParameter(rangesToParse, (String)"rangesToParse");
        Intrinsics.checkNotNullParameter((Object)cancellationToken, (String)"cancellationToken");
        ArrayList<SequentialParser.Node> result2 = new ArrayList<SequentialParser.Node>();
        ArrayList<List<IntRange>> parsingSpaces = new ArrayList<List<IntRange>>();
        parsingSpaces.add(rangesToParse);
        for (SequentialParser sequentialParser : this.getParserSequence()) {
            cancellationToken.checkCancelled();
            ArrayList<List<IntRange>> nextLevelSpaces = new ArrayList<List<IntRange>>();
            for (List list2 : parsingSpaces) {
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"parsingSpace");
                SequentialParser.ParsingResult currentResult = sequentialParser.parse(tokensCache, list2);
                result2.addAll(currentResult.getParsedNodes());
                nextLevelSpaces.addAll(currentResult.getRangesToProcessFurther());
            }
            parsingSpaces = nextLevelSpaces;
        }
        return result2;
    }
}

