/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.HorizontalRuleMarkerBlock;
import org.jetbrains.annotations.NotNull;

public final class HorizontalRuleProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkNotNullParameter((Object)stateInfo, (String)"stateInfo");
        if (this.matches(pos, stateInfo.getCurrentConstraints())) {
            return CollectionsKt.listOf((Object)new HorizontalRuleMarkerBlock(stateInfo.getCurrentConstraints(), productionHolder.mark()));
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        return this.matches(pos, constraints);
    }

    public final boolean matches(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        if (!MarkerBlockProvider.Companion.isStartOfLineWithConstraints(pos, constraints)) {
            return false;
        }
        return Companion.isHorizontalRule(pos.getCurrentLine(), pos.getOffsetInCurrentLine());
    }

    public static final class Companion {
        private Companion() {
        }

        public final boolean isHorizontalRule(@NotNull CharSequence line, int offset) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            Character hrChar = null;
            int startSpace = 0;
            int charCount = 1;
            int n = line.length();
            for (int i2 = offset; i2 < n; ++i2) {
                char c = line.charAt(i2);
                if (hrChar == null) {
                    if (c == '*' || c == '-' || c == '_') {
                        hrChar = Character.valueOf(c);
                        continue;
                    }
                    if (startSpace < 3 && c == ' ') {
                        ++startSpace;
                        continue;
                    }
                    return false;
                }
                if (c == hrChar.charValue()) {
                    ++charCount;
                    continue;
                }
                if (c == ' ' || c == '\t') continue;
                return false;
            }
            return charCount >= 3;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

