/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.constraints.MarkdownConstraintsKt;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.BlockQuoteMarkerBlock;
import org.jetbrains.annotations.NotNull;

public final class BlockQuoteProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkNotNullParameter((Object)stateInfo, (String)"stateInfo");
        MarkdownConstraints currentConstraints = stateInfo.getCurrentConstraints();
        MarkdownConstraints nextConstraints = stateInfo.getNextConstraints();
        if (pos.getOffsetInCurrentLine() != MarkdownConstraintsKt.getCharsEaten(currentConstraints, pos.getCurrentLine())) {
            return CollectionsKt.emptyList();
        }
        if (!Intrinsics.areEqual((Object)nextConstraints, (Object)currentConstraints)) {
            Character c = ArraysKt.lastOrNull((char[])nextConstraints.getTypes());
            char c2 = '>';
            if (c != null && c.charValue() == c2) {
                return CollectionsKt.listOf((Object)new BlockQuoteMarkerBlock(nextConstraints, productionHolder.mark()));
            }
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        return false;
    }
}

