/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.impl;

import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownParsingException;
import org.intellij.markdown.lexer.Compat;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.constraints.MarkdownConstraintsKt;
import org.intellij.markdown.parser.markerblocks.MarkdownParserUtil;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockImpl;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nListMarkerBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListMarkerBlock.kt\norg/intellij/markdown/parser/markerblocks/impl/ListMarkerBlock\n+ 2 Compat.kt\norg/intellij/markdown/lexer/Compat\n+ 3 Compat.kt\norg/intellij/markdown/lexer/Compat$assert$1\n*L\n1#1,57:1\n106#2,3:58\n110#2:62\n106#3:61\n*S KotlinDebug\n*F\n+ 1 ListMarkerBlock.kt\norg/intellij/markdown/parser/markerblocks/impl/ListMarkerBlock\n*L\n33#1:58,3\n33#1:62\n33#1:61\n*E\n"})
public final class ListMarkerBlock
extends MarkerBlockImpl {
    private final char listType;

    public ListMarkerBlock(@NotNull MarkdownConstraints myConstraints, @NotNull ProductionHolder.Marker marker, char listType) {
        Intrinsics.checkNotNullParameter((Object)myConstraints, (String)"myConstraints");
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        super(myConstraints, marker);
        this.listType = listType;
    }

    @Override
    public boolean allowsSubBlocks() {
        return true;
    }

    @Override
    public boolean isInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return pos.getOffsetInCurrentLine() == -1;
    }

    @Override
    @NotNull
    protected MarkerBlock.ClosingAction getDefaultAction() {
        return MarkerBlock.ClosingAction.DONE;
    }

    @Override
    protected int calcNextInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Integer n = pos.getNextLineOffset();
        return n != null ? n : -1;
    }

    @Override
    @NotNull
    protected MarkerBlock.ProcessingResult doProcessToken(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints currentConstraints) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)currentConstraints, (String)"currentConstraints");
        Compat compat = Compat.INSTANCE;
        boolean condition$iv = pos.getOffsetInCurrentLine() == -1;
        boolean $i$f$assert = false;
        if (!condition$iv) {
            boolean bl = false;
            String string = "";
            throw new MarkdownParsingException(string);
        }
        int eolN = MarkdownParserUtil.INSTANCE.calcNumberOfConsequentEols(pos, this.getConstraints());
        if (eolN >= 3) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        LookaheadText.Position position = MarkdownParserUtil.INSTANCE.getFirstNonWhitespaceLinePos(pos, eolN);
        if (position == null) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        LookaheadText.Position nonemptyPos = position;
        MarkdownConstraints nextLineConstraints = MarkdownConstraintsKt.applyToNextLineAndAddModifiers(this.getConstraints(), nonemptyPos);
        if (!MarkdownConstraintsKt.extendsList(nextLineConstraints, this.getConstraints())) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        return MarkerBlock.ProcessingResult.Companion.getPASS();
    }

    @Override
    @NotNull
    public IElementType getDefaultNodeType() {
        return this.listType == '-' || this.listType == '*' || this.listType == '+' ? MarkdownElementTypes.UNORDERED_LIST : MarkdownElementTypes.ORDERED_LIST;
    }
}

