/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.impl;

import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.Regex;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.constraints.MarkdownConstraintsKt;
import org.intellij.markdown.parser.markerblocks.MarkdownParserUtil;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockImpl;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HtmlBlockMarkerBlock
extends MarkerBlockImpl {
    @NotNull
    private final ProductionHolder productionHolder;
    @Nullable
    private final Regex endCheckingRegex;

    public HtmlBlockMarkerBlock(@NotNull MarkdownConstraints myConstraints, @NotNull ProductionHolder productionHolder, @Nullable Regex endCheckingRegex, @NotNull LookaheadText.Position startPosition) {
        Intrinsics.checkNotNullParameter((Object)myConstraints, (String)"myConstraints");
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkNotNullParameter((Object)startPosition, (String)"startPosition");
        super(myConstraints, productionHolder.mark());
        this.productionHolder = productionHolder;
        this.endCheckingRegex = endCheckingRegex;
        this.productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node(new IntRange(startPosition.getOffset(), startPosition.getNextLineOrEofOffset()), MarkdownTokenTypes.HTML_BLOCK_CONTENT)));
    }

    @Override
    public boolean allowsSubBlocks() {
        return false;
    }

    @Override
    public boolean isInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return true;
    }

    @Override
    @NotNull
    protected MarkerBlock.ClosingAction getDefaultAction() {
        return MarkerBlock.ClosingAction.DONE;
    }

    @Override
    @NotNull
    protected MarkerBlock.ProcessingResult doProcessToken(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints currentConstraints) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)currentConstraints, (String)"currentConstraints");
        if (pos.getOffsetInCurrentLine() != -1) {
            return MarkerBlock.ProcessingResult.Companion.getCANCEL();
        }
        String string = pos.getPrevLine();
        if (string == null) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        String prevLine = string;
        if (!MarkdownConstraintsKt.extendsPrev(this.getConstraints().applyToNextLine(pos), this.getConstraints())) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        if (this.endCheckingRegex == null && MarkdownParserUtil.INSTANCE.calcNumberOfConsequentEols(pos, this.getConstraints()) >= 2) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        if (this.endCheckingRegex != null && Regex.find$default((Regex)this.endCheckingRegex, (CharSequence)prevLine, (int)0, (int)2, null) != null) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        if (((CharSequence)pos.getCurrentLine()).length() > 0) {
            this.productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node(new IntRange(pos.getOffset() + 1 + MarkdownConstraintsKt.getCharsEaten(this.getConstraints(), pos.getCurrentLine()), pos.getNextLineOrEofOffset()), MarkdownTokenTypes.HTML_BLOCK_CONTENT)));
        }
        return MarkerBlock.ProcessingResult.Companion.getCANCEL();
    }

    @Override
    protected int calcNextInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return pos.getNextLineOrEofOffset();
    }

    @Override
    @NotNull
    public IElementType getDefaultNodeType() {
        return MarkdownElementTypes.HTML_BLOCK;
    }
}

