/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks;

import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.markdown.MarkdownParsingException;
import org.intellij.markdown.lexer.Compat;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.constraints.MarkdownConstraintsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nMarkdownParserUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownParserUtil.kt\norg/intellij/markdown/parser/markerblocks/MarkdownParserUtil\n+ 2 Compat.kt\norg/intellij/markdown/lexer/Compat\n+ 3 Compat.kt\norg/intellij/markdown/lexer/Compat$assert$1\n*L\n1#1,97:1\n106#2,3:98\n110#2:102\n106#3:101\n*S KotlinDebug\n*F\n+ 1 MarkdownParserUtil.kt\norg/intellij/markdown/parser/markerblocks/MarkdownParserUtil\n*L\n10#1:98,3\n10#1:102\n10#1:101\n*E\n"})
public final class MarkdownParserUtil {
    @NotNull
    public static final MarkdownParserUtil INSTANCE = new MarkdownParserUtil();

    private MarkdownParserUtil() {
    }

    public final int calcNumberOfConsequentEols(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        Compat compat = Compat.INSTANCE;
        boolean condition$iv = pos.getOffsetInCurrentLine() == -1;
        boolean $i$f$assert = false;
        if (!condition$iv) {
            boolean bl = false;
            String string = "";
            throw new MarkdownParsingException(string);
        }
        LookaheadText.Position currentPos = pos;
        int result2 = 1;
        Function1 isClearLine2 = (Function1)new Function1<LookaheadText.Position, Boolean>(constraints){
            final /* synthetic */ MarkdownConstraints $constraints;
            {
                this.$constraints = $constraints;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            public final Boolean invoke(LookaheadText.Position pos) {
                boolean bl;
                block2: {
                    block3: {
                        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
                        MarkdownConstraints currentConstraints = this.$constraints.applyToNextLine(pos);
                        int constraintsLength = MarkdownConstraintsKt.getCharsEaten(currentConstraints, pos.getCurrentLine());
                        if (!MarkdownConstraintsKt.upstreamWith(currentConstraints, this.$constraints)) break block2;
                        if (constraintsLength >= pos.getCurrentLine().length()) break block3;
                        LookaheadText.Position position = pos.nextPosition(1 + constraintsLength);
                        if ((position != null ? position.charsToNonWhitespace() : null) != null) break block2;
                    }
                    bl = true;
                    return bl;
                }
                bl = false;
                return bl;
            }
        };
        while (((Boolean)isClearLine2.invoke((Object)currentPos)).booleanValue() && currentPos.nextLinePosition() != null && ++result2 <= 4) {
        }
        return result2;
    }

    @Nullable
    public final LookaheadText.Position getFirstNonWhitespaceLinePos(@NotNull LookaheadText.Position pos, int eolsToSkip) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        LookaheadText.Position currentPos = null;
        currentPos = pos;
        int n = eolsToSkip - 1;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            if (pos.nextLinePosition() != null) continue;
            return null;
        }
        while (currentPos.charsToNonWhitespace() == null) {
            if (currentPos.nextLinePosition() != null) continue;
            return null;
        }
        return currentPos;
    }

    public final boolean hasCodeBlockIndent(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        int constraintsLength = MarkdownConstraintsKt.getCharsEaten(constraints, pos.getCurrentLine());
        if (pos.getOffsetInCurrentLine() >= constraintsLength + 4) {
            return true;
        }
        int i2 = constraintsLength;
        int n = pos.getOffsetInCurrentLine();
        if (i2 <= n) {
            while (true) {
                if (pos.getCurrentLine().charAt(i2) == '\t') {
                    return true;
                }
                if (i2 == n) break;
                ++i2;
            }
        }
        return false;
    }

    public final boolean isEmptyOrSpaces(@NotNull CharSequence s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        for (int j = 0; j < s.length(); ++j) {
            char c = s.charAt(j);
            if (c == ' ' || c == '\t') continue;
            return false;
        }
        return true;
    }

    @Nullable
    public final LookaheadText.Position findNonEmptyLineWithSameConstraints(@NotNull MarkdownConstraints constraints, @NotNull LookaheadText.Position pos) {
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        LookaheadText.Position currentPos = pos;
        MarkdownConstraints nextLineConstraints;
        while (MarkdownConstraintsKt.upstreamWith(nextLineConstraints = MarkdownConstraintsKt.applyToNextLineAndAddModifiers(constraints, currentPos), constraints) && MarkdownConstraintsKt.extendsPrev(nextLineConstraints, constraints)) {
            CharSequence stringAfterConstraints = MarkdownConstraintsKt.eatItselfFromString(nextLineConstraints, currentPos.getCurrentLine());
            if (!INSTANCE.isEmptyOrSpaces(stringAfterConstraints)) {
                return currentPos;
            }
            if (currentPos.nextLinePosition() != null) continue;
            return null;
        }
        return null;
    }
}

