/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.constraints;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.intellij.markdown.MarkdownParsingException;
import org.intellij.markdown.lexer.Compat;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.constraints.MarkdownConstraintsKt;
import org.intellij.markdown.parser.markerblocks.providers.HorizontalRuleProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nCommonMarkdownConstraints.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonMarkdownConstraints.kt\norg/intellij/markdown/parser/constraints/CommonMarkdownConstraints\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Compat.kt\norg/intellij/markdown/lexer/Compat\n*L\n1#1,293:1\n2632#2,3:294\n1755#2,3:297\n107#3,4:300\n*S KotlinDebug\n*F\n+ 1 CommonMarkdownConstraints.kt\norg/intellij/markdown/parser/constraints/CommonMarkdownConstraints\n*L\n33#1:294,3\n37#1:297,3\n53#1:300,4\n*E\n"})
public class CommonMarkdownConstraints
implements MarkdownConstraints {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final int[] indents;
    @NotNull
    private final char[] types;
    @NotNull
    private final boolean[] isExplicit;
    private final int charsEaten;
    @NotNull
    private static final CommonMarkdownConstraints BASE = new CommonMarkdownConstraints(new int[0], new char[0], new boolean[0], 0);

    protected CommonMarkdownConstraints(@NotNull int[] indents, @NotNull char[] types, @NotNull boolean[] isExplicit, int charsEaten) {
        Intrinsics.checkNotNullParameter((Object)indents, (String)"indents");
        Intrinsics.checkNotNullParameter((Object)types, (String)"types");
        Intrinsics.checkNotNullParameter((Object)isExplicit, (String)"isExplicit");
        this.indents = indents;
        this.types = types;
        this.isExplicit = isExplicit;
        this.charsEaten = charsEaten;
    }

    @Override
    @NotNull
    public char[] getTypes() {
        return this.types;
    }

    @Override
    @NotNull
    public boolean[] isExplicit() {
        return this.isExplicit;
    }

    @Override
    public int getCharsEaten() {
        return this.charsEaten;
    }

    @NotNull
    protected CommonMarkdownConstraints getBase() {
        return BASE;
    }

    @NotNull
    protected CommonMarkdownConstraints createNewConstraints(@NotNull int[] indents, @NotNull char[] types, @NotNull boolean[] isExplicit, int charsEaten) {
        Intrinsics.checkNotNullParameter((Object)indents, (String)"indents");
        Intrinsics.checkNotNullParameter((Object)types, (String)"types");
        Intrinsics.checkNotNullParameter((Object)isExplicit, (String)"isExplicit");
        return new CommonMarkdownConstraints(indents, types, isExplicit, charsEaten);
    }

    @Override
    public int getIndent() {
        Integer n = ArraysKt.lastOrNull((int[])this.indents);
        return n != null ? n : 0;
    }

    @Override
    public boolean startsWith(@NotNull MarkdownConstraints other) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            if (!(other instanceof CommonMarkdownConstraints)) {
                return false;
            }
            int n = this.indents.length;
            int m = ((CommonMarkdownConstraints)other).indents.length;
            if (n < m) {
                return false;
            }
            Iterable $this$none$iv = (Iterable)RangesKt.until((int)0, (int)m);
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $this$none$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    if (!(this.getTypes()[it] != other.getTypes()[it])) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean containsListMarkers(int upToIndex) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = (Iterable)RangesKt.until((int)0, (int)upToIndex);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    if (!(this.getTypes()[it] != '>' && this.isExplicit()[it])) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @Nullable
    public CommonMarkdownConstraints addModifierIfNeeded(@Nullable LookaheadText.Position pos) {
        if (pos == null || pos.getOffsetInCurrentLine() == -1) {
            return null;
        }
        if (HorizontalRuleProvider.Companion.isHorizontalRule(pos.getCurrentLine(), pos.getOffsetInCurrentLine())) {
            return null;
        }
        CommonMarkdownConstraints commonMarkdownConstraints = this.tryAddListItem(pos);
        if (commonMarkdownConstraints == null) {
            commonMarkdownConstraints = this.tryAddBlockQuote(pos);
        }
        return commonMarkdownConstraints;
    }

    @Override
    @NotNull
    public CommonMarkdownConstraints applyToNextLine(@Nullable LookaheadText.Position pos) {
        if (pos == null) {
            return this.getBase();
        }
        Compat compat = Compat.INSTANCE;
        boolean condition$iv = pos.getOffsetInCurrentLine() == -1;
        boolean $i$f$assert = false;
        if (!condition$iv) {
            boolean bl = false;
            String string = "given " + pos;
            throw new MarkdownParsingException(string);
        }
        String line = pos.getCurrentLine();
        int prevN = this.indents.length;
        Ref.IntRef indexPrev = new Ref.IntRef();
        Function1 getBlockQuoteIndent2 = (Function1)new Function1<Integer, Integer>(line){
            final /* synthetic */ String $line;
            {
                this.$line = $line;
                super(1);
            }

            public final Integer invoke(int startOffset) {
                int blockQuoteIndent;
                int offset = startOffset;
                for (blockQuoteIndent = 0; blockQuoteIndent < 3 && offset < this.$line.length() && this.$line.charAt(offset) == ' '; ++blockQuoteIndent, ++offset) {
                }
                return offset < this.$line.length() && this.$line.charAt(offset) == '>' ? Integer.valueOf(blockQuoteIndent + 1) : null;
            }
        };
        Function1 fillMaybeBlockquoteAndListIndents2 = (Function1)new Function1<CommonMarkdownConstraints, CommonMarkdownConstraints>(indexPrev, prevN, line, this, (Function1<? super Integer, Integer>)getBlockQuoteIndent2){
            final /* synthetic */ Ref.IntRef $indexPrev;
            final /* synthetic */ int $prevN;
            final /* synthetic */ String $line;
            final /* synthetic */ CommonMarkdownConstraints this$0;
            final /* synthetic */ Function1<Integer, Integer> $getBlockQuoteIndent;
            {
                this.$indexPrev = $indexPrev;
                this.$prevN = $prevN;
                this.$line = $line;
                this.this$0 = $receiver;
                this.$getBlockQuoteIndent = $getBlockQuoteIndent;
                super(1);
            }

            public final CommonMarkdownConstraints invoke(CommonMarkdownConstraints constraints) {
                int deltaIndent;
                Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
                if (this.$indexPrev.element >= this.$prevN) {
                    return constraints;
                }
                Ref.IntRef offset = new Ref.IntRef();
                offset.element = MarkdownConstraintsKt.getCharsEaten(constraints, this.$line);
                Ref.IntRef totalSpaces = new Ref.IntRef();
                Ref.IntRef spacesSeen = new Ref.IntRef();
                Function1 hasKMoreSpaces2 = (Function1)new Function1<Integer, Boolean>(spacesSeen, offset, this.$line, totalSpaces){
                    final /* synthetic */ Ref.IntRef $spacesSeen;
                    final /* synthetic */ Ref.IntRef $offset;
                    final /* synthetic */ String $line;
                    final /* synthetic */ Ref.IntRef $totalSpaces;
                    {
                        this.$spacesSeen = $spacesSeen;
                        this.$offset = $offset;
                        this.$line = $line;
                        this.$totalSpaces = $totalSpaces;
                        super(1);
                    }

                    public final Boolean invoke(int k) {
                        boolean bl;
                        int oldSpacesSeen = this.$spacesSeen.element;
                        int oldOffset = this.$offset.element;
                        while (this.$spacesSeen.element < k && this.$offset.element < this.$line.length()) {
                            int n;
                            int n2 = this.$line.charAt(this.$offset.element);
                            if (n2 == 32) {
                                n = 1;
                            } else {
                                if (n2 != 9) break;
                                n = 4 - this.$totalSpaces.element % 4;
                            }
                            int deltaSpaces = n;
                            this.$spacesSeen.element += deltaSpaces;
                            this.$totalSpaces.element += deltaSpaces;
                            n2 = this.$offset.element;
                            this.$offset.element = n2 + 1;
                        }
                        if (this.$offset.element == this.$line.length()) {
                            this.$spacesSeen.element = Integer.MAX_VALUE;
                        }
                        if (k <= this.$spacesSeen.element) {
                            this.$spacesSeen.element -= k;
                            bl = true;
                        } else {
                            this.$offset.element = oldOffset;
                            this.$spacesSeen.element = oldSpacesSeen;
                            bl = false;
                        }
                        return bl;
                    }
                };
                Integer bqIndent = null;
                if (this.this$0.getTypes()[this.$indexPrev.element] == '>') {
                    Integer n = (Integer)this.$getBlockQuoteIndent.invoke((Object)offset.element);
                    if (n == null) {
                        return constraints;
                    }
                    bqIndent = n;
                    offset.element += bqIndent.intValue();
                    int n2 = this.$indexPrev.element;
                    this.$indexPrev.element = n2 + 1;
                } else {
                    bqIndent = null;
                }
                int oldIndexPrev = this.$indexPrev.element;
                while (this.$indexPrev.element < this.$prevN && this.this$0.getTypes()[this.$indexPrev.element] != '>' && ((Boolean)hasKMoreSpaces2.invoke((Object)(deltaIndent = CommonMarkdownConstraints.access$getIndents$p(this.this$0)[this.$indexPrev.element] - (this.$indexPrev.element == 0 ? 0 : CommonMarkdownConstraints.access$getIndents$p(this.this$0)[this.$indexPrev.element - 1])))).booleanValue()) {
                    int n = this.$indexPrev.element;
                    this.$indexPrev.element = n + 1;
                }
                CommonMarkdownConstraints result2 = constraints;
                if (bqIndent != null) {
                    int bonusForTheBlockquote = (Boolean)hasKMoreSpaces2.invoke((Object)1) != false ? 1 : 0;
                    result2 = org.intellij.markdown.parser.constraints.CommonMarkdownConstraints$Companion.access$create(CommonMarkdownConstraints.Companion, result2, bqIndent + bonusForTheBlockquote, '>', true, offset.element);
                }
                int n = this.$indexPrev.element;
                for (int index = oldIndexPrev; index < n; ++index) {
                    int deltaIndent2 = CommonMarkdownConstraints.access$getIndents$p(this.this$0)[index] - (index == 0 ? 0 : CommonMarkdownConstraints.access$getIndents$p(this.this$0)[index - 1]);
                    result2 = org.intellij.markdown.parser.constraints.CommonMarkdownConstraints$Companion.access$create(CommonMarkdownConstraints.Companion, result2, deltaIndent2, this.this$0.getTypes()[index], false, offset.element);
                }
                return result2;
            }
        };
        CommonMarkdownConstraints result2 = this.getBase();
        CommonMarkdownConstraints nextConstraints;
        while (!Intrinsics.areEqual((Object)(nextConstraints = (CommonMarkdownConstraints)fillMaybeBlockquoteAndListIndents2.invoke((Object)result2)), (Object)result2)) {
            result2 = nextConstraints;
        }
        return result2;
    }

    @Nullable
    protected ListMarkerInfo fetchListMarker(@NotNull LookaheadText.Position pos) {
        int offset;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        char c = pos.getChar();
        if (c == '*' || c == '-' || c == '+') {
            return new ListMarkerInfo(1, c, 1);
        }
        String line = pos.getCurrentLine();
        for (offset = pos.getOffsetInCurrentLine(); offset < line.length(); ++offset) {
            char c2 = line.charAt(offset);
            boolean bl = '0' <= c2 ? c2 < ':' : false;
            if (!bl) break;
        }
        return offset > pos.getOffsetInCurrentLine() && offset - pos.getOffsetInCurrentLine() <= 9 && offset < line.length() && (line.charAt(offset) == '.' || line.charAt(offset) == ')') ? new ListMarkerInfo(offset + 1 - pos.getOffsetInCurrentLine(), line.charAt(offset), offset + 1 - pos.getOffsetInCurrentLine()) : null;
    }

    private final CommonMarkdownConstraints tryAddListItem(LookaheadText.Position pos) {
        int spacesBefore;
        String line = pos.getCurrentLine();
        int offset = pos.getOffsetInCurrentLine();
        int n = spacesBefore = offset > 0 && line.charAt(offset - 1) == '\t' ? (4 - this.getIndent() % 4) % 4 : 0;
        while (offset < line.length() && line.charAt(offset) == ' ' && spacesBefore < 3) {
            ++spacesBefore;
            ++offset;
        }
        if (offset == line.length()) {
            return null;
        }
        LookaheadText.Position position = pos.nextPosition(offset - pos.getOffsetInCurrentLine());
        Intrinsics.checkNotNull((Object)position);
        ListMarkerInfo listMarkerInfo = this.fetchListMarker(position);
        if (listMarkerInfo == null) {
            return null;
        }
        ListMarkerInfo markerInfo = listMarkerInfo;
        int spacesAfter = 0;
        int markerEndOffset = offset += markerInfo.getMarkerLength();
        while (offset < line.length()) {
            char c = line.charAt(offset);
            if (c == ' ') {
                ++spacesAfter;
            } else {
                if (c != '\t') break;
                spacesAfter += 4 - spacesAfter % 4;
            }
            ++offset;
        }
        boolean bl = 1 <= spacesAfter ? spacesAfter < 5 : false;
        if (bl && offset < line.length()) {
            return CommonMarkdownConstraints.Companion.create(this, spacesBefore + markerInfo.getMarkerIndent() + spacesAfter, markerInfo.getMarkerType(), true, offset);
        }
        if (spacesAfter >= 5 && offset < line.length() || offset == line.length()) {
            return CommonMarkdownConstraints.Companion.create(this, spacesBefore + markerInfo.getMarkerIndent() + 1, markerInfo.getMarkerType(), true, Math.min(offset, markerEndOffset + 1));
        }
        return null;
    }

    private final CommonMarkdownConstraints tryAddBlockQuote(LookaheadText.Position pos) {
        int spacesBefore;
        String line = pos.getCurrentLine();
        int offset = pos.getOffsetInCurrentLine();
        for (spacesBefore = 0; offset < line.length() && line.charAt(offset) == ' ' && spacesBefore < 3; ++spacesBefore, ++offset) {
        }
        if (offset == line.length() || line.charAt(offset) != '>') {
            return null;
        }
        int spacesAfter = 0;
        if (++offset >= line.length() || line.charAt(offset) == ' ' || line.charAt(offset) == '\t') {
            spacesAfter = 1;
            if (offset < line.length()) {
                ++offset;
            }
        }
        return CommonMarkdownConstraints.Companion.create(this, spacesBefore + 1 + spacesAfter, '>', true, offset);
    }

    @NotNull
    public String toString() {
        return "MdConstraints: " + StringsKt.concatToString((char[])this.getTypes()) + '(' + this.getIndent() + ')';
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CommonMarkdownConstraints getBASE() {
            return BASE;
        }

        private final CommonMarkdownConstraints create(CommonMarkdownConstraints parent, int newIndentDelta, char newType, boolean newExplicit, int newOffset) {
            int n = parent.indents.length;
            int[] nArray = Arrays.copyOf(parent.indents, n + 1);
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
            int[] indents = nArray;
            char[] cArray = Arrays.copyOf(parent.getTypes(), n + 1);
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"copyOf(...)");
            char[] types = cArray;
            boolean[] blArray = Arrays.copyOf(parent.isExplicit(), n + 1);
            Intrinsics.checkNotNullExpressionValue((Object)blArray, (String)"copyOf(...)");
            boolean[] isExplicit = blArray;
            indents[n] = parent.getIndent() + newIndentDelta;
            types[n] = newType;
            isExplicit[n] = newExplicit;
            return parent.createNewConstraints(indents, types, isExplicit, newOffset);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    protected static final class ListMarkerInfo {
        private final int markerLength;
        private final char markerType;
        private final int markerIndent;

        public ListMarkerInfo(int markerLength, char markerType, int markerIndent) {
            this.markerLength = markerLength;
            this.markerType = markerType;
            this.markerIndent = markerIndent;
        }

        public final int getMarkerLength() {
            return this.markerLength;
        }

        public final char getMarkerType() {
            return this.markerType;
        }

        public final int getMarkerIndent() {
            return this.markerIndent;
        }

        @NotNull
        public String toString() {
            return "ListMarkerInfo(markerLength=" + this.markerLength + ", markerType=" + this.markerType + ", markerIndent=" + this.markerIndent + ')';
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.markerLength);
            result2 = result2 * 31 + Character.hashCode(this.markerType);
            result2 = result2 * 31 + Integer.hashCode(this.markerIndent);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ListMarkerInfo)) {
                return false;
            }
            ListMarkerInfo listMarkerInfo = (ListMarkerInfo)other;
            if (this.markerLength != listMarkerInfo.markerLength) {
                return false;
            }
            if (this.markerType != listMarkerInfo.markerType) {
                return false;
            }
            return this.markerIndent == listMarkerInfo.markerIndent;
        }
    }
}

