/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementType;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTNodeBuilder;
import org.intellij.markdown.parser.TreeBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TopLevelBuilder
extends TreeBuilder {
    public TopLevelBuilder(@NotNull ASTNodeBuilder nodeBuilder) {
        Intrinsics.checkNotNullParameter((Object)nodeBuilder, (String)"nodeBuilder");
        super(nodeBuilder);
    }

    @Override
    protected void flushEverythingBeforeEvent(@NotNull TreeBuilder.MyEvent event, @Nullable List<TreeBuilder.MyASTNodeWrapper> currentNodeChildren) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    @Override
    @NotNull
    protected TreeBuilder.MyASTNodeWrapper createASTNodeOnClosingEvent(@NotNull TreeBuilder.MyEvent event, @NotNull List<TreeBuilder.MyASTNodeWrapper> currentNodeChildren, boolean isTopmostNode) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(currentNodeChildren, (String)"currentNodeChildren");
        ASTNode newNode = null;
        IElementType type2 = event.getInfo().getType();
        int startOffset = event.getInfo().getRange().getFirst();
        int endOffset = event.getInfo().getRange().getLast();
        if (type2 instanceof MarkdownElementType && ((MarkdownElementType)type2).isToken()) {
            List<ASTNode> nodes = this.getNodeBuilder().createLeafNodes(type2, startOffset, endOffset);
            return new TreeBuilder.MyASTNodeWrapper((ASTNode)CollectionsKt.first(nodes), startOffset, endOffset);
        }
        ArrayList<ASTNode> childrenWithWhitespaces = new ArrayList<ASTNode>(currentNodeChildren.size());
        TreeBuilder.MyASTNodeWrapper myASTNodeWrapper = (TreeBuilder.MyASTNodeWrapper)CollectionsKt.firstOrNull(currentNodeChildren);
        this.addRawTokens((List<ASTNode>)childrenWithWhitespaces, startOffset, myASTNodeWrapper != null ? myASTNodeWrapper.getStartTokenIndex() : endOffset);
        int n = currentNodeChildren.size();
        for (int i2 = 1; i2 < n; ++i2) {
            TreeBuilder.MyASTNodeWrapper prev = currentNodeChildren.get(i2 - 1);
            TreeBuilder.MyASTNodeWrapper next2 = currentNodeChildren.get(i2);
            childrenWithWhitespaces.add(prev.getAstNode());
            this.addRawTokens((List<ASTNode>)childrenWithWhitespaces, prev.getEndTokenIndex(), next2.getStartTokenIndex());
        }
        if (!currentNodeChildren.isEmpty()) {
            childrenWithWhitespaces.add(((TreeBuilder.MyASTNodeWrapper)CollectionsKt.last(currentNodeChildren)).getAstNode());
            this.addRawTokens((List<ASTNode>)childrenWithWhitespaces, ((TreeBuilder.MyASTNodeWrapper)CollectionsKt.last(currentNodeChildren)).getEndTokenIndex(), endOffset);
        }
        newNode = this.getNodeBuilder().createCompositeNode(type2, (List<? extends ASTNode>)childrenWithWhitespaces);
        return new TreeBuilder.MyASTNodeWrapper(newNode, startOffset, endOffset);
    }

    private final void addRawTokens(List<ASTNode> childrenWithWhitespaces, int from, int to) {
        if (from != to) {
            childrenWithWhitespaces.addAll((Collection<ASTNode>)this.getNodeBuilder().createLeafNodes(MarkdownTokenTypes.WHITE_SPACE, from, to));
        }
    }
}

