/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser;

import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.markdown.MarkdownParsingException;
import org.intellij.markdown.lexer.Compat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LookaheadText {
    @NotNull
    private final CharSequence text;
    @NotNull
    private final List<String> lines;
    @Nullable
    private final Position startPosition;

    public LookaheadText(@NotNull CharSequence text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.text = text2;
        char[] cArray = new char[]{'\n'};
        this.lines = StringsKt.split$default((CharSequence)this.text, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        this.startPosition = this.text.length() > 0 ? Position.nextPosition$default(new Position(0, -1, -1), 0, 1, null) : null;
    }

    @Nullable
    public final Position getStartPosition() {
        return this.startPosition;
    }

    @SourceDebugExtension(value={"SMAP\nLookaheadText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LookaheadText.kt\norg/intellij/markdown/parser/LookaheadText$Position\n+ 2 Compat.kt\norg/intellij/markdown/lexer/Compat\n+ 3 Compat.kt\norg/intellij/markdown/lexer/Compat$assert$1\n*L\n1#1,135:1\n106#2,3:136\n110#2:140\n106#3:139\n*S KotlinDebug\n*F\n+ 1 LookaheadText.kt\norg/intellij/markdown/parser/LookaheadText$Position\n*L\n24#1:136,3\n24#1:140\n24#1:139\n*E\n"})
    public final class Position {
        private final int lineN;
        private final int localPos;
        private final int globalPos;
        @NotNull
        private final String currentLine;

        public Position(int lineN, int localPos, int globalPos) {
            this.lineN = lineN;
            this.localPos = localPos;
            this.globalPos = globalPos;
            this.currentLine = (String)LookaheadText.this.lines.get(this.lineN);
            Compat compat = Compat.INSTANCE;
            boolean condition$iv = this.localPos >= -1 && this.localPos < this.currentLine.length();
            boolean $i$f$assert = false;
            if (!condition$iv) {
                boolean bl = false;
                String string = "";
                throw new MarkdownParsingException(string);
            }
        }

        @NotNull
        public final CharSequence getOriginalText() {
            return LookaheadText.this.text;
        }

        @NotNull
        public final String getCurrentLine() {
            return this.currentLine;
        }

        @NotNull
        public String toString() {
            String string;
            StringBuilder stringBuilder = new StringBuilder().append("Position: '");
            if (this.localPos == -1) {
                string = "\\n" + this.currentLine;
            } else {
                String string2 = this.currentLine.substring(this.localPos);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            }
            return stringBuilder.append(string).append('\'').toString();
        }

        public final int getOffset() {
            return this.globalPos;
        }

        public final int getOffsetInCurrentLine() {
            return this.localPos;
        }

        @Nullable
        public final Integer getNextLineOffset() {
            return this.lineN + 1 < LookaheadText.this.lines.size() ? Integer.valueOf(this.globalPos + (this.currentLine.length() - this.localPos)) : null;
        }

        public final int getNextLineOrEofOffset() {
            return this.globalPos + (this.currentLine.length() - this.localPos);
        }

        @NotNull
        public final CharSequence getCurrentLineFromPosition() {
            String string = this.currentLine.substring(this.getOffsetInCurrentLine());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }

        @Nullable
        public final String getNextLine() {
            return this.lineN + 1 < LookaheadText.this.lines.size() ? (String)LookaheadText.this.lines.get(this.lineN + 1) : null;
        }

        @Nullable
        public final String getPrevLine() {
            return this.lineN > 0 ? (String)LookaheadText.this.lines.get(this.lineN - 1) : null;
        }

        public final char getChar() {
            return LookaheadText.this.text.charAt(this.globalPos);
        }

        @Nullable
        public final Position nextPosition(int delta) {
            int remaining = delta;
            Position currentPosition = this;
            while (remaining != 0) {
                if (currentPosition.localPos + remaining < currentPosition.currentLine.length()) {
                    return new Position(currentPosition.lineN, currentPosition.localPos + remaining, currentPosition.globalPos + remaining);
                }
                Integer nextLine = currentPosition.getNextLineOffset();
                if (nextLine == null) {
                    return null;
                }
                int payload = currentPosition.currentLine.length() - currentPosition.localPos;
                currentPosition = new Position(currentPosition.lineN + 1, -1, currentPosition.globalPos + payload);
                remaining -= payload;
            }
            return currentPosition;
        }

        public static /* synthetic */ Position nextPosition$default(Position position, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 1;
            }
            return position.nextPosition(n);
        }

        @Nullable
        public final Position nextLinePosition() {
            Integer n = this.getNextLineOffset();
            if (n == null) {
                return null;
            }
            int nextLine = n;
            return this.nextPosition(nextLine - this.getOffset());
        }

        @Nullable
        public final Integer charsToNonWhitespace() {
            String line = this.currentLine;
            for (int offset = Math.max(this.localPos, 0); offset < line.length(); ++offset) {
                char c = line.charAt(offset);
                if (c == ' ' || c == '\t') continue;
                return offset - this.localPos;
            }
            return null;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            Position cfr_ignored_0 = (Position)other;
            return this.globalPos == ((Position)other).globalPos;
        }

        public int hashCode() {
            return this.globalPos;
        }
    }
}

