/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.lexer;

import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class Compat {
    @NotNull
    public static final Compat INSTANCE = new Compat();

    private Compat() {
    }

    public final int offsetByCodePoints(@NotNull CharSequence seq, int index, int codePointOffset) {
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        int length = seq.length();
        if (index < 0 || index > length) {
            throw new IndexOutOfBoundsException();
        }
        int x = index;
        if (codePointOffset >= 0) {
            int i2 = 0;
            for (i2 = 0; x < length && i2 < codePointOffset; ++i2) {
                if (!Character.isHighSurrogate(seq.charAt(x++)) || x >= length || !Character.isLowSurrogate(seq.charAt(x))) continue;
                ++x;
            }
            if (i2 < codePointOffset) {
                throw new IndexOutOfBoundsException();
            }
        } else {
            int i3 = 0;
            for (i3 = codePointOffset; x > 0 && i3 < 0; ++i3) {
                if (!Character.isLowSurrogate(seq.charAt(--x)) || x <= 0 || !Character.isHighSurrogate(seq.charAt(x - 1))) continue;
                --x;
            }
            if (i3 < 0) {
                throw new IndexOutOfBoundsException();
            }
        }
        return x;
    }

    public final int charCount(int n) {
        return n >= 65536 ? 2 : 1;
    }

    public final int toCodePoint(char high, char low) {
        return (high << 10) + low + -56613888;
    }

    public final int codePointAt(@NotNull CharSequence seq, int index) {
        char c2;
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        int index2 = index;
        char c1 = seq.charAt(index2);
        if (Character.isHighSurrogate(c1) && ++index2 < seq.length() && Character.isLowSurrogate(c2 = seq.charAt(index2))) {
            return this.toCodePoint(c1, c2);
        }
        return c1;
    }
}

