/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.flavours.commonmark;

import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.commonmark.CommonMarkMarkerProcessor;
import org.intellij.markdown.lexer.MarkdownLexer;
import org.intellij.markdown.lexer._MarkdownLexer;
import org.intellij.markdown.parser.MarkerProcessorFactory;
import org.intellij.markdown.parser.sequentialparsers.DelimiterParser;
import org.intellij.markdown.parser.sequentialparsers.EmphasisLikeParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParserManager;
import org.intellij.markdown.parser.sequentialparsers.impl.AutolinkParser;
import org.intellij.markdown.parser.sequentialparsers.impl.BacktickParser;
import org.intellij.markdown.parser.sequentialparsers.impl.EmphStrongDelimiterParser;
import org.intellij.markdown.parser.sequentialparsers.impl.ImageParser;
import org.intellij.markdown.parser.sequentialparsers.impl.InlineLinkParser;
import org.intellij.markdown.parser.sequentialparsers.impl.ReferenceLinkParser;
import org.jetbrains.annotations.NotNull;

public class CommonMarkFlavourDescriptor
implements MarkdownFlavourDescriptor {
    private final boolean useSafeLinks;
    private final boolean absolutizeAnchorLinks;
    @NotNull
    private final MarkerProcessorFactory markerProcessorFactory;
    @NotNull
    private final SequentialParserManager sequentialParserManager;

    public CommonMarkFlavourDescriptor(boolean useSafeLinks, boolean absolutizeAnchorLinks) {
        this.useSafeLinks = useSafeLinks;
        this.absolutizeAnchorLinks = absolutizeAnchorLinks;
        this.markerProcessorFactory = CommonMarkMarkerProcessor.Factory.INSTANCE;
        this.sequentialParserManager = new SequentialParserManager(){

            public List<SequentialParser> getParserSequence() {
                Object[] objectArray = new SequentialParser[6];
                objectArray[0] = new AutolinkParser(CollectionsKt.listOf((Object)MarkdownTokenTypes.AUTOLINK));
                objectArray[1] = new BacktickParser();
                objectArray[2] = new ImageParser();
                objectArray[3] = new InlineLinkParser();
                objectArray[4] = new ReferenceLinkParser();
                DelimiterParser[] delimiterParserArray = new DelimiterParser[]{new EmphStrongDelimiterParser()};
                objectArray[5] = new EmphasisLikeParser(delimiterParserArray);
                return CollectionsKt.listOf((Object[])objectArray);
            }
        };
    }

    public /* synthetic */ CommonMarkFlavourDescriptor(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        this(bl, bl2);
    }

    @Override
    @NotNull
    public MarkerProcessorFactory getMarkerProcessorFactory() {
        return this.markerProcessorFactory;
    }

    @Override
    @NotNull
    public MarkdownLexer createInlinesLexer() {
        return new MarkdownLexer(new _MarkdownLexer());
    }

    @Override
    @NotNull
    public SequentialParserManager getSequentialParserManager() {
        return this.sequentialParserManager;
    }

    public CommonMarkFlavourDescriptor() {
        this(false, false, 3, null);
    }
}

