/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util.io.pem;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.io.pem.PemHeader;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;

public class PemWriter
extends BufferedWriter {
    private final int nlLength;
    private char[] buf = new char[64];

    public PemWriter(Writer writer2) {
        super(writer2);
        String string = Strings.lineSeparator();
        this.nlLength = string != null ? string.length() : 2;
    }

    public void writeObject(PemObjectGenerator pemObjectGenerator) throws IOException {
        PemObject pemObject = pemObjectGenerator.generate();
        this.writePreEncapsulationBoundary(pemObject.getType());
        if (!pemObject.getHeaders().isEmpty()) {
            for (PemHeader pemHeader : pemObject.getHeaders()) {
                this.write(pemHeader.getName());
                this.write(": ");
                this.write(pemHeader.getValue());
                this.newLine();
            }
            this.newLine();
        }
        this.writeEncoded(pemObject.getContent());
        this.writePostEncapsulationBoundary(pemObject.getType());
    }

    private void writeEncoded(byte[] byArray) throws IOException {
        byArray = Base64.encode(byArray);
        for (int j = 0; j < byArray.length; j += this.buf.length) {
            int n;
            for (n = 0; n != this.buf.length && j + n < byArray.length; ++n) {
                this.buf[n] = (char)byArray[j + n];
            }
            this.write(this.buf, 0, n);
            this.newLine();
        }
    }

    private void writePreEncapsulationBoundary(String string) throws IOException {
        this.write("-----BEGIN " + string + "-----");
        this.newLine();
    }

    private void writePostEncapsulationBoundary(String string) throws IOException {
        this.write("-----END " + string + "-----");
        this.newLine();
    }
}

