/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.raw;

import java.math.BigInteger;
import org.bouncycastle.util.Pack;

public abstract class Nat {
    public static int[] create(int n) {
        return new int[n];
    }

    public static int[] fromBigInteger(int n, BigInteger bigInteger) {
        if (bigInteger.signum() < 0 || bigInteger.bitLength() > n) {
            throw new IllegalArgumentException();
        }
        int n2 = n + 31 >> 5;
        int[] nArray = Nat.create(n2);
        for (int j = 0; j < n2; ++j) {
            nArray[j] = bigInteger.intValue();
            bigInteger = bigInteger.shiftRight(32);
        }
        return nArray;
    }

    public static BigInteger toBigInteger(int n, int[] nArray) {
        byte[] byArray = new byte[n << 2];
        for (int j = 0; j < n; ++j) {
            int n2 = nArray[j];
            if (n2 == 0) continue;
            Pack.intToBigEndian(n2, byArray, n - 1 - j << 2);
        }
        return new BigInteger(1, byArray);
    }
}

