/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.security.SecureRandom;
import java.util.Hashtable;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;

public abstract class ECPoint {
    protected static final ECFieldElement[] EMPTY_ZS = new ECFieldElement[0];
    protected ECCurve curve;
    protected ECFieldElement x;
    protected ECFieldElement y;
    protected ECFieldElement[] zs;
    protected Hashtable preCompTable = null;

    protected static ECFieldElement[] getInitialZCoords(ECCurve eCCurve) {
        int n = null == eCCurve ? 0 : eCCurve.getCoordinateSystem();
        switch (n) {
            case 0: 
            case 5: {
                return EMPTY_ZS;
            }
        }
        ECFieldElement eCFieldElement = eCCurve.fromBigInteger(ECConstants.ONE);
        switch (n) {
            case 1: 
            case 2: 
            case 6: {
                return new ECFieldElement[]{eCFieldElement};
            }
            case 3: {
                return new ECFieldElement[]{eCFieldElement, eCFieldElement, eCFieldElement};
            }
            case 4: {
                return new ECFieldElement[]{eCFieldElement, eCCurve.getA()};
            }
        }
        throw new IllegalArgumentException("unknown coordinate system");
    }

    protected ECPoint(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        this(eCCurve, eCFieldElement, eCFieldElement2, ECPoint.getInitialZCoords(eCCurve));
    }

    protected ECPoint(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        this.curve = eCCurve;
        this.x = eCFieldElement;
        this.y = eCFieldElement2;
        this.zs = eCFieldElementArray;
    }

    public ECCurve getCurve() {
        return this.curve;
    }

    protected int getCurveCoordinateSystem() {
        return null == this.curve ? 0 : this.curve.getCoordinateSystem();
    }

    public ECFieldElement getXCoord() {
        return this.x;
    }

    public ECFieldElement getYCoord() {
        return this.y;
    }

    public ECFieldElement getZCoord(int n) {
        return n < 0 || n >= this.zs.length ? null : this.zs[n];
    }

    public final ECFieldElement getRawXCoord() {
        return this.x;
    }

    public final ECFieldElement getRawYCoord() {
        return this.y;
    }

    public boolean isNormalized() {
        int n = this.getCurveCoordinateSystem();
        return n == 0 || n == 5 || this.isInfinity() || this.zs[0].isOne();
    }

    public ECPoint normalize() {
        if (this.isInfinity()) {
            return this;
        }
        switch (this.getCurveCoordinateSystem()) {
            case 0: 
            case 5: {
                return this;
            }
        }
        ECFieldElement eCFieldElement = this.getZCoord(0);
        if (eCFieldElement.isOne()) {
            return this;
        }
        if (null == this.curve) {
            throw new IllegalStateException("Detached points must be in affine coordinates");
        }
        SecureRandom secureRandom = CryptoServicesRegistrar.getSecureRandom();
        ECFieldElement eCFieldElement2 = this.curve.randomFieldElementMult(secureRandom);
        ECFieldElement eCFieldElement3 = eCFieldElement.multiply(eCFieldElement2).invert().multiply(eCFieldElement2);
        return this.normalize(eCFieldElement3);
    }

    ECPoint normalize(ECFieldElement eCFieldElement) {
        switch (this.getCurveCoordinateSystem()) {
            case 1: 
            case 6: {
                return this.createScaledPoint(eCFieldElement, eCFieldElement);
            }
            case 2: 
            case 3: 
            case 4: {
                ECFieldElement eCFieldElement2 = eCFieldElement.square();
                ECFieldElement eCFieldElement3 = eCFieldElement2.multiply(eCFieldElement);
                return this.createScaledPoint(eCFieldElement2, eCFieldElement3);
            }
        }
        throw new IllegalStateException("not a projective coordinate system");
    }

    protected ECPoint createScaledPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return this.getCurve().createRawPoint(this.getRawXCoord().multiply(eCFieldElement), this.getRawYCoord().multiply(eCFieldElement2));
    }

    public boolean isInfinity() {
        return this.x == null || this.y == null || this.zs.length > 0 && this.zs[0].isZero();
    }

    public boolean equals(ECPoint eCPoint) {
        if (null == eCPoint) {
            return false;
        }
        ECCurve eCCurve = this.getCurve();
        ECCurve eCCurve2 = eCPoint.getCurve();
        boolean bl = null == eCCurve;
        boolean bl2 = null == eCCurve2;
        boolean bl3 = this.isInfinity();
        boolean bl4 = eCPoint.isInfinity();
        if (bl3 || bl4) {
            return bl3 && bl4 && (bl || bl2 || eCCurve.equals(eCCurve2));
        }
        ECPoint eCPoint2 = this;
        ECPoint eCPoint3 = eCPoint;
        if (!bl || !bl2) {
            if (bl) {
                eCPoint3 = eCPoint3.normalize();
            } else if (bl2) {
                eCPoint2 = eCPoint2.normalize();
            } else {
                if (!eCCurve.equals(eCCurve2)) {
                    return false;
                }
                ECPoint[] eCPointArray = new ECPoint[]{this, eCCurve.importPoint(eCPoint3)};
                eCCurve.normalizeAll(eCPointArray);
                eCPoint2 = eCPointArray[0];
                eCPoint3 = eCPointArray[1];
            }
        }
        return eCPoint2.getXCoord().equals(eCPoint3.getXCoord()) && eCPoint2.getYCoord().equals(eCPoint3.getYCoord());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ECPoint)) {
            return false;
        }
        return this.equals((ECPoint)object);
    }

    public int hashCode() {
        int n;
        ECCurve eCCurve = this.getCurve();
        int n2 = n = null == eCCurve ? 0 : ~eCCurve.hashCode();
        if (!this.isInfinity()) {
            ECPoint eCPoint = this.normalize();
            n ^= eCPoint.getXCoord().hashCode() * 17;
            n ^= eCPoint.getYCoord().hashCode() * 257;
        }
        return n;
    }

    public String toString() {
        if (this.isInfinity()) {
            return "INF";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        stringBuffer.append(this.getRawXCoord());
        stringBuffer.append(',');
        stringBuffer.append(this.getRawYCoord());
        for (int j = 0; j < this.zs.length; ++j) {
            stringBuffer.append(',');
            stringBuffer.append(this.zs[j]);
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static abstract class AbstractF2m
    extends ECPoint {
        protected AbstractF2m(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
            super(eCCurve, eCFieldElement, eCFieldElement2);
        }
    }

    public static abstract class AbstractFp
    extends ECPoint {
        protected AbstractFp(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
            super(eCCurve, eCFieldElement, eCFieldElement2);
        }

        protected AbstractFp(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
            super(eCCurve, eCFieldElement, eCFieldElement2, eCFieldElementArray);
        }
    }

    public static class F2m
    extends AbstractF2m {
        F2m(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
            super(eCCurve, eCFieldElement, eCFieldElement2);
        }

        @Override
        public ECFieldElement getYCoord() {
            int n = this.getCurveCoordinateSystem();
            switch (n) {
                case 5: 
                case 6: {
                    ECFieldElement eCFieldElement;
                    ECFieldElement eCFieldElement2 = this.x;
                    ECFieldElement eCFieldElement3 = this.y;
                    if (this.isInfinity() || eCFieldElement2.isZero()) {
                        return eCFieldElement3;
                    }
                    ECFieldElement eCFieldElement4 = eCFieldElement3.add(eCFieldElement2).multiply(eCFieldElement2);
                    if (6 == n && !(eCFieldElement = this.zs[0]).isOne()) {
                        eCFieldElement4 = eCFieldElement4.divide(eCFieldElement);
                    }
                    return eCFieldElement4;
                }
            }
            return this.y;
        }
    }

    public static class Fp
    extends AbstractFp {
        Fp(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
            super(eCCurve, eCFieldElement, eCFieldElement2);
        }

        Fp(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
            super(eCCurve, eCFieldElement, eCFieldElement2, eCFieldElementArray);
        }

        @Override
        public ECFieldElement getZCoord(int n) {
            if (n == 1 && 4 == this.getCurveCoordinateSystem()) {
                return this.getJacobianModifiedW();
            }
            return super.getZCoord(n);
        }

        protected ECFieldElement calculateJacobianModifiedW(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
            ECFieldElement eCFieldElement3 = this.getCurve().getA();
            if (eCFieldElement3.isZero() || eCFieldElement.isOne()) {
                return eCFieldElement3;
            }
            if (eCFieldElement2 == null) {
                eCFieldElement2 = eCFieldElement.square();
            }
            ECFieldElement eCFieldElement4 = eCFieldElement2.square();
            ECFieldElement eCFieldElement5 = eCFieldElement3.negate();
            eCFieldElement4 = eCFieldElement5.bitLength() < eCFieldElement3.bitLength() ? eCFieldElement4.multiply(eCFieldElement5).negate() : eCFieldElement4.multiply(eCFieldElement3);
            return eCFieldElement4;
        }

        protected ECFieldElement getJacobianModifiedW() {
            ECFieldElement eCFieldElement = this.zs[1];
            if (eCFieldElement == null) {
                this.zs[1] = eCFieldElement = this.calculateJacobianModifiedW(this.zs[0], null);
            }
            return eCFieldElement;
        }
    }
}

