/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x500.style;

import java.io.IOException;
import java.util.Hashtable;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1UniversalString;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

public class IETFUtils {
    public static void appendRDN(StringBuffer stringBuffer, RDN rDN, Hashtable hashtable) {
        if (rDN.isMultiValued()) {
            AttributeTypeAndValue[] attributeTypeAndValueArray = rDN.getTypesAndValues();
            boolean bl = true;
            for (int j = 0; j != attributeTypeAndValueArray.length; ++j) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append('+');
                }
                IETFUtils.appendTypeAndValue(stringBuffer, attributeTypeAndValueArray[j], hashtable);
            }
        } else if (rDN.getFirst() != null) {
            IETFUtils.appendTypeAndValue(stringBuffer, rDN.getFirst(), hashtable);
        }
    }

    public static void appendTypeAndValue(StringBuffer stringBuffer, AttributeTypeAndValue attributeTypeAndValue2, Hashtable hashtable) {
        String string = (String)hashtable.get(attributeTypeAndValue2.getType());
        if (string != null) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append(attributeTypeAndValue2.getType().getId());
        }
        stringBuffer.append('=');
        stringBuffer.append(IETFUtils.valueToString(attributeTypeAndValue2.getValue()));
    }

    public static String valueToString(ASN1Encodable aSN1Encodable) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        if (aSN1Encodable instanceof ASN1String && !(aSN1Encodable instanceof ASN1UniversalString)) {
            String string = ((ASN1String)((Object)aSN1Encodable)).getString();
            if (string.length() > 0 && string.charAt(0) == '#') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(string);
        } else {
            try {
                stringBuffer.append('#');
                stringBuffer.append(Hex.toHexString(aSN1Encodable.toASN1Primitive().getEncoded("DER")));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Other value has no encoded form");
            }
        }
        int n2 = stringBuffer.length();
        int n3 = 0;
        if (stringBuffer.length() >= 2 && stringBuffer.charAt(0) == '\\' && stringBuffer.charAt(1) == '#') {
            n3 += 2;
        }
        block5: while (n3 != n2) {
            switch (stringBuffer.charAt(n3)) {
                case '\"': 
                case '+': 
                case ',': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '\\': {
                    stringBuffer.insert(n3, "\\");
                    n3 += 2;
                    ++n2;
                    continue block5;
                }
            }
            ++n3;
        }
        if (stringBuffer.length() > 0) {
            for (n = 0; stringBuffer.length() > n && stringBuffer.charAt(n) == ' '; n += 2) {
                stringBuffer.insert(n, "\\");
            }
        }
        for (int j = stringBuffer.length() - 1; j >= n && stringBuffer.charAt(j) == ' '; --j) {
            stringBuffer.insert(j, '\\');
        }
        return stringBuffer.toString();
    }

    public static String canonicalize(String string) {
        int n;
        int n2;
        int n3;
        ASN1Primitive aSN1Primitive;
        if (string.length() > 0 && string.charAt(0) == '#' && (aSN1Primitive = IETFUtils.decodeObject(string)) instanceof ASN1String) {
            string = ((ASN1String)((Object)aSN1Primitive)).getString();
        }
        if ((n3 = (string = Strings.toLowerCase(string)).length()) < 2) {
            return string;
        }
        int n4 = n3 - 1;
        for (n2 = 0; n2 < n4 && string.charAt(n2) == '\\' && string.charAt(n2 + 1) == ' '; n2 += 2) {
        }
        int n5 = n2 + 1;
        for (n = n4; n > n5 && string.charAt(n - 1) == '\\' && string.charAt(n) == ' '; n -= 2) {
        }
        if (n2 > 0 || n < n4) {
            string = string.substring(n2, n + 1);
        }
        return IETFUtils.stripInternalSpaces(string);
    }

    public static String canonicalString(ASN1Encodable aSN1Encodable) {
        return IETFUtils.canonicalize(IETFUtils.valueToString(aSN1Encodable));
    }

    private static ASN1Primitive decodeObject(String string) {
        try {
            return ASN1Primitive.fromByteArray(Hex.decodeStrict(string, 1, string.length() - 1));
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unknown encoding in name: " + iOException);
        }
    }

    public static String stripInternalSpaces(String string) {
        if (string.indexOf("  ") < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char c = string.charAt(0);
        stringBuffer.append(c);
        for (int j = 1; j < string.length(); ++j) {
            char c2 = string.charAt(j);
            if (c == ' ' && c2 == ' ') continue;
            stringBuffer.append(c2);
            c = c2;
        }
        return stringBuffer.toString();
    }

    public static boolean rDNAreEqual(RDN rDN, RDN rDN2) {
        AttributeTypeAndValue[] attributeTypeAndValueArray;
        if (rDN.size() != rDN2.size()) {
            return false;
        }
        AttributeTypeAndValue[] attributeTypeAndValueArray2 = rDN.getTypesAndValues();
        if (attributeTypeAndValueArray2.length != (attributeTypeAndValueArray = rDN2.getTypesAndValues()).length) {
            return false;
        }
        for (int j = 0; j != attributeTypeAndValueArray2.length; ++j) {
            if (IETFUtils.atvAreEqual(attributeTypeAndValueArray2[j], attributeTypeAndValueArray[j])) continue;
            return false;
        }
        return true;
    }

    private static boolean atvAreEqual(AttributeTypeAndValue attributeTypeAndValue2, AttributeTypeAndValue attributeTypeAndValue3) {
        String string;
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        if (attributeTypeAndValue2 == attributeTypeAndValue3) {
            return true;
        }
        if (null == attributeTypeAndValue2 || null == attributeTypeAndValue3) {
            return false;
        }
        ASN1ObjectIdentifier aSN1ObjectIdentifier2 = attributeTypeAndValue2.getType();
        if (!aSN1ObjectIdentifier2.equals(aSN1ObjectIdentifier = attributeTypeAndValue3.getType())) {
            return false;
        }
        String string2 = IETFUtils.canonicalString(attributeTypeAndValue2.getValue());
        return string2.equals(string = IETFUtils.canonicalString(attributeTypeAndValue3.getValue()));
    }
}

