/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x500.style;

import java.util.Enumeration;
import java.util.Hashtable;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;

public abstract class AbstractX500NameStyle
implements X500NameStyle {
    public static Hashtable copyHashTable(Hashtable hashtable) {
        Hashtable hashtable2 = new Hashtable();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            hashtable2.put(k, hashtable.get(k));
        }
        return hashtable2;
    }

    private int calcHashCode(ASN1Encodable aSN1Encodable) {
        String string = IETFUtils.canonicalString(aSN1Encodable);
        return string.hashCode();
    }

    @Override
    public int calculateHashCode(X500Name x500Name) {
        int n = 0;
        RDN[] rDNArray = x500Name.getRDNs();
        for (int j = 0; j != rDNArray.length; ++j) {
            if (rDNArray[j].isMultiValued()) {
                AttributeTypeAndValue[] attributeTypeAndValueArray = rDNArray[j].getTypesAndValues();
                for (int k = 0; k != attributeTypeAndValueArray.length; ++k) {
                    n ^= attributeTypeAndValueArray[k].getType().hashCode();
                    n ^= this.calcHashCode(attributeTypeAndValueArray[k].getValue());
                }
                continue;
            }
            n ^= rDNArray[j].getFirst().getType().hashCode();
            n ^= this.calcHashCode(rDNArray[j].getFirst().getValue());
        }
        return n;
    }

    @Override
    public boolean areEqual(X500Name x500Name, X500Name x500Name2) {
        if (x500Name.size() != x500Name2.size()) {
            return false;
        }
        RDN[] rDNArray = x500Name.getRDNs();
        RDN[] rDNArray2 = x500Name2.getRDNs();
        boolean bl = false;
        AttributeTypeAndValue attributeTypeAndValue2 = rDNArray[0].getFirst();
        AttributeTypeAndValue attributeTypeAndValue3 = rDNArray2[0].getFirst();
        if (attributeTypeAndValue2 != null && attributeTypeAndValue3 != null) {
            bl = !attributeTypeAndValue2.getType().equals(attributeTypeAndValue3.getType());
        }
        for (int j = 0; j != rDNArray.length; ++j) {
            if (this.foundMatch(bl, rDNArray[j], rDNArray2)) continue;
            return false;
        }
        return true;
    }

    private boolean foundMatch(boolean bl, RDN rDN, RDN[] rDNArray) {
        if (bl) {
            for (int j = rDNArray.length - 1; j >= 0; --j) {
                if (rDNArray[j] == null || !this.rdnAreEqual(rDN, rDNArray[j])) continue;
                rDNArray[j] = null;
                return true;
            }
        } else {
            for (int j = 0; j != rDNArray.length; ++j) {
                if (rDNArray[j] == null || !this.rdnAreEqual(rDN, rDNArray[j])) continue;
                rDNArray[j] = null;
                return true;
            }
        }
        return false;
    }

    protected boolean rdnAreEqual(RDN rDN, RDN rDN2) {
        return IETFUtils.rDNAreEqual(rDN, rDN2);
    }
}

