/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.nio.file.attribute.FileTime;
import java.util.concurrent.TimeUnit;

public final class TimeUtils {
    static final long HUNDRED_NANOS_PER_MILLISECOND = TimeUnit.MILLISECONDS.toNanos(1L) / 100L;

    public static boolean isUnixTime(FileTime time2) {
        return TimeUtils.isUnixTime(TimeUtils.toUnixTime(time2));
    }

    public static boolean isUnixTime(long seconds) {
        return Integer.MIN_VALUE <= seconds && seconds <= Integer.MAX_VALUE;
    }

    public static long toUnixTime(FileTime fileTime) {
        return fileTime != null ? fileTime.to(TimeUnit.SECONDS) : 0L;
    }

    public static FileTime unixTimeToFileTime(long time2) {
        return FileTime.from(time2, TimeUnit.SECONDS);
    }
}

