/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.compress.archivers.zip.FileRandomAccessOutputStream;
import org.apache.commons.compress.archivers.zip.RandomAccessOutputStream;
import org.apache.commons.compress.utils.FileNameUtils;

final class ZipSplitOutputStream
extends RandomAccessOutputStream {
    private FileChannel currentChannel;
    private FileRandomAccessOutputStream outputStream;
    private Path zipFile;
    private final long splitSize;
    private long totalPosition;
    private int currentSplitSegmentIndex;
    private long currentSplitSegmentBytesWritten;
    private boolean finished;
    private final byte[] singleByte;
    private final List<Long> diskToPosition;
    private final TreeMap<Long, Path> positionToFiles;

    @Override
    public void close() throws IOException {
        if (!this.finished) {
            this.finish();
        }
    }

    private Path createNewSplitSegmentFile(Integer zipSplitSegmentSuffixIndex) throws IOException {
        Path newFile = this.getSplitSegmentFileName(zipSplitSegmentSuffixIndex);
        if (Files.exists(newFile, new LinkOption[0])) {
            throw new IOException("split ZIP segment " + newFile + " already exists");
        }
        return newFile;
    }

    private void finish() throws IOException {
        if (this.finished) {
            throw new IOException("This archive has already been finished");
        }
        String zipFileBaseName = FileNameUtils.getBaseName(this.zipFile);
        this.outputStream.close();
        Files.move(this.zipFile, this.zipFile.resolveSibling(zipFileBaseName + ".zip"), StandardCopyOption.ATOMIC_MOVE);
        this.finished = true;
    }

    public long getCurrentSplitSegmentBytesWritten() {
        return this.currentSplitSegmentBytesWritten;
    }

    public int getCurrentSplitSegmentIndex() {
        return this.currentSplitSegmentIndex;
    }

    private Path getSplitSegmentFileName(Integer zipSplitSegmentSuffixIndex) {
        int newZipSplitSegmentSuffixIndex = zipSplitSegmentSuffixIndex == null ? this.currentSplitSegmentIndex + 2 : zipSplitSegmentSuffixIndex;
        String baseName = FileNameUtils.getBaseName(this.zipFile);
        StringBuilder extension2 = new StringBuilder(".z");
        if (newZipSplitSegmentSuffixIndex <= 9) {
            extension2.append("0").append(newZipSplitSegmentSuffixIndex);
        } else {
            extension2.append(newZipSplitSegmentSuffixIndex);
        }
        Path parent = this.zipFile.getParent();
        String dir = Objects.nonNull(parent) ? parent.toAbsolutePath().toString() : ".";
        return this.zipFile.getFileSystem().getPath(dir, baseName + extension2.toString());
    }

    private void openNewSplitSegment() throws IOException {
        Path newFile;
        if (this.currentSplitSegmentIndex == 0) {
            this.outputStream.close();
            newFile = this.createNewSplitSegmentFile(1);
            Files.move(this.zipFile, newFile, StandardCopyOption.ATOMIC_MOVE);
            this.positionToFiles.put(0L, newFile);
        }
        newFile = this.createNewSplitSegmentFile(null);
        this.outputStream.close();
        this.outputStream = new FileRandomAccessOutputStream(newFile);
        this.currentChannel = this.outputStream.channel();
        this.currentSplitSegmentBytesWritten = 0L;
        this.zipFile = newFile;
        ++this.currentSplitSegmentIndex;
        this.diskToPosition.add(this.totalPosition);
        this.positionToFiles.put(this.totalPosition, newFile);
    }

    public void prepareToWriteUnsplittableContent(long unsplittableContentSize) throws IllegalArgumentException, IOException {
        if (unsplittableContentSize > this.splitSize) {
            throw new IllegalArgumentException("The unsplittable content size is bigger than the split segment size");
        }
        long bytesRemainingInThisSegment = this.splitSize - this.currentSplitSegmentBytesWritten;
        if (bytesRemainingInThisSegment < unsplittableContentSize) {
            this.openNewSplitSegment();
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len <= 0) {
            return;
        }
        if (this.currentSplitSegmentBytesWritten >= this.splitSize) {
            this.openNewSplitSegment();
            this.write(b, off, len);
        } else if (this.currentSplitSegmentBytesWritten + (long)len > this.splitSize) {
            int bytesToWriteForThisSegment = (int)this.splitSize - (int)this.currentSplitSegmentBytesWritten;
            this.write(b, off, bytesToWriteForThisSegment);
            this.openNewSplitSegment();
            this.write(b, off + bytesToWriteForThisSegment, len - bytesToWriteForThisSegment);
        } else {
            this.outputStream.write(b, off, len);
            this.currentSplitSegmentBytesWritten += (long)len;
            this.totalPosition += (long)len;
        }
    }

    @Override
    public void write(int i2) throws IOException {
        this.singleByte[0] = (byte)(i2 & 0xFF);
        this.write(this.singleByte);
    }
}

