/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.Serializable;
import org.apache.commons.compress.utils.ByteUtils;

public final class ZipLong
implements Serializable,
Cloneable {
    public static final ZipLong CFH_SIG = new ZipLong(33639248L);
    public static final ZipLong LFH_SIG = new ZipLong(67324752L);
    public static final ZipLong DD_SIG = new ZipLong(134695760L);
    static final ZipLong ZIP64_MAGIC = new ZipLong(0xFFFFFFFFL);
    public static final ZipLong SINGLE_SEGMENT_SPLIT_MARKER = new ZipLong(808471376L);
    public static final ZipLong AED_SIG = new ZipLong(134630224L);
    private final long value;

    public static byte[] getBytes(long value2) {
        byte[] result2 = new byte[4];
        ZipLong.putLong(value2, result2, 0);
        return result2;
    }

    public static long getValue(byte[] bytes2) {
        return ZipLong.getValue(bytes2, 0);
    }

    public static long getValue(byte[] bytes2, int offset) {
        return ByteUtils.fromLittleEndian(bytes2, offset, 4);
    }

    public static void putLong(long value2, byte[] buf, int offset) {
        ByteUtils.toLittleEndian(buf, value2, offset, 4);
    }

    public ZipLong(byte[] bytes2, int offset) {
        this.value = ZipLong.getValue(bytes2, offset);
    }

    public ZipLong(long value2) {
        this.value = value2;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnfe) {
            throw new UnsupportedOperationException(cnfe);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof ZipLong)) {
            return false;
        }
        return this.value == ((ZipLong)o).getValue();
    }

    public byte[] getBytes() {
        return ZipLong.getBytes(this.value);
    }

    public int getIntValue() {
        return (int)this.value;
    }

    public long getValue() {
        return this.value;
    }

    public int hashCode() {
        return (int)this.value;
    }

    public void putLong(byte[] buf, int offset) {
        ZipLong.putLong(this.value, buf, offset);
    }

    public String toString() {
        return "ZipLong value: " + this.value;
    }
}

