/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls.internal.der;

import kotlin.jvm.internal.Intrinsics;
import okhttp3.tls.internal.der.AlgorithmIdentifier;
import okhttp3.tls.internal.der.BitString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SubjectPublicKeyInfo {
    @NotNull
    private final AlgorithmIdentifier algorithm;
    @NotNull
    private final BitString subjectPublicKey;

    public SubjectPublicKeyInfo(@NotNull AlgorithmIdentifier algorithm, @NotNull BitString subjectPublicKey) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)subjectPublicKey, (String)"subjectPublicKey");
        this.algorithm = algorithm;
        this.subjectPublicKey = subjectPublicKey;
    }

    @NotNull
    public final AlgorithmIdentifier getAlgorithm() {
        return this.algorithm;
    }

    @NotNull
    public final BitString getSubjectPublicKey() {
        return this.subjectPublicKey;
    }

    @NotNull
    public final AlgorithmIdentifier component1() {
        return this.algorithm;
    }

    @NotNull
    public final BitString component2() {
        return this.subjectPublicKey;
    }

    @NotNull
    public final SubjectPublicKeyInfo copy(@NotNull AlgorithmIdentifier algorithm, @NotNull BitString subjectPublicKey) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)subjectPublicKey, (String)"subjectPublicKey");
        return new SubjectPublicKeyInfo(algorithm, subjectPublicKey);
    }

    public static /* synthetic */ SubjectPublicKeyInfo copy$default(SubjectPublicKeyInfo subjectPublicKeyInfo2, AlgorithmIdentifier algorithmIdentifier2, BitString bitString, int n, Object object) {
        if ((n & 1) != 0) {
            algorithmIdentifier2 = subjectPublicKeyInfo2.algorithm;
        }
        if ((n & 2) != 0) {
            bitString = subjectPublicKeyInfo2.subjectPublicKey;
        }
        return subjectPublicKeyInfo2.copy(algorithmIdentifier2, bitString);
    }

    @NotNull
    public String toString() {
        return "SubjectPublicKeyInfo(algorithm=" + this.algorithm + ", subjectPublicKey=" + this.subjectPublicKey + ')';
    }

    public int hashCode() {
        int result2 = this.algorithm.hashCode();
        result2 = result2 * 31 + this.subjectPublicKey.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SubjectPublicKeyInfo)) {
            return false;
        }
        SubjectPublicKeyInfo subjectPublicKeyInfo2 = (SubjectPublicKeyInfo)other;
        if (!Intrinsics.areEqual((Object)this.algorithm, (Object)subjectPublicKeyInfo2.algorithm)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.subjectPublicKey, (Object)subjectPublicKeyInfo2.subjectPublicKey);
    }
}

