/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls.internal.der;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.tls.internal.der.BitString;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DerWriter {
    @NotNull
    private final List<BufferedSink> stack;
    @NotNull
    private final List<Object> typeHintStack;
    @NotNull
    private final List<String> path;
    private boolean constructed;

    public DerWriter(@NotNull BufferedSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Object[] objectArray = new BufferedSink[]{sink};
        this.stack = CollectionsKt.mutableListOf((Object[])objectArray);
        this.typeHintStack = new ArrayList();
        this.path = new ArrayList();
    }

    @Nullable
    public final Object getTypeHint() {
        return CollectionsKt.lastOrNull(this.typeHintStack);
    }

    public final void setTypeHint(@Nullable Object value2) {
        this.typeHintStack.set(this.typeHintStack.size() - 1, value2);
    }

    public final boolean getConstructed() {
        return this.constructed;
    }

    public final void setConstructed(boolean bl) {
        this.constructed = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(@NotNull String name2, int tagClass, long tag, @NotNull Function1<? super BufferedSink, Unit> block) {
        int byte0;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        int constructedBit = 0;
        Buffer content2 = new Buffer();
        this.stack.add((BufferedSink)content2);
        this.constructed = false;
        ((Collection)this.path).add(name2);
        try {
            block.invoke((Object)content2);
            constructedBit = this.constructed ? 32 : 0;
            this.constructed = true;
        }
        finally {
            this.stack.remove(this.stack.size() - 1);
            this.path.remove(this.path.size() - 1);
        }
        BufferedSink sink = this.sink();
        if (tag < 31L) {
            byte0 = tagClass | constructedBit | (int)tag;
            sink.writeByte(byte0);
        } else {
            byte0 = tagClass | constructedBit | 0x1F;
            sink.writeByte(byte0);
            this.writeVariableLengthLong(tag);
        }
        long length = content2.size();
        if (length < 128L) {
            sink.writeByte((int)length);
        } else {
            int n;
            int lengthBitCount = 64 - Long.numberOfLeadingZeros(length);
            int lengthByteCount = (lengthBitCount + 7) / 8;
            sink.writeByte(0x80 | lengthByteCount);
            int shift = n = (lengthByteCount - 1) * 8;
            int n2 = ProgressionUtilKt.getProgressionLastElement((int)n, (int)0, (int)-8);
            if (n2 <= shift) {
                while (true) {
                    sink.writeByte((int)(length >> shift));
                    if (shift == n2) break;
                    shift -= 8;
                }
            }
        }
        sink.writeAll((Source)content2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T withTypeHint(@NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.typeHintStack.add(null);
        try {
            Object object = block.invoke();
            return (T)object;
        }
        finally {
            this.typeHintStack.remove(this.typeHintStack.size() - 1);
        }
    }

    private final BufferedSink sink() {
        return this.stack.get(this.stack.size() - 1);
    }

    public final void writeBoolean(boolean b) {
        this.sink().writeByte(b ? -1 : 0);
    }

    public final void writeBigInteger(@NotNull BigInteger value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        BufferedSink bufferedSink = this.sink();
        byte[] byArray = value2.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"value.toByteArray()");
        bufferedSink.write(byArray);
    }

    public final void writeLong(long v) {
        int n;
        BufferedSink sink = this.sink();
        int lengthBitCount = v < 0L ? 65 - Long.numberOfLeadingZeros(v ^ 0xFFFFFFFFFFFFFFFFL) : 65 - Long.numberOfLeadingZeros(v);
        int lengthByteCount = (lengthBitCount + 7) / 8;
        int shift = n = (lengthByteCount - 1) * 8;
        int n2 = ProgressionUtilKt.getProgressionLastElement((int)n, (int)0, (int)-8);
        if (n2 <= shift) {
            while (true) {
                sink.writeByte((int)(v >> shift));
                if (shift == n2) break;
                shift -= 8;
            }
        }
    }

    public final void writeBitString(@NotNull BitString bitString) {
        Intrinsics.checkNotNullParameter((Object)bitString, (String)"bitString");
        BufferedSink sink = this.sink();
        sink.writeByte(bitString.getUnusedBitsCount());
        sink.write(bitString.getByteString());
    }

    public final void writeOctetString(@NotNull ByteString byteString) {
        Intrinsics.checkNotNullParameter((Object)byteString, (String)"byteString");
        this.sink().write(byteString);
    }

    public final void writeUtf8(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.sink().writeUtf8(value2);
    }

    public final void writeObjectIdentifier(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Buffer utf8 = new Buffer().writeUtf8(s);
        long v1 = utf8.readDecimalLong();
        if (!(utf8.readByte() == 46)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        long v2 = utf8.readDecimalLong();
        this.writeVariableLengthLong(v1 * (long)40 + v2);
        while (!utf8.exhausted()) {
            if (!(utf8.readByte() == 46)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            long vN = utf8.readDecimalLong();
            this.writeVariableLengthLong(vN);
        }
    }

    public final void writeRelativeObjectIdentifier(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Buffer utf8 = new Buffer().writeByte(46).writeUtf8(s);
        while (!utf8.exhausted()) {
            if (!(utf8.readByte() == 46)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            long vN = utf8.readDecimalLong();
            this.writeVariableLengthLong(vN);
        }
    }

    private final void writeVariableLengthLong(long v) {
        int n;
        BufferedSink sink = this.sink();
        int bitCount = 64 - Long.numberOfLeadingZeros(v);
        int byteCount = (bitCount + 6) / 7;
        int shift = n = (byteCount - 1) * 7;
        int n2 = ProgressionUtilKt.getProgressionLastElement((int)n, (int)0, (int)-7);
        if (n2 <= shift) {
            while (true) {
                int lastBit = shift == 0 ? 0 : 128;
                sink.writeByte((int)(v >> shift & 0x7FL) | lastBit);
                if (shift == n2) break;
                shift -= 7;
            }
        }
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.path, (CharSequence)" / ", null, null, (int)0, null, null, (int)62, null);
    }
}

