/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls.internal.der;

import java.math.BigInteger;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.tls.internal.der.BitString;
import okhttp3.tls.internal.der.DerHeader;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DerReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CountingSource countingSource;
    @NotNull
    private final BufferedSource source;
    private long limit;
    @NotNull
    private final List<Object> typeHintStack;
    @NotNull
    private final List<String> path;
    private boolean constructed;
    @Nullable
    private DerHeader peekedHeader;
    @NotNull
    private static final DerHeader END_OF_DATA = new DerHeader(0, 0L, false, -1L);

    public DerReader(@NotNull Source source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.countingSource = new CountingSource(source);
        this.source = Okio.buffer((Source)((Source)this.countingSource));
        this.limit = -1L;
        this.typeHintStack = new ArrayList();
        this.path = new ArrayList();
    }

    private final long getByteCount() {
        return this.countingSource.getBytesRead() - this.source.getBuffer().size();
    }

    @Nullable
    public final Object getTypeHint() {
        return CollectionsKt.lastOrNull(this.typeHintStack);
    }

    public final void setTypeHint(@Nullable Object value2) {
        this.typeHintStack.set(this.typeHintStack.size() - 1, value2);
    }

    private final long getBytesLeft() {
        return this.limit == -1L ? -1L : this.limit - this.getByteCount();
    }

    public final boolean hasNext() {
        return this.peekHeader() != null;
    }

    @Nullable
    public final DerHeader peekHeader() {
        DerHeader result2 = this.peekedHeader;
        if (result2 == null) {
            this.peekedHeader = result2 = this.readHeader$okhttp_tls();
        }
        if (result2.isEndOfData()) {
            return null;
        }
        return result2;
    }

    @NotNull
    public final DerHeader readHeader$okhttp_tls() {
        long l;
        if (!(this.peekedHeader == null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.getByteCount() == this.limit) {
            return END_OF_DATA;
        }
        if (this.limit == -1L && this.source.exhausted()) {
            return END_OF_DATA;
        }
        int tagAndClass = this.source.readByte() & 0xFF;
        int tagClass = tagAndClass & 0xC0;
        boolean constructed = (tagAndClass & 0x20) == 32;
        int tag0 = tagAndClass & 0x1F;
        long tag = tag0 == 31 ? this.readVariableLengthLong() : (long)tag0;
        int length0 = this.source.readByte() & 0xFF;
        if (length0 == 128) {
            throw new ProtocolException("indefinite length not permitted for DER");
        }
        if ((length0 & 0x80) == 128) {
            int lengthBytes = length0 & 0x7F;
            if (lengthBytes > 8) {
                throw new ProtocolException("length encoded with more than 8 bytes is not supported");
            }
            long lengthBits = (long)this.source.readByte() & 0xFFL;
            if (lengthBits == 0L || lengthBytes == 1 && (lengthBits & 0x80L) == 0L) {
                throw new ProtocolException("invalid encoding for length");
            }
            for (int i2 = 1; i2 < lengthBytes; ++i2) {
                lengthBits <<= 8;
                lengthBits += (long)(this.source.readByte() & 0xFF);
            }
            if (lengthBits < 0L) {
                throw new ProtocolException("length > Long.MAX_VALUE");
            }
            l = lengthBits;
        } else {
            l = length0 & 0x7F;
        }
        long length = l;
        return new DerHeader(tagClass, tag, constructed, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T read$okhttp_tls(@Nullable String name2, @NotNull Function1<? super DerHeader, ? extends T> block) {
        long newLimit;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$read$okhttp_tls = false;
        if (!this.hasNext()) {
            throw new ProtocolException("expected a value");
        }
        DerHeader derHeader = this.peekedHeader;
        Intrinsics.checkNotNull((Object)derHeader);
        DerHeader header = derHeader;
        this.peekedHeader = null;
        long pushedLimit = this.limit;
        boolean pushedConstructed = this.constructed;
        long l = newLimit = header.getLength() != -1L ? this.getByteCount() + header.getLength() : -1L;
        if (pushedLimit != -1L && newLimit > pushedLimit) {
            throw new ProtocolException("enclosed object too large");
        }
        this.limit = newLimit;
        this.constructed = header.getConstructed();
        if (name2 != null) {
            ((Collection)this.path).add(name2);
        }
        try {
            Object result2 = block.invoke((Object)header);
            if (newLimit != -1L && this.getByteCount() > newLimit) {
                throw new ProtocolException("unexpected byte count at " + this);
            }
            Object object = result2;
            return (T)object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.peekedHeader = null;
            this.limit = pushedLimit;
            this.constructed = pushedConstructed;
            if (name2 != null) {
                this.path.remove(this.path.size() - 1);
            }
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T withTypeHint(@NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.typeHintStack.add(null);
        try {
            Object object = block.invoke();
            return (T)object;
        }
        finally {
            this.typeHintStack.remove(this.typeHintStack.size() - 1);
        }
    }

    public final boolean readBoolean() {
        if (this.getBytesLeft() != 1L) {
            throw new ProtocolException("unexpected length: " + this.getBytesLeft() + " at " + this);
        }
        return this.source.readByte() != 0;
    }

    @NotNull
    public final BigInteger readBigInteger() {
        if (this.getBytesLeft() == 0L) {
            throw new ProtocolException("unexpected length: " + this.getBytesLeft() + " at " + this);
        }
        byte[] byteArray2 = this.source.readByteArray(this.getBytesLeft());
        return new BigInteger(byteArray2);
    }

    public final long readLong() {
        long l = this.getBytesLeft();
        if (!(1L <= l ? l < 9L : false)) {
            throw new ProtocolException("unexpected length: " + this.getBytesLeft() + " at " + this);
        }
        long result2 = this.source.readByte();
        while (this.getByteCount() < this.limit) {
            result2 <<= 8;
            result2 += (long)(this.source.readByte() & 0xFF);
        }
        return result2;
    }

    @NotNull
    public final BitString readBitString() {
        if (this.getBytesLeft() == -1L || this.constructed) {
            throw new ProtocolException("constructed bit strings not supported for DER");
        }
        if (this.getBytesLeft() < 1L) {
            throw new ProtocolException("malformed bit string");
        }
        int unusedBitCount = this.source.readByte() & 0xFF;
        ByteString byteString = this.source.readByteString(this.getBytesLeft());
        return new BitString(byteString, unusedBitCount);
    }

    @NotNull
    public final ByteString readOctetString() {
        if (this.getBytesLeft() == -1L || this.constructed) {
            throw new ProtocolException("constructed octet strings not supported for DER");
        }
        return this.source.readByteString(this.getBytesLeft());
    }

    @NotNull
    public final String readUtf8String() {
        if (this.getBytesLeft() == -1L || this.constructed) {
            throw new ProtocolException("constructed strings not supported for DER");
        }
        return this.source.readUtf8(this.getBytesLeft());
    }

    @NotNull
    public final String readObjectIdentifier() {
        Buffer result2 = new Buffer();
        int dot = 46;
        long xy = this.readVariableLengthLong();
        boolean bl = 0L <= xy ? xy < 40L : false;
        if (bl) {
            result2.writeDecimalLong(0L);
            result2.writeByte(dot);
            result2.writeDecimalLong(xy);
        } else {
            boolean bl2 = 40L <= xy ? xy < 80L : false;
            if (bl2) {
                result2.writeDecimalLong(1L);
                result2.writeByte(dot);
                result2.writeDecimalLong(xy - 40L);
            } else {
                result2.writeDecimalLong(2L);
                result2.writeByte(dot);
                result2.writeDecimalLong(xy - 80L);
            }
        }
        while (this.getByteCount() < this.limit) {
            result2.writeByte(dot);
            result2.writeDecimalLong(this.readVariableLengthLong());
        }
        return result2.readUtf8();
    }

    @NotNull
    public final String readRelativeObjectIdentifier() {
        Buffer result2 = new Buffer();
        int dot = 46;
        while (this.getByteCount() < this.limit) {
            if (result2.size() > 0L) {
                result2.writeByte(dot);
            }
            result2.writeDecimalLong(this.readVariableLengthLong());
        }
        return result2.readUtf8();
    }

    private final long readVariableLengthLong() {
        long byteN;
        long result2 = 0L;
        while (((byteN = (long)this.source.readByte() & 0xFFL) & 0x80L) == 128L) {
            result2 = result2 + (byteN & 0x7FL) << 7;
        }
        return result2 + byteN;
    }

    @NotNull
    public final ByteString readUnknown() {
        return this.source.readByteString(this.getBytesLeft());
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.path, (CharSequence)" / ", null, null, (int)0, null, null, (int)62, null);
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    private static final class CountingSource
    extends ForwardingSource {
        private long bytesRead;

        public CountingSource(@NotNull Source source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            super(source);
        }

        public final long getBytesRead() {
            return this.bytesRead;
        }

        public final void setBytesRead(long l) {
            this.bytesRead = l;
        }

        public long read(@NotNull Buffer sink, long byteCount) {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            long result2 = this.delegate().read(sink, byteCount);
            if (result2 == -1L) {
                return -1L;
            }
            this.bytesRead += result2;
            return result2;
        }
    }
}

