/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls.internal.der;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.tls.internal.der.BasicDerAdapter;
import okhttp3.tls.internal.der.DerHeader;
import okhttp3.tls.internal.der.DerReader;
import okhttp3.tls.internal.der.DerWriter;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DerAdapter<T> {
    public boolean matches(@NotNull DerHeader var1);

    public T fromDer(@NotNull DerReader var1);

    public T fromDer(@NotNull ByteString var1);

    public void toDer(@NotNull DerWriter var1, T var2);

    @NotNull
    public ByteString toDer(T var1);

    @NotNull
    public BasicDerAdapter<T> withExplicitBox(int var1, long var2, @Nullable Boolean var4);

    @NotNull
    public BasicDerAdapter<List<T>> asSequenceOf(@NotNull String var1, int var2, long var3);

    @NotNull
    public BasicDerAdapter<List<T>> asSetOf();

    public static final class DefaultImpls {
        public static <T> T fromDer(@NotNull DerAdapter<T> $this, @NotNull ByteString byteString) {
            Intrinsics.checkNotNullParameter((Object)byteString, (String)"byteString");
            Buffer buffer = new Buffer().write(byteString);
            DerReader reader2 = new DerReader((Source)buffer);
            return $this.fromDer(reader2);
        }

        @NotNull
        public static <T> ByteString toDer(@NotNull DerAdapter<T> $this, T value2) {
            Buffer buffer = new Buffer();
            DerWriter writer2 = new DerWriter((BufferedSink)buffer);
            $this.toDer(writer2, value2);
            return buffer.readByteString();
        }

        @NotNull
        public static <T> BasicDerAdapter<T> withExplicitBox(@NotNull DerAdapter<T> $this, int tagClass, long tag, @Nullable Boolean forceConstructed) {
            BasicDerAdapter.Codec codec2 = new BasicDerAdapter.Codec<T>($this, forceConstructed){
                final /* synthetic */ DerAdapter<T> this$0;
                final /* synthetic */ Boolean $forceConstructed;
                {
                    this.this$0 = $receiver;
                    this.$forceConstructed = $forceConstructed;
                }

                public T decode(@NotNull DerReader reader2) {
                    Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
                    return this.this$0.fromDer(reader2);
                }

                public void encode(@NotNull DerWriter writer2, T value2) {
                    Intrinsics.checkNotNullParameter((Object)writer2, (String)"writer");
                    this.this$0.toDer(writer2, value2);
                    if (this.$forceConstructed != null) {
                        writer2.setConstructed(this.$forceConstructed);
                    }
                }
            };
            return new BasicDerAdapter("EXPLICIT", tagClass, tag, codec2, false, null, false, 112, null);
        }

        public static /* synthetic */ BasicDerAdapter withExplicitBox$default(DerAdapter derAdapter, int n, long l, Boolean bl, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: withExplicitBox");
            }
            if ((n2 & 1) != 0) {
                n = 128;
            }
            if ((n2 & 4) != 0) {
                bl = null;
            }
            return derAdapter.withExplicitBox(n, l, bl);
        }

        @NotNull
        public static <T> BasicDerAdapter<List<T>> asSequenceOf(@NotNull DerAdapter<T> $this, @NotNull String name2, int tagClass, long tag) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            BasicDerAdapter.Codec codec2 = new BasicDerAdapter.Codec<List<? extends T>>($this){
                final /* synthetic */ DerAdapter<T> this$0;
                {
                    this.this$0 = $receiver;
                }

                public void encode(@NotNull DerWriter writer2, @NotNull List<? extends T> value2) {
                    Intrinsics.checkNotNullParameter((Object)writer2, (String)"writer");
                    Intrinsics.checkNotNullParameter(value2, (String)"value");
                    for (T v : value2) {
                        this.this$0.toDer(writer2, v);
                    }
                }

                @NotNull
                public List<T> decode(@NotNull DerReader reader2) {
                    Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
                    List result2 = new ArrayList<E>();
                    while (reader2.hasNext()) {
                        ((Collection)result2).add(this.this$0.fromDer(reader2));
                    }
                    return result2;
                }
            };
            return new BasicDerAdapter<List<T>>(name2, tagClass, tag, codec2, false, null, false, 112, null);
        }

        public static /* synthetic */ BasicDerAdapter asSequenceOf$default(DerAdapter derAdapter, String string, int n, long l, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: asSequenceOf");
            }
            if ((n2 & 1) != 0) {
                string = "SEQUENCE OF";
            }
            if ((n2 & 2) != 0) {
                n = 0;
            }
            if ((n2 & 4) != 0) {
                l = 16L;
            }
            return derAdapter.asSequenceOf(string, n, l);
        }

        @NotNull
        public static <T> BasicDerAdapter<List<T>> asSetOf(@NotNull DerAdapter<T> $this) {
            return $this.asSequenceOf("SET OF", 0, 17L);
        }
    }
}

