/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls.internal.der;

import java.math.BigInteger;
import java.net.ProtocolException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import okhttp3.tls.internal.der.AnyValue;
import okhttp3.tls.internal.der.BasicDerAdapter;
import okhttp3.tls.internal.der.BitString;
import okhttp3.tls.internal.der.DerAdapter;
import okhttp3.tls.internal.der.DerHeader;
import okhttp3.tls.internal.der.DerReader;
import okhttp3.tls.internal.der.DerWriter;
import okio.BufferedSink;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nAdapters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Adapters.kt\nokhttp3/tls/internal/der/Adapters\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,432:1\n37#2,2:433\n*S KotlinDebug\n*F\n+ 1 Adapters.kt\nokhttp3/tls/internal/der/Adapters\n*L\n392#1:433,2\n*E\n"})
public final class Adapters {
    @NotNull
    public static final Adapters INSTANCE = new Adapters();
    @NotNull
    private static final BasicDerAdapter<Boolean> BOOLEAN = new BasicDerAdapter("BOOLEAN", 0, 1L, new BasicDerAdapter.Codec<Boolean>(){

        @NotNull
        public Boolean decode(@NotNull DerReader reader2) {
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            return reader2.readBoolean();
        }

        public void encode(@NotNull DerWriter writer2, boolean value2) {
            Intrinsics.checkNotNullParameter((Object)writer2, (String)"writer");
            writer2.writeBoolean(value2);
        }
    }, false, null, false, 112, null);
    @NotNull
    private static final BasicDerAdapter<Long> INTEGER_AS_LONG = new BasicDerAdapter("INTEGER", 0, 2L, new BasicDerAdapter.Codec<Long>(){

        @NotNull
        public Long decode(@NotNull DerReader reader2) {
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            return reader2.readLong();
        }

        public void encode(@NotNull DerWriter writer2, long value2) {
            Intrinsics.checkNotNullParameter((Object)writer2, (String)"writer");
            writer2.writeLong(value2);
        }
    }, false, null, false, 112, null);
    @NotNull
    private static final BasicDerAdapter<BigInteger> INTEGER_AS_BIG_INTEGER = new BasicDerAdapter("INTEGER", 0, 2L, new BasicDerAdapter.Codec<BigInteger>(){

        @NotNull
        public BigInteger decode(@NotNull DerReader reader2) {
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            return reader2.readBigInteger();
        }

        public void encode(@NotNull DerWriter writer2, @NotNull BigInteger value2) {
            Intrinsics.checkNotNullParameter((Object)writer2, (String)"writer");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            writer2.writeBigInteger(value2);
        }
    }, false, null, false, 112, null);
    @NotNull
    private static final BasicDerAdapter<BitString> BIT_STRING = new BasicDerAdapter("BIT STRING", 0, 3L, new BasicDerAdapter.Codec<BitString>(){

        @NotNull
        public BitString decode(@NotNull DerReader reader2) {
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            return reader2.readBitString();
        }

        public void encode(@NotNull DerWriter writer2, @NotNull BitString value2) {
            Intrinsics.checkNotNullParameter((Object)writer2, (String)"writer");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            writer2.writeBitString(value2);
        }
    }, false, null, false, 112, null);
    @NotNull
    private static final BasicDerAdapter<ByteString> OCTET_STRING = new BasicDerAdapter("OCTET STRING", 0, 4L, new BasicDerAdapter.Codec<ByteString>(){

        @NotNull
        public ByteString decode(@NotNull DerReader reader2) {
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            return reader2.readOctetString();
        }

        public void encode(@NotNull DerWriter writer2, @NotNull ByteString value2) {
            Intrinsics.checkNotNullParameter((Object)writer2, (String)"writer");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            writer2.writeOctetString(value2);
        }
    }, false, null, false, 112, null);
    @NotNull
    private static final BasicDerAdapter<Unit> NULL = new BasicDerAdapter("NULL", 0, 5L, new BasicDerAdapter.Codec<Unit>(){

        @Nullable
        public Void decode(@NotNull DerReader reader2) {
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            return null;
        }

        public void encode(@NotNull DerWriter writer2, @Nullable Unit value2) {
            Intrinsics.checkNotNullParameter((Object)writer2, (String)"writer");
        }
    }, false, null, false, 112, null);
    @NotNull
    private static final BasicDerAdapter<String> OBJECT_IDENTIFIER = new BasicDerAdapter("OBJECT IDENTIFIER", 0, 6L, new BasicDerAdapter.Codec<String>(){

        @NotNull
        public String decode(@NotNull DerReader reader2) {
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            return reader2.readObjectIdentifier();
        }

        public void encode(@NotNull DerWriter writer2, @NotNull String value2) {
            Intrinsics.checkNotNullParameter((Object)writer2, (String)"writer");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            writer2.writeObjectIdentifier(value2);
        }
    }, false, null, false, 112, null);
    @NotNull
    private static final BasicDerAdapter<String> UTF8_STRING = new BasicDerAdapter("UTF8", 0, 12L, new BasicDerAdapter.Codec<String>(){

        @NotNull
        public String decode(@NotNull DerReader reader2) {
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            return reader2.readUtf8String();
        }

        public void encode(@NotNull DerWriter writer2, @NotNull String value2) {
            Intrinsics.checkNotNullParameter((Object)writer2, (String)"writer");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            writer2.writeUtf8(value2);
        }
    }, false, null, false, 112, null);
    @NotNull
    private static final BasicDerAdapter<String> PRINTABLE_STRING = new BasicDerAdapter("PRINTABLE STRING", 0, 19L, new BasicDerAdapter.Codec<String>(){

        @NotNull
        public String decode(@NotNull DerReader reader2) {
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            return reader2.readUtf8String();
        }

        public void encode(@NotNull DerWriter writer2, @NotNull String value2) {
            Intrinsics.checkNotNullParameter((Object)writer2, (String)"writer");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            writer2.writeUtf8(value2);
        }
    }, false, null, false, 112, null);
    @NotNull
    private static final BasicDerAdapter<String> IA5_STRING = new BasicDerAdapter("IA5 STRING", 0, 22L, new BasicDerAdapter.Codec<String>(){

        @NotNull
        public String decode(@NotNull DerReader reader2) {
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            return reader2.readUtf8String();
        }

        public void encode(@NotNull DerWriter writer2, @NotNull String value2) {
            Intrinsics.checkNotNullParameter((Object)writer2, (String)"writer");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            writer2.writeUtf8(value2);
        }
    }, false, null, false, 112, null);
    @NotNull
    private static final BasicDerAdapter<Long> UTC_TIME = new BasicDerAdapter("UTC TIME", 0, 23L, new BasicDerAdapter.Codec<Long>(){

        @NotNull
        public Long decode(@NotNull DerReader reader2) {
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            String string = reader2.readUtf8String();
            return Adapters.INSTANCE.parseUtcTime$okhttp_tls(string);
        }

        public void encode(@NotNull DerWriter writer2, long value2) {
            Intrinsics.checkNotNullParameter((Object)writer2, (String)"writer");
            String string = Adapters.INSTANCE.formatUtcTime$okhttp_tls(value2);
            writer2.writeUtf8(string);
        }
    }, false, null, false, 112, null);
    @NotNull
    private static final BasicDerAdapter<Long> GENERALIZED_TIME = new BasicDerAdapter("GENERALIZED TIME", 0, 24L, new BasicDerAdapter.Codec<Long>(){

        @NotNull
        public Long decode(@NotNull DerReader reader2) {
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            String string = reader2.readUtf8String();
            return Adapters.INSTANCE.parseGeneralizedTime$okhttp_tls(string);
        }

        public void encode(@NotNull DerWriter writer2, long value2) {
            Intrinsics.checkNotNullParameter((Object)writer2, (String)"writer");
            String string = Adapters.INSTANCE.formatGeneralizedTime$okhttp_tls(value2);
            writer2.writeUtf8(string);
        }
    }, false, null, false, 112, null);
    @NotNull
    private static final DerAdapter<AnyValue> ANY_VALUE = new DerAdapter<AnyValue>(){

        public boolean matches(@NotNull DerHeader header) {
            Intrinsics.checkNotNullParameter((Object)header, (String)"header");
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public AnyValue fromDer(@NotNull DerReader reader2) {
            long newLimit$iv;
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            DerReader derReader = reader2;
            String name$iv = "ANY";
            boolean $i$f$read$okhttp_tls = false;
            if (!this_$iv.hasNext()) {
                throw new ProtocolException("expected a value");
            }
            DerHeader derHeader = DerReader.access$getPeekedHeader$p((DerReader)this_$iv);
            Intrinsics.checkNotNull((Object)derHeader);
            DerHeader header$iv = derHeader;
            DerReader.access$setPeekedHeader$p((DerReader)this_$iv, null);
            long pushedLimit$iv = DerReader.access$getLimit$p((DerReader)this_$iv);
            boolean pushedConstructed$iv = DerReader.access$getConstructed$p((DerReader)this_$iv);
            long l = newLimit$iv = header$iv.getLength() != -1L ? DerReader.access$getByteCount((DerReader)this_$iv) + header$iv.getLength() : -1L;
            if (pushedLimit$iv != -1L && newLimit$iv > pushedLimit$iv) {
                throw new ProtocolException("enclosed object too large");
            }
            DerReader.access$setLimit$p((DerReader)this_$iv, newLimit$iv);
            DerReader.access$setConstructed$p((DerReader)this_$iv, header$iv.getConstructed());
            ((Collection)DerReader.access$getPath$p((DerReader)this_$iv)).add(name$iv);
            try {
                DerHeader header = header$iv;
                boolean bl = false;
                ByteString bytes2 = reader2.readUnknown();
                AnyValue anyValue = new AnyValue(header.getTagClass(), header.getTag(), header.getConstructed(), header.getLength(), bytes2);
                return anyValue;
            }
            finally {
                DerReader.access$setPeekedHeader$p((DerReader)this_$iv, null);
                DerReader.access$setLimit$p((DerReader)this_$iv, pushedLimit$iv);
                DerReader.access$setConstructed$p((DerReader)this_$iv, pushedConstructed$iv);
                DerReader.access$getPath$p((DerReader)this_$iv).remove(DerReader.access$getPath$p((DerReader)this_$iv).size() - 1);
            }
        }

        public void toDer(@NotNull DerWriter writer2, @NotNull AnyValue value2) {
            Intrinsics.checkNotNullParameter((Object)writer2, (String)"writer");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            writer2.write("ANY", value2.getTagClass(), value2.getTag(), (Function1<? super BufferedSink, Unit>)((Function1)new Function1<BufferedSink, Unit>(writer2, value2){
                final /* synthetic */ DerWriter $writer;
                final /* synthetic */ AnyValue $value;
                {
                    this.$writer = $writer;
                    this.$value = $value;
                    super(1);
                }

                public final void invoke(@NotNull BufferedSink it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$writer.writeOctetString(this.$value.getBytes());
                    this.$writer.setConstructed(this.$value.getConstructed());
                }
            }));
        }

        @NotNull
        public AnyValue fromDer(@NotNull ByteString byteString) {
            return DerAdapter.DefaultImpls.fromDer(this, byteString);
        }

        @NotNull
        public ByteString toDer(@NotNull AnyValue value2) {
            return DerAdapter.DefaultImpls.toDer(this, value2);
        }

        @NotNull
        public BasicDerAdapter<AnyValue> withExplicitBox(int tagClass, long tag, @Nullable Boolean forceConstructed) {
            return DerAdapter.DefaultImpls.withExplicitBox(this, tagClass, tag, forceConstructed);
        }

        @NotNull
        public BasicDerAdapter<List<AnyValue>> asSequenceOf(@NotNull String name2, int tagClass, long tag) {
            return DerAdapter.DefaultImpls.asSequenceOf(this, name2, tagClass, tag);
        }

        @NotNull
        public BasicDerAdapter<List<AnyValue>> asSetOf() {
            return DerAdapter.DefaultImpls.asSetOf(this);
        }
    };
    @NotNull
    private static final List<Pair<KClass<? extends Object>, DerAdapter<? extends Object>>> defaultAnyChoices;

    private Adapters() {
    }

    @NotNull
    public final BasicDerAdapter<Boolean> getBOOLEAN() {
        return BOOLEAN;
    }

    @NotNull
    public final BasicDerAdapter<Long> getINTEGER_AS_LONG() {
        return INTEGER_AS_LONG;
    }

    @NotNull
    public final BasicDerAdapter<BigInteger> getINTEGER_AS_BIG_INTEGER() {
        return INTEGER_AS_BIG_INTEGER;
    }

    @NotNull
    public final BasicDerAdapter<BitString> getBIT_STRING() {
        return BIT_STRING;
    }

    @NotNull
    public final BasicDerAdapter<ByteString> getOCTET_STRING() {
        return OCTET_STRING;
    }

    @NotNull
    public final BasicDerAdapter<Unit> getNULL() {
        return NULL;
    }

    @NotNull
    public final BasicDerAdapter<String> getOBJECT_IDENTIFIER() {
        return OBJECT_IDENTIFIER;
    }

    @NotNull
    public final BasicDerAdapter<String> getUTF8_STRING() {
        return UTF8_STRING;
    }

    @NotNull
    public final BasicDerAdapter<String> getPRINTABLE_STRING() {
        return PRINTABLE_STRING;
    }

    @NotNull
    public final BasicDerAdapter<String> getIA5_STRING() {
        return IA5_STRING;
    }

    @NotNull
    public final BasicDerAdapter<Long> getUTC_TIME() {
        return UTC_TIME;
    }

    public final long parseUtcTime$okhttp_tls(@NotNull String string) {
        SimpleDateFormat simpleDateFormat;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        TimeZone utc = TimeZone.getTimeZone("GMT");
        SimpleDateFormat $this$parseUtcTime_u24lambda_u240 = simpleDateFormat = new SimpleDateFormat("yyMMddHHmmss'Z'");
        boolean bl = false;
        $this$parseUtcTime_u24lambda_u240.setTimeZone(utc);
        $this$parseUtcTime_u24lambda_u240.set2DigitYearStart(new Date(-631152000000L));
        SimpleDateFormat dateFormat = simpleDateFormat;
        try {
            Date parsed = dateFormat.parse(string);
            return parsed.getTime();
        }
        catch (ParseException e) {
            throw new ProtocolException("Failed to parse UTCTime " + string);
        }
    }

    @NotNull
    public final String formatUtcTime$okhttp_tls(long date) {
        SimpleDateFormat simpleDateFormat;
        TimeZone utc = TimeZone.getTimeZone("GMT");
        SimpleDateFormat $this$formatUtcTime_u24lambda_u241 = simpleDateFormat = new SimpleDateFormat("yyMMddHHmmss'Z'");
        boolean bl = false;
        $this$formatUtcTime_u24lambda_u241.setTimeZone(utc);
        $this$formatUtcTime_u24lambda_u241.set2DigitYearStart(new Date(-631152000000L));
        SimpleDateFormat dateFormat = simpleDateFormat;
        String string = dateFormat.format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dateFormat.format(date)");
        return string;
    }

    @NotNull
    public final BasicDerAdapter<Long> getGENERALIZED_TIME() {
        return GENERALIZED_TIME;
    }

    @NotNull
    public final DerAdapter<AnyValue> getANY_VALUE() {
        return ANY_VALUE;
    }

    public final long parseGeneralizedTime$okhttp_tls(@NotNull String string) {
        SimpleDateFormat simpleDateFormat;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        TimeZone utc = TimeZone.getTimeZone("GMT");
        SimpleDateFormat $this$parseGeneralizedTime_u24lambda_u242 = simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        boolean bl = false;
        $this$parseGeneralizedTime_u24lambda_u242.setTimeZone(utc);
        SimpleDateFormat dateFormat = simpleDateFormat;
        try {
            Date parsed = dateFormat.parse(string);
            return parsed.getTime();
        }
        catch (ParseException e) {
            throw new ProtocolException("Failed to parse GeneralizedTime " + string);
        }
    }

    @NotNull
    public final String formatGeneralizedTime$okhttp_tls(long date) {
        SimpleDateFormat simpleDateFormat;
        TimeZone utc = TimeZone.getTimeZone("GMT");
        SimpleDateFormat $this$formatGeneralizedTime_u24lambda_u243 = simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        boolean bl = false;
        $this$formatGeneralizedTime_u24lambda_u243.setTimeZone(utc);
        SimpleDateFormat dateFormat = simpleDateFormat;
        String string = dateFormat.format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dateFormat.format(date)");
        return string;
    }

    @NotNull
    public final <T> BasicDerAdapter<T> sequence(@NotNull String name2, @NotNull DerAdapter<?>[] members, @NotNull Function1<? super T, ? extends List<?>> decompose, @NotNull Function1<? super List<?>, ? extends T> construct) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(members, (String)"members");
        Intrinsics.checkNotNullParameter(decompose, (String)"decompose");
        Intrinsics.checkNotNullParameter(construct, (String)"construct");
        BasicDerAdapter.Codec codec2 = new BasicDerAdapter.Codec<T>(members, construct, decompose){
            final /* synthetic */ DerAdapter<?>[] $members;
            final /* synthetic */ Function1<List<?>, T> $construct;
            final /* synthetic */ Function1<T, List<?>> $decompose;
            {
                this.$members = $members;
                this.$construct = $construct;
                this.$decompose = $decompose;
            }

            public T decode(@NotNull DerReader reader2) {
                Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
                return reader2.withTypeHint((Function0)new Function0<T>(this.$members, reader2, this.$construct){
                    final /* synthetic */ DerAdapter<?>[] $members;
                    final /* synthetic */ DerReader $reader;
                    final /* synthetic */ Function1<List<?>, T> $construct;
                    {
                        this.$members = $members;
                        this.$reader = $reader;
                        this.$construct = $construct;
                        super(0);
                    }

                    public final T invoke() {
                        List list2 = new ArrayList<E>();
                        while (list2.size() < this.$members.length) {
                            DerAdapter<?> member = this.$members[list2.size()];
                            ((Collection)list2).add(member.fromDer(this.$reader));
                        }
                        if (this.$reader.hasNext()) {
                            throw new ProtocolException("unexpected " + this.$reader.peekHeader() + " at " + this.$reader);
                        }
                        return (T)this.$construct.invoke((Object)list2);
                    }
                });
            }

            public void encode(@NotNull DerWriter writer2, T value2) {
                Intrinsics.checkNotNullParameter((Object)writer2, (String)"writer");
                List list2 = (List)this.$decompose.invoke(value2);
                writer2.withTypeHint((Function0)new Function0<Unit>(list2, this.$members, writer2){
                    final /* synthetic */ List<?> $list;
                    final /* synthetic */ DerAdapter<?>[] $members;
                    final /* synthetic */ DerWriter $writer;
                    {
                        this.$list = $list;
                        this.$members = $members;
                        this.$writer = $writer;
                        super(0);
                    }

                    public final void invoke() {
                        int n = this.$list.size();
                        for (int i2 = 0; i2 < n; ++i2) {
                            DerAdapter<?> adapter2;
                            Intrinsics.checkNotNull(this.$members[i2], (String)"null cannot be cast to non-null type okhttp3.tls.internal.der.DerAdapter<kotlin.Any?>");
                            adapter2.toDer(this.$writer, this.$list.get(i2));
                        }
                    }
                });
            }
        };
        return new BasicDerAdapter(name2, 0, 16L, codec2, false, null, false, 112, null);
    }

    @NotNull
    public final DerAdapter<Pair<DerAdapter<?>, Object>> choice(DerAdapter<?> ... choices) {
        Intrinsics.checkNotNullParameter(choices, (String)"choices");
        return new DerAdapter<Pair<? extends DerAdapter<?>, ? extends Object>>(choices){
            final /* synthetic */ DerAdapter<?>[] $choices;
            {
                this.$choices = $choices;
            }

            public boolean matches(@NotNull DerHeader header) {
                Intrinsics.checkNotNullParameter((Object)header, (String)"header");
                return true;
            }

            @NotNull
            public Pair<DerAdapter<?>, Object> fromDer(@NotNull DerReader reader2) {
                DerAdapter<?> derAdapter;
                DerHeader peekedHeader;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
                    DerHeader derHeader = reader2.peekHeader();
                    if (derHeader == null) {
                        throw new ProtocolException("expected a value at " + reader2);
                    }
                    peekedHeader = derHeader;
                    DerAdapter<?>[] $this$firstOrNull$iv = this.$choices;
                    boolean $i$f$firstOrNull = false;
                    int n = $this$firstOrNull$iv.length;
                    for (int j = 0; j < n; ++j) {
                        DerAdapter<?> element$iv;
                        DerAdapter<?> it = element$iv = $this$firstOrNull$iv[j];
                        boolean bl = false;
                        if (!it.matches(peekedHeader)) continue;
                        derAdapter = element$iv;
                        break block3;
                    }
                    derAdapter = null;
                }
                if (derAdapter == null) {
                    throw new ProtocolException("expected a matching choice but was " + peekedHeader + " at " + reader2);
                }
                DerAdapter<?> choice2 = derAdapter;
                return TuplesKt.to((Object)choice2, choice2.fromDer(reader2));
            }

            public void toDer(@NotNull DerWriter writer2, @NotNull Pair<? extends DerAdapter<?>, ? extends Object> value2) {
                Intrinsics.checkNotNullParameter((Object)writer2, (String)"writer");
                Intrinsics.checkNotNullParameter(value2, (String)"value");
                DerAdapter adapter2 = (DerAdapter)value2.component1();
                Object v = value2.component2();
                Intrinsics.checkNotNull((Object)adapter2, (String)"null cannot be cast to non-null type okhttp3.tls.internal.der.DerAdapter<kotlin.Any?>");
                adapter2.toDer(writer2, v);
            }

            @NotNull
            public String toString() {
                return ArraysKt.joinToString$default((Object[])this.$choices, (CharSequence)" OR ", null, null, (int)0, null, null, (int)62, null);
            }

            @NotNull
            public Pair<DerAdapter<?>, Object> fromDer(@NotNull ByteString byteString) {
                return (Pair)DerAdapter.DefaultImpls.fromDer(this, byteString);
            }

            @NotNull
            public ByteString toDer(@NotNull Pair<? extends DerAdapter<?>, ? extends Object> value2) {
                return DerAdapter.DefaultImpls.toDer(this, value2);
            }

            @NotNull
            public BasicDerAdapter<Pair<DerAdapter<?>, Object>> withExplicitBox(int tagClass, long tag, @Nullable Boolean forceConstructed) {
                return DerAdapter.DefaultImpls.withExplicitBox(this, tagClass, tag, forceConstructed);
            }

            @NotNull
            public BasicDerAdapter<List<Pair<DerAdapter<?>, Object>>> asSequenceOf(@NotNull String name2, int tagClass, long tag) {
                return DerAdapter.DefaultImpls.asSequenceOf(this, name2, tagClass, tag);
            }

            @NotNull
            public BasicDerAdapter<List<Pair<DerAdapter<?>, Object>>> asSetOf() {
                return DerAdapter.DefaultImpls.asSetOf(this);
            }
        };
    }

    @NotNull
    public final DerAdapter<Object> usingTypeHint(@NotNull Function1<Object, ? extends DerAdapter<?>> chooser) {
        Intrinsics.checkNotNullParameter(chooser, (String)"chooser");
        return new DerAdapter<Object>(chooser){
            final /* synthetic */ Function1<Object, DerAdapter<?>> $chooser;
            {
                this.$chooser = $chooser;
            }

            public boolean matches(@NotNull DerHeader header) {
                Intrinsics.checkNotNullParameter((Object)header, (String)"header");
                return true;
            }

            public void toDer(@NotNull DerWriter writer2, @Nullable Object value2) {
                Intrinsics.checkNotNullParameter((Object)writer2, (String)"writer");
                DerAdapter adapter2 = (DerAdapter)this.$chooser.invoke(writer2.getTypeHint());
                DerAdapter derAdapter = adapter2;
                if (derAdapter != null) {
                    derAdapter.toDer(writer2, value2);
                } else {
                    Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type okio.ByteString");
                    writer2.writeOctetString((ByteString)value2);
                }
            }

            @Nullable
            public Object fromDer(@NotNull DerReader reader2) {
                Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
                DerAdapter adapter2 = (DerAdapter)this.$chooser.invoke(reader2.getTypeHint());
                DerAdapter derAdapter = adapter2;
                return derAdapter != null ? derAdapter.fromDer(reader2) : reader2.readUnknown();
            }

            @NotNull
            public ByteString toDer(@Nullable Object value2) {
                return DerAdapter.DefaultImpls.toDer(this, value2);
            }

            @Nullable
            public Object fromDer(@NotNull ByteString byteString) {
                return DerAdapter.DefaultImpls.fromDer(this, byteString);
            }

            @NotNull
            public BasicDerAdapter<Object> withExplicitBox(int tagClass, long tag, @Nullable Boolean forceConstructed) {
                return DerAdapter.DefaultImpls.withExplicitBox(this, tagClass, tag, forceConstructed);
            }

            @NotNull
            public BasicDerAdapter<List<Object>> asSequenceOf(@NotNull String name2, int tagClass, long tag) {
                return DerAdapter.DefaultImpls.asSequenceOf(this, name2, tagClass, tag);
            }

            @NotNull
            public BasicDerAdapter<List<Object>> asSetOf() {
                return DerAdapter.DefaultImpls.asSetOf(this);
            }
        };
    }

    @NotNull
    public final DerAdapter<Object> any(@NotNull Pair<? extends KClass<?>, ? extends DerAdapter<?>>[] choices, boolean isOptional, @Nullable Object optionalValue) {
        Intrinsics.checkNotNullParameter(choices, (String)"choices");
        return new DerAdapter<Object>(isOptional, optionalValue, choices){
            final /* synthetic */ boolean $isOptional;
            final /* synthetic */ Object $optionalValue;
            final /* synthetic */ Pair<KClass<?>, DerAdapter<?>>[] $choices;
            {
                this.$isOptional = $isOptional;
                this.$optionalValue = $optionalValue;
                this.$choices = $choices;
            }

            public boolean matches(@NotNull DerHeader header) {
                Intrinsics.checkNotNullParameter((Object)header, (String)"header");
                return true;
            }

            public void toDer(@NotNull DerWriter writer2, @Nullable Object value2) {
                Intrinsics.checkNotNullParameter((Object)writer2, (String)"writer");
                if (!this.$isOptional || !Intrinsics.areEqual((Object)value2, (Object)this.$optionalValue)) {
                    for (Pair<KClass<?>, DerAdapter<?>> pair : this.$choices) {
                        KClass type2 = (KClass)pair.component1();
                        DerAdapter adapter2 = (DerAdapter)pair.component2();
                        if (!type2.isInstance(value2) && (value2 != null || !Intrinsics.areEqual((Object)type2, (Object)Reflection.getOrCreateKotlinClass(Unit.class)))) continue;
                        Intrinsics.checkNotNull((Object)adapter2, (String)"null cannot be cast to non-null type okhttp3.tls.internal.der.DerAdapter<kotlin.Any?>");
                        adapter2.toDer(writer2, value2);
                        return;
                    }
                }
            }

            @Nullable
            public Object fromDer(@NotNull DerReader reader2) {
                Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
                if (this.$isOptional && !reader2.hasNext()) {
                    return this.$optionalValue;
                }
                DerHeader derHeader = reader2.peekHeader();
                if (derHeader == null) {
                    throw new ProtocolException("expected a value at " + reader2);
                }
                DerHeader peekedHeader = derHeader;
                Pair<KClass<?>, DerAdapter<?>>[] pairArray = this.$choices;
                int n = pairArray.length;
                for (int j = 0; j < n; ++j) {
                    DerAdapter adapter2 = (DerAdapter)pairArray[j].component2();
                    if (!adapter2.matches(peekedHeader)) continue;
                    return adapter2.fromDer(reader2);
                }
                throw new ProtocolException("expected any but was " + peekedHeader + " at " + reader2);
            }

            @NotNull
            public ByteString toDer(@Nullable Object value2) {
                return DerAdapter.DefaultImpls.toDer(this, value2);
            }

            @Nullable
            public Object fromDer(@NotNull ByteString byteString) {
                return DerAdapter.DefaultImpls.fromDer(this, byteString);
            }

            @NotNull
            public BasicDerAdapter<Object> withExplicitBox(int tagClass, long tag, @Nullable Boolean forceConstructed) {
                return DerAdapter.DefaultImpls.withExplicitBox(this, tagClass, tag, forceConstructed);
            }

            @NotNull
            public BasicDerAdapter<List<Object>> asSequenceOf(@NotNull String name2, int tagClass, long tag) {
                return DerAdapter.DefaultImpls.asSequenceOf(this, name2, tagClass, tag);
            }

            @NotNull
            public BasicDerAdapter<List<Object>> asSetOf() {
                return DerAdapter.DefaultImpls.asSetOf(this);
            }
        };
    }

    public static /* synthetic */ DerAdapter any$default(Adapters adapters, Pair[] pairArray, boolean bl, Object object, int n, Object object2) {
        if ((n & 1) != 0) {
            Collection $this$toTypedArray$iv = defaultAnyChoices;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            pairArray = thisCollection$iv.toArray(new Pair[0]);
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            object = null;
        }
        return adapters.any(pairArray, bl, object);
    }

    static {
        Object[] objectArray = new Pair[12];
        objectArray[0] = TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE), BOOLEAN);
        objectArray[1] = TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(BigInteger.class), INTEGER_AS_BIG_INTEGER);
        objectArray[2] = TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(BitString.class), BIT_STRING);
        objectArray[3] = TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(ByteString.class), OCTET_STRING);
        objectArray[4] = TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Unit.class), NULL);
        objectArray[5] = TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Void.class), OBJECT_IDENTIFIER);
        objectArray[6] = TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Void.class), UTF8_STRING);
        objectArray[7] = TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(String.class), PRINTABLE_STRING);
        objectArray[8] = TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Void.class), IA5_STRING);
        objectArray[9] = TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Void.class), UTC_TIME);
        objectArray[10] = TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Long.TYPE), GENERALIZED_TIME);
        objectArray[11] = TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(AnyValue.class), ANY_VALUE);
        defaultAnyChoices = CollectionsKt.listOf((Object[])objectArray);
    }
}

