/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.X509TrustManager;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InsecureAndroidTrustManager
implements X509TrustManager {
    @NotNull
    private final X509TrustManager delegate;
    @NotNull
    private final List<String> insecureHosts;
    @Nullable
    private final Method checkServerTrustedMethod;

    public InsecureAndroidTrustManager(@NotNull X509TrustManager delegate, @NotNull List<String> insecureHosts) {
        Object object;
        InsecureAndroidTrustManager insecureAndroidTrustManager;
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter(insecureHosts, (String)"insecureHosts");
        this.delegate = delegate;
        this.insecureHosts = insecureHosts;
        InsecureAndroidTrustManager insecureAndroidTrustManager2 = this;
        try {
            insecureAndroidTrustManager = insecureAndroidTrustManager2;
            object = new Class[]{X509Certificate[].class, String.class, String.class};
            object = this.delegate.getClass().getMethod("checkServerTrusted", (Class<?>)object);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            insecureAndroidTrustManager = insecureAndroidTrustManager2;
            object = null;
        }
        insecureAndroidTrustManager.checkServerTrustedMethod = object;
    }

    @NotNull
    public final List<Certificate> checkServerTrusted(@NotNull X509Certificate[] chain, @NotNull String authType, @NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        if (this.insecureHosts.contains(host)) {
            return CollectionsKt.emptyList();
        }
        try {
            Method method = this.checkServerTrustedMethod;
            if (method == null) {
                throw new CertificateException("Failed to call checkServerTrusted");
            }
            Method method2 = method;
            Object[] objectArray = new Object[]{chain, authType, host};
            Object object = method2.invoke((Object)this.delegate, objectArray);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<java.security.cert.Certificate>");
            return (List)object;
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getTargetException();
            Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"e.targetException");
            throw throwable;
        }
    }

    @Override
    @NotNull
    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] x509CertificateArray = this.delegate.getAcceptedIssuers();
        Intrinsics.checkNotNullExpressionValue((Object)x509CertificateArray, (String)"delegate.acceptedIssuers");
        return x509CertificateArray;
    }

    @NotNull
    public Void checkClientTrusted(@NotNull X509Certificate[] chain, @Nullable String authType) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        throw new CertificateException("Unsupported operation");
    }

    @NotNull
    public Void checkServerTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
        throw new CertificateException("Unsupported operation");
    }
}

