/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls;

import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.internal.Util;
import okhttp3.internal.platform.Platform;
import okhttp3.tls.HeldCertificate;
import okhttp3.tls.internal.TlsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class HandshakeCertificates {
    @NotNull
    private final X509KeyManager keyManager;
    @NotNull
    private final X509TrustManager trustManager;

    private HandshakeCertificates(X509KeyManager keyManager, X509TrustManager trustManager) {
        this.keyManager = keyManager;
        this.trustManager = trustManager;
    }

    @JvmName(name="keyManager")
    @NotNull
    public final X509KeyManager keyManager() {
        return this.keyManager;
    }

    @JvmName(name="trustManager")
    @NotNull
    public final X509TrustManager trustManager() {
        return this.trustManager;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="keyManager", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_keyManager")
    @NotNull
    public final X509KeyManager -deprecated_keyManager() {
        return this.keyManager;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="trustManager", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_trustManager")
    @NotNull
    public final X509TrustManager -deprecated_trustManager() {
        return this.trustManager;
    }

    @NotNull
    public final SSLSocketFactory sslSocketFactory() {
        SSLSocketFactory sSLSocketFactory = this.sslContext().getSocketFactory();
        Intrinsics.checkNotNullExpressionValue((Object)sSLSocketFactory, (String)"sslContext().socketFactory");
        return sSLSocketFactory;
    }

    @NotNull
    public final SSLContext sslContext() {
        SSLContext sSLContext;
        SSLContext $this$sslContext_u24lambda_u240 = sSLContext = Platform.Companion.get().newSSLContext();
        boolean bl = false;
        Object[] objectArray = new KeyManager[]{this.keyManager};
        KeyManager[] keyManagerArray = objectArray;
        objectArray = new TrustManager[]{this.trustManager};
        $this$sslContext_u24lambda_u240.init(keyManagerArray, (TrustManager[])objectArray, new SecureRandom());
        return sSLContext;
    }

    public /* synthetic */ HandshakeCertificates(X509KeyManager keyManager, X509TrustManager trustManager, DefaultConstructorMarker $constructor_marker) {
        this(keyManager, trustManager);
    }

    @SourceDebugExtension(value={"SMAP\nHandshakeCertificates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HandshakeCertificates.kt\nokhttp3/tls/HandshakeCertificates$Builder\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,181:1\n26#2:182\n*S KotlinDebug\n*F\n+ 1 HandshakeCertificates.kt\nokhttp3/tls/HandshakeCertificates$Builder\n*L\n175#1:182\n*E\n"})
    public static final class Builder {
        @Nullable
        private HeldCertificate heldCertificate;
        @Nullable
        private X509Certificate[] intermediates;
        @NotNull
        private final List<X509Certificate> trustedCertificates = new ArrayList();
        @NotNull
        private final List<String> insecureHosts = new ArrayList();

        @NotNull
        public final Builder heldCertificate(@NotNull HeldCertificate heldCertificate, X509Certificate ... intermediates) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)heldCertificate, (String)"heldCertificate");
            Intrinsics.checkNotNullParameter((Object)intermediates, (String)"intermediates");
            Builder $this$heldCertificate_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$heldCertificate_u24lambda_u240.heldCertificate = heldCertificate;
            $this$heldCertificate_u24lambda_u240.intermediates = Arrays.copyOf(intermediates, intermediates.length);
            return builder;
        }

        @NotNull
        public final Builder addTrustedCertificate(@NotNull X509Certificate certificate2) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)certificate2, (String)"certificate");
            Builder $this$addTrustedCertificate_u24lambda_u241 = builder = this;
            boolean bl = false;
            ((Collection)$this$addTrustedCertificate_u24lambda_u241.trustedCertificates).add(certificate2);
            return builder;
        }

        @NotNull
        public final Builder addPlatformTrustedCertificates() {
            Builder builder;
            Builder $this$addPlatformTrustedCertificates_u24lambda_u242 = builder = this;
            boolean bl = false;
            X509TrustManager platformTrustManager = Platform.Companion.get().platformTrustManager();
            X509Certificate[] x509CertificateArray = platformTrustManager.getAcceptedIssuers();
            Collections.addAll((Collection)$this$addPlatformTrustedCertificates_u24lambda_u242.trustedCertificates, Arrays.copyOf(x509CertificateArray, x509CertificateArray.length));
            return builder;
        }

        @NotNull
        public final Builder addInsecureHost(@NotNull String hostname) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
            Builder $this$addInsecureHost_u24lambda_u243 = builder = this;
            boolean bl = false;
            ((Collection)$this$addInsecureHost_u24lambda_u243.insecureHosts).add(hostname);
            return builder;
        }

        @NotNull
        public final HandshakeCertificates build() {
            List<String> immutableInsecureHosts = Util.toImmutableList(this.insecureHosts);
            X509Certificate[] x509CertificateArray = this.intermediates;
            if (this.intermediates == null) {
                boolean $i$f$emptyArray = false;
                x509CertificateArray = new X509Certificate[]{};
            }
            X509Certificate[] x509CertificateArray2 = x509CertificateArray;
            X509KeyManager keyManager = TlsUtil.newKeyManager(null, this.heldCertificate, Arrays.copyOf(x509CertificateArray2, x509CertificateArray2.length));
            X509TrustManager trustManager = TlsUtil.newTrustManager(null, this.trustedCertificates, immutableInsecureHosts);
            return new HandshakeCertificates(keyManager, trustManager, null);
        }
    }
}

